/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.util.MathUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleCaseAction
extends TextComponentEditorAction {
    public ToggleCaseAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            Ref toLowerCase = new Ref((Object)Boolean.FALSE);
            Handler.runForCaret(editor, caret, c -> {
                if (!c.hasSelection()) {
                    c.selectWordAtCaret(true);
                }
                int selectionStartOffset = c.getSelectionStart();
                int selectionEndOffset = c.getSelectionEnd();
                String originalText = editor.getDocument().getText(new TextRange(selectionStartOffset, selectionEndOffset));
                if (!originalText.equals(Handler.toCase(editor, selectionStartOffset, selectionEndOffset, true))) {
                    toLowerCase.set((Object)Boolean.TRUE);
                }
            });
            Handler.runForCaret(editor, caret, c -> {
                VisualPosition caretPosition = c.getVisualPosition();
                int selectionStartOffset = c.getSelectionStart();
                int selectionEndOffset = c.getSelectionEnd();
                editor.getDocument().replaceString(selectionStartOffset, selectionEndOffset, (CharSequence)Handler.toCase(editor, selectionStartOffset, selectionEndOffset, (Boolean)toLowerCase.get()));
                c.moveToVisualPosition(caretPosition);
            });
        }

        private static void runForCaret(Editor editor, Caret caret, CaretAction action2) {
            if (caret == null) {
                editor.getCaretModel().runForEachCaret(action2);
            } else {
                action2.perform(caret);
            }
        }

        private static String toCase(Editor editor, int startOffset, int endOffset, boolean lower) {
            CharSequence text2 = editor.getDocument().getImmutableCharSequence();
            EditorHighlighter highlighter = editor.getHighlighter();
            HighlighterIterator iterator2 = highlighter.createIterator(startOffset);
            StringBuilder builder2 = new StringBuilder(endOffset - startOffset);
            while (!iterator2.atEnd()) {
                int start2 = MathUtil.clamp((int)iterator2.getStart(), (int)startOffset, (int)endOffset);
                int end = MathUtil.clamp((int)iterator2.getEnd(), (int)startOffset, (int)endOffset);
                CharSequence fragment2 = text2.subSequence(start2, end);
                builder2.append(iterator2.getTokenType() == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN ? fragment2 : (lower ? fragment2.toString().toLowerCase(Locale.getDefault()) : fragment2.toString().toUpperCase(Locale.getDefault())));
                if (end == endOffset) break;
                iterator2.advance();
            }
            return builder2.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/ToggleCaseAction$Handler", "executeWriteAction"));
        }
    }
}

