/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.DuplicateAction;
import com.intellij.openapi.util.Couple;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public final class DuplicateLinesAction
extends EditorAction {
    public DuplicateLinesAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (editor.getSelectionModel().hasSelection()) {
                int selStart = editor.getSelectionModel().getSelectionStart();
                int selEnd = editor.getSelectionModel().getSelectionEnd();
                if (selEnd > selStart && DocumentUtil.isAtLineStart(selEnd, editor.getDocument())) {
                    --selEnd;
                }
                VisualPosition rangeStart = editor.offsetToVisualPosition(Math.min(selStart, selEnd));
                VisualPosition rangeEnd = editor.offsetToVisualPosition(Math.max(selStart, selEnd));
                Couple<Integer> copiedRange = DuplicateAction.duplicateLinesRange(editor, editor.getDocument(), rangeStart, rangeEnd);
                if (copiedRange != null) {
                    editor.getSelectionModel().setSelection(((Integer)copiedRange.first).intValue(), ((Integer)copiedRange.second).intValue());
                }
            } else {
                VisualPosition caretPos = editor.getCaretModel().getVisualPosition();
                DuplicateAction.duplicateLinesRange(editor, editor.getDocument(), caretPos, caretPos);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/DuplicateLinesAction$Handler";
            objectArray[2] = "executeWriteAction";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

