/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplyFilePatchBase<T extends FilePatch>
implements ApplyFilePatch {
    protected static final Logger LOG = Logger.getInstance(ApplyFilePatchBase.class);
    protected final T myPatch;

    public ApplyFilePatchBase(T patch2) {
        this.myPatch = patch2;
    }

    public T getPatch() {
        return this.myPatch;
    }

    @Override
    public ApplyFilePatch.Result apply(@NotNull VirtualFile fileToPatch, ApplyPatchContext context2, @NotNull Project project, FilePath pathBeforeRename, Supplier<? extends CharSequence> baseContents, @Nullable CommitContext commitContext) throws IOException {
        if (fileToPatch == null) {
            ApplyFilePatchBase.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ApplyFilePatchBase.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("apply patch called for : " + fileToPatch.getPath());
        }
        if (this.myPatch.isNewFile()) {
            this.applyCreate(project, fileToPatch, commitContext);
        } else if (this.myPatch.isDeletedFile()) {
            FileEditorManager.getInstance((Project)project).closeFile(fileToPatch);
            fileToPatch.delete((Object)this);
        } else {
            return this.applyChange(project, fileToPatch, pathBeforeRename, baseContents);
        }
        return SUCCESS;
    }

    protected abstract void applyCreate(Project var1, VirtualFile var2, @Nullable CommitContext var3) throws IOException;

    protected abstract ApplyFilePatch.Result applyChange(Project var1, VirtualFile var2, FilePath var3, Supplier<? extends CharSequence> var4) throws IOException;

    @Nullable
    public static VirtualFile findPatchTarget(ApplyPatchContext context2, String beforeName, String afterName) throws IOException {
        VirtualFile file2 = null;
        if (beforeName != null) {
            file2 = ApplyFilePatchBase.findFileToPatchByName(context2, beforeName);
        }
        if (file2 == null) {
            file2 = ApplyFilePatchBase.findFileToPatchByName(context2, afterName);
        } else if (context2.isAllowRename() && afterName != null && !beforeName.equals(afterName)) {
            boolean needMove;
            String[] afterNameComponents;
            String[] beforeNameComponents = beforeName.split("/");
            if (!beforeNameComponents[beforeNameComponents.length - 1].equals((afterNameComponents = afterName.split("/"))[afterNameComponents.length - 1])) {
                context2.registerBeforeRename(file2);
                file2.rename(FilePatch.class, afterNameComponents[afterNameComponents.length - 1]);
            }
            boolean bl = needMove = beforeNameComponents.length != afterNameComponents.length;
            if (!needMove) {
                needMove = ApplyFilePatchBase.checkPackageRename(context2, beforeNameComponents, afterNameComponents);
            }
            if (needMove) {
                VirtualFile moveTarget = ApplyFilePatchBase.findFileToPatchByComponents(context2, afterNameComponents, afterNameComponents.length - 1);
                if (moveTarget == null) {
                    return null;
                }
                context2.registerBeforeRename(file2);
                file2.move(FilePatch.class, moveTarget);
            }
        }
        return file2;
    }

    private static boolean checkPackageRename(ApplyPatchContext context2, String[] beforeNameComponents, String[] afterNameComponents) {
        int changedIndex = -1;
        for (int i2 = context2.getSkipTopDirs(); i2 < afterNameComponents.length - 1; ++i2) {
            if (beforeNameComponents[i2].equals(afterNameComponents[i2])) continue;
            if (changedIndex != -1) {
                return true;
            }
            changedIndex = i2;
        }
        if (changedIndex == -1) {
            return false;
        }
        VirtualFile oldDir = ApplyFilePatchBase.findFileToPatchByComponents(context2, beforeNameComponents, changedIndex + 1);
        VirtualFile newDir = ApplyFilePatchBase.findFileToPatchByComponents(context2.getPrepareContext(), afterNameComponents, changedIndex + 1);
        return oldDir == null || newDir != null;
    }

    @Nullable
    private static VirtualFile findFileToPatchByName(@NotNull ApplyPatchContext context2, String fileName) {
        if (context2 == null) {
            ApplyFilePatchBase.$$$reportNull$$$0(2);
        }
        String[] pathNameComponents = fileName.split("/");
        int lastComponentToFind = pathNameComponents.length;
        return ApplyFilePatchBase.findFileToPatchByComponents(context2, pathNameComponents, lastComponentToFind);
    }

    @Nullable
    private static VirtualFile findFileToPatchByComponents(ApplyPatchContext context2, String[] pathNameComponents, int lastComponentToFind) {
        VirtualFile patchedDir = context2.getBaseDir();
        for (int i2 = context2.getSkipTopDirs(); i2 < lastComponentToFind; ++i2) {
            VirtualFile nextChild = pathNameComponents[i2].equals("..") ? patchedDir.getParent() : patchedDir.findChild(pathNameComponents[i2]);
            if (nextChild == null) {
                if (context2.isCreateDirectories()) {
                    try {
                        nextChild = patchedDir.createChildDirectory(null, pathNameComponents[i2]);
                    }
                    catch (IOException e) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            patchedDir = nextChild;
        }
        return patchedDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToPatch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/apply/ApplyFilePatchBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileToPatchByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

