/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UndoableGroup
implements Dumpable {
    private static final Logger LOG = Logger.getInstance(UndoableGroup.class);
    private static final int BULK_MODE_ACTION_THRESHOLD = 50;
    private final @NlsContexts.Command String myCommandName;
    private final boolean myGlobal;
    private final int myCommandTimestamp;
    private final boolean myTransparent;
    private final List<? extends UndoableAction> myActions;
    private EditorAndState myStateBefore;
    private EditorAndState myStateAfter;
    private final Project myProject;
    private final UndoConfirmationPolicy myConfirmationPolicy;
    private boolean myTemporary;
    private boolean myValid;

    UndoableGroup(@NlsContexts.Command String commandName2, boolean isGlobal, int commandTimestamp, EditorAndState stateBefore, EditorAndState stateAfter, @NotNull List<? extends UndoableAction> actions2, @NotNull UndoRedoStacksHolder stacksHolder, @Nullable Project project, UndoConfirmationPolicy confirmationPolicy, boolean transparent, boolean valid) {
        if (actions2 == null) {
            UndoableGroup.$$$reportNull$$$0(0);
        }
        if (stacksHolder == null) {
            UndoableGroup.$$$reportNull$$$0(1);
        }
        this.myCommandName = commandName2;
        this.myGlobal = isGlobal;
        this.myCommandTimestamp = commandTimestamp;
        this.myActions = actions2;
        this.myProject = project;
        this.myStateBefore = stateBefore;
        this.myStateAfter = stateAfter;
        this.myConfirmationPolicy = confirmationPolicy;
        this.myTransparent = transparent;
        this.myValid = valid;
        this.composeStartFinishGroup(stacksHolder);
        this.myTemporary = transparent;
    }

    boolean isGlobal() {
        return this.myGlobal;
    }

    boolean isTransparent() {
        return this.myTransparent;
    }

    boolean isTemporary() {
        return this.myTemporary;
    }

    void makePermanent() {
        this.myTemporary = false;
    }

    boolean isUndoable() {
        for (UndoableAction undoableAction : this.myActions) {
            if (!(undoableAction instanceof NonUndoableAction)) continue;
            return false;
        }
        return true;
    }

    void undo() throws UnexpectedUndoException {
        this.undoOrRedo(true);
    }

    void redo() throws UnexpectedUndoException {
        this.undoOrRedo(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoOrRedo(boolean isUndo) throws UnexpectedUndoException {
        LocalHistoryAction action2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing " + (isUndo ? "undo" : "redo") + " for " + this.dumpState());
        }
        if (this.myProject != null && this.isGlobal()) {
            String actionName = IdeBundle.message((String)(isUndo ? "undo.command" : "redo.command"), (Object[])new Object[]{this.myCommandName});
            action2 = LocalHistory.getInstance().startAction(actionName);
        } else {
            action2 = LocalHistoryAction.NULL;
        }
        try {
            this.doUndoOrRedo(isUndo);
        }
        finally {
            action2.finish();
        }
    }

    private void doUndoOrRedo(boolean isUndo) throws UnexpectedUndoException {
        UnexpectedUndoException[] exception = new UnexpectedUndoException[]{null};
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                List actionsList = isUndo ? ContainerUtil.reverse(this.myActions) : this.myActions;
                int toProcess = 0;
                int toProcessInBulk = 0;
                int actionCount = actionsList.size();
                for (int i2 = 0; i2 < actionCount; ++i2) {
                    UndoableAction action2 = (UndoableAction)actionsList.get(i2);
                    DocumentEx newDocument = UndoableGroup.getDocumentToSetBulkMode(action2);
                    if (newDocument != null) continue;
                    if (i2 - toProcessInBulk > 50) {
                        UndoableGroup.performActions(actionsList.subList(toProcess, toProcessInBulk), isUndo, false);
                        UndoableGroup.performActions(actionsList.subList(toProcessInBulk, i2), isUndo, true);
                        toProcess = i2;
                    }
                    toProcessInBulk = i2 + 1;
                }
                if (actionCount - toProcessInBulk > 50) {
                    UndoableGroup.performActions(actionsList.subList(toProcess, toProcessInBulk), isUndo, false);
                    UndoableGroup.performActions(actionsList.subList(toProcessInBulk, actionCount), isUndo, true);
                } else {
                    UndoableGroup.performActions(actionsList.subList(toProcess, actionCount), isUndo, false);
                }
            }
            catch (UnexpectedUndoException e) {
                exception[0] = e;
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performActions(@NotNull Collection<? extends UndoableAction> actions2, boolean isUndo, boolean useBulkMode) throws UnexpectedUndoException {
        if (actions2 == null) {
            UndoableGroup.$$$reportNull$$$0(2);
        }
        HashSet<DocumentEx> bulkDocuments = new HashSet<DocumentEx>();
        try {
            for (UndoableAction undoableAction : actions2) {
                if (useBulkMode) {
                    DocumentEx newDocument = UndoableGroup.getDocumentToSetBulkMode(undoableAction);
                    if (newDocument == null) {
                        for (DocumentEx document : bulkDocuments) {
                            document.setInBulkUpdate(false);
                        }
                        bulkDocuments.clear();
                    } else if (bulkDocuments.add(newDocument)) {
                        newDocument.setInBulkUpdate(true);
                    }
                }
                if (isUndo) {
                    undoableAction.undo();
                    continue;
                }
                undoableAction.redo();
            }
        }
        finally {
            for (DocumentEx documentEx : bulkDocuments) {
                documentEx.setInBulkUpdate(false);
            }
        }
    }

    @NotNull
    public String dumpState() {
        String string = "UndoableGroup[project=" + this.myProject + ", name=" + this.myCommandName + ", global=" + this.myGlobal + ", transparent=" + this.myTransparent + ", stamp=" + this.myCommandTimestamp + ", policy=" + this.myConfirmationPolicy + ", temporary=" + this.myTemporary + ", valid=" + this.myValid + ", actions=" + this.myActions + ", documents=" + this.getAffectedDocuments() + "]";
        if (string == null) {
            UndoableGroup.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static DocumentEx getDocumentToSetBulkMode(UndoableAction action2) {
        if (!(action2 instanceof EditorChangeAction)) {
            return null;
        }
        DocumentReference newDocumentRef = action2.getAffectedDocuments()[0];
        if (newDocumentRef == null) {
            return null;
        }
        VirtualFile file2 = newDocumentRef.getFile();
        if (file2 != null && !file2.isValid()) {
            return null;
        }
        return (DocumentEx)newDocumentRef.getDocument();
    }

    boolean isInsideStartFinishGroup(boolean isUndo, boolean isInsideStartFinishGroup) {
        int n;
        ArrayList<FinishMarkAction> finishMarks = new ArrayList<FinishMarkAction>();
        ArrayList<StartMarkAction> startMarks = new ArrayList<StartMarkAction>();
        for (UndoableAction undoableAction : this.myActions) {
            if (undoableAction instanceof StartMarkAction) {
                startMarks.add((StartMarkAction)undoableAction);
                continue;
            }
            if (!(undoableAction instanceof FinishMarkAction)) continue;
            finishMarks.add((FinishMarkAction)undoableAction);
        }
        int startNmb = startMarks.size();
        if (startNmb != (n = finishMarks.size())) {
            if (isUndo) {
                return n > startNmb;
            }
            return startNmb > n;
        }
        return isInsideStartFinishGroup;
    }

    private void composeStartFinishGroup(UndoRedoStacksHolder holder) {
        FinishMarkAction finishMark = this.getFinishMark();
        if (finishMark != null) {
            boolean global = false;
            String commandName2 = null;
            LinkedList stack = holder.getStack(finishMark.getAffectedDocument());
            Iterator iterator2 = stack.descendingIterator();
            while (iterator2.hasNext()) {
                UndoableGroup group2 = (UndoableGroup)iterator2.next();
                if (group2.isGlobal()) {
                    global = true;
                    commandName2 = group2.getCommandName();
                    break;
                }
                if (group2.getStartMark() == null) continue;
                break;
            }
            if (global) {
                finishMark.setGlobal(true);
                finishMark.setCommandName(commandName2);
            }
        }
    }

    private boolean shouldAskConfirmationForStartFinishGroup(boolean redo) {
        if (redo) {
            StartMarkAction mark = this.getStartMark();
            if (mark != null) {
                return mark.isGlobal();
            }
        } else {
            FinishMarkAction finishMark = this.getFinishMark();
            if (finishMark != null) {
                return finishMark.isGlobal();
            }
        }
        return false;
    }

    List<? extends UndoableAction> getActions() {
        return this.myActions;
    }

    @NotNull
    Collection<DocumentReference> getAffectedDocuments() {
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>();
        for (UndoableAction undoableAction : this.myActions) {
            DocumentReference[] refs = undoableAction.getAffectedDocuments();
            if (refs == null) continue;
            Collections.addAll(result2, refs);
        }
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoableGroup.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    EditorAndState getStateBefore() {
        return this.myStateBefore;
    }

    EditorAndState getStateAfter() {
        return this.myStateAfter;
    }

    void setStateBefore(EditorAndState stateBefore) {
        this.myStateBefore = stateBefore;
    }

    void setStateAfter(EditorAndState stateAfter) {
        this.myStateAfter = stateAfter;
    }

    @NlsContexts.Command
    String getCommandName() {
        for (UndoableAction undoableAction : this.myActions) {
            String commandName2;
            if (undoableAction instanceof StartMarkAction) {
                String commandName22 = ((StartMarkAction)undoableAction).getCommandName();
                if (commandName22 == null) continue;
                return commandName22;
            }
            if (!(undoableAction instanceof FinishMarkAction) || (commandName2 = ((FinishMarkAction)undoableAction).getCommandName()) == null) continue;
            return commandName2;
        }
        return this.myCommandName;
    }

    int getCommandTimestamp() {
        return this.myCommandTimestamp;
    }

    @Nullable
    private StartMarkAction getStartMark() {
        for (UndoableAction undoableAction : this.myActions) {
            if (!(undoableAction instanceof StartMarkAction)) continue;
            return (StartMarkAction)undoableAction;
        }
        return null;
    }

    @Nullable
    private FinishMarkAction getFinishMark() {
        for (UndoableAction undoableAction : this.myActions) {
            if (!(undoableAction instanceof FinishMarkAction)) continue;
            return (FinishMarkAction)undoableAction;
        }
        return null;
    }

    boolean shouldAskConfirmation(boolean redo) {
        if (this.shouldAskConfirmationForStartFinishGroup(redo)) {
            return true;
        }
        return this.myConfirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION || this.myConfirmationPolicy != UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION && this.myGlobal;
    }

    void invalidateChangeRanges() {
        for (UndoableAction undoableAction : this.myActions) {
            if (!(undoableAction instanceof AdjustableUndoableAction)) continue;
            ((AdjustableUndoableAction)undoableAction).invalidateChangeRanges();
        }
    }

    void invalidateActionsFor(DocumentReference ref) {
        if (this.getAffectedDocuments().contains(ref)) {
            this.myValid = false;
        }
    }

    boolean isValid() {
        return this.myValid;
    }

    public String toString() {
        boolean multiline;
        StringBuilder result2 = new StringBuilder("UndoableGroup[");
        boolean bl = multiline = this.myActions.size() > 1;
        if (multiline) {
            result2.append("\n");
        }
        result2.append(StringUtil.join(this.myActions, each -> (multiline ? "  " : "") + each.toString(), (String)",\n"));
        if (multiline) {
            result2.append("\n");
        }
        result2.append("]");
        return result2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacksHolder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoableGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoableGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performActions";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

