/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.MovementAvailability;
import com.intellij.openapi.command.impl.UndoRedoStacksHolderBase;
import com.intellij.openapi.command.undo.ActionChangeRange;
import com.intellij.openapi.command.undo.DocumentReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedUndoRedoStacksHolder
extends UndoRedoStacksHolderBase<ActionChangeRange> {
    SharedUndoRedoStacksHolder(boolean isUndo) {
        super(isUndo);
    }

    void addToStack(@NotNull DocumentReference reference2, @NotNull ActionChangeRange changeRange) {
        if (reference2 == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(0);
        }
        if (changeRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(1);
        }
        LinkedList<ActionChangeRange> stack = this.getStack(reference2);
        SharedUndoRedoStacksHolder.trimInvalid(stack);
        if (!changeRange.isValid()) {
            if (stack.isEmpty()) {
                return;
            }
            ActionChangeRange lastRange = stack.getLast();
            if (!lastRange.isValid() && SharedUndoRedoStacksHolder.isRolledBackBy(lastRange, changeRange)) {
                stack.removeLast();
                return;
            }
        }
        stack.add(changeRange);
    }

    private static boolean isRolledBackBy(@NotNull ActionChangeRange lastRange, @NotNull ActionChangeRange newRange) {
        if (lastRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(2);
        }
        if (newRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(3);
        }
        if (SharedUndoRedoStacksHolder.areSymmetric(lastRange, newRange)) {
            if (lastRange.getOldLength() == 0) {
                return true;
            }
            if (lastRange.getOriginatorId() == newRange.getOriginatorId()) {
                return true;
            }
        }
        return false;
    }

    private static boolean areSymmetric(@NotNull ActionChangeRange lastRange, @NotNull ActionChangeRange newRange) {
        if (lastRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(4);
        }
        if (newRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(5);
        }
        return lastRange.getOffset() == newRange.getOffset() && lastRange.getOldLength() == newRange.getNewLength() && lastRange.getNewLength() == newRange.getOldLength();
    }

    @NotNull
    ActionChangeRange removeLastFromStack(@NotNull DocumentReference reference2) {
        LinkedList<ActionChangeRange> stack;
        if (reference2 == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(6);
        }
        if ((stack = this.getStack(reference2)).isEmpty()) {
            throw new IllegalStateException("Cannot pop from empty stack");
        }
        ActionChangeRange last = (ActionChangeRange)stack.removeLast();
        SharedUndoRedoStacksHolder.trimInvalid(stack);
        ActionChangeRange actionChangeRange = last;
        if (actionChangeRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(7);
        }
        return actionChangeRange;
    }

    @NotNull
    MovementAvailability canMoveToStackTop(@NotNull DocumentReference reference2, @NotNull Set<ActionChangeRange> rangesToMove) {
        LinkedList<ActionChangeRange> stack;
        ActionChangeRange[] affected;
        if (reference2 == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(8);
        }
        if (rangesToMove == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(9);
        }
        if ((affected = SharedUndoRedoStacksHolder.getAffectedRanges(stack = this.getStack(reference2), rangesToMove)) == null) {
            MovementAvailability movementAvailability = MovementAvailability.ALREADY_MOVED;
            if (movementAvailability == null) {
                SharedUndoRedoStacksHolder.$$$reportNull$$$0(10);
            }
            return movementAvailability;
        }
        HashSet<ActionChangeRange> copiesToMove = new HashSet<ActionChangeRange>();
        for (int i2 = 0; i2 < affected.length; ++i2) {
            ActionChangeRange copy2 = affected[i2].createIndependentCopy(true);
            if (rangesToMove.contains(affected[i2])) {
                copiesToMove.add(copy2);
            }
            affected[i2] = copy2;
        }
        MovementAvailability movementAvailability = SharedUndoRedoStacksHolder.moveToEnd(affected, copiesToMove) ? MovementAvailability.CAN_MOVE : MovementAvailability.CANNOT_MOVE;
        if (movementAvailability == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(11);
        }
        return movementAvailability;
    }

    void moveToStackTop(@NotNull DocumentReference reference2, @NotNull Set<ActionChangeRange> rangesToMove) {
        LinkedList<ActionChangeRange> stack;
        ActionChangeRange[] affected;
        if (reference2 == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(12);
        }
        if (rangesToMove == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(13);
        }
        if ((affected = SharedUndoRedoStacksHolder.getAffectedRanges(stack = this.getStack(reference2), rangesToMove)) == null) {
            return;
        }
        if (!SharedUndoRedoStacksHolder.moveToEnd(affected, rangesToMove)) {
            throw new IllegalStateException("Cannot move to top: " + rangesToMove);
        }
        for (int i2 = 0; i2 < affected.length; ++i2) {
            stack.removeLast();
        }
        stack.addAll(Arrays.asList(affected));
        SharedUndoRedoStacksHolder.trimInvalid(stack);
    }

    private static ActionChangeRange @Nullable [] getAffectedRanges(@NotNull LinkedList<ActionChangeRange> stack, @NotNull Set<ActionChangeRange> rangesToMove) {
        if (stack == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(14);
        }
        if (rangesToMove == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(15);
        }
        HashSet<ActionChangeRange> notSeenRanges = new HashSet<ActionChangeRange>(rangesToMove);
        ListIterator<ActionChangeRange> iterator2 = stack.listIterator(stack.size());
        int affectedRangeCount = 0;
        while (iterator2.hasPrevious()) {
            ++affectedRangeCount;
            ActionChangeRange changeRange = iterator2.previous();
            notSeenRanges.remove(changeRange);
            if (!notSeenRanges.isEmpty()) continue;
            break;
        }
        if (!notSeenRanges.isEmpty()) {
            throw new IllegalArgumentException("Stack doesn't contain these ranges: " + notSeenRanges);
        }
        if (affectedRangeCount == rangesToMove.size()) {
            return null;
        }
        ActionChangeRange[] affected = new ActionChangeRange[affectedRangeCount];
        for (int i2 = 0; i2 < affectedRangeCount; ++i2) {
            affected[i2] = iterator2.next();
        }
        return affected;
    }

    private static boolean moveToEnd(ActionChangeRange @NotNull [] ranges, @NotNull Set<ActionChangeRange> rangesToMove) {
        if (rangesToMove == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(16);
        }
        if (ranges == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(17);
        }
        for (int pass = 0; pass < rangesToMove.size(); ++pass) {
            int destinationIndex;
            int currentIndex;
            for (currentIndex = destinationIndex = ranges.length - pass - 1; currentIndex >= 0 && !rangesToMove.contains(ranges[currentIndex]); --currentIndex) {
            }
            if (currentIndex < 0) {
                throw new IllegalArgumentException("Array doesn't contain specified ranges");
            }
            while (currentIndex < destinationIndex) {
                if (!SharedUndoRedoStacksHolder.swap(ranges, currentIndex)) {
                    return false;
                }
                ++currentIndex;
            }
        }
        return true;
    }

    private static boolean swap(ActionChangeRange @NotNull [] ranges, int i2) {
        ActionChangeRange second;
        ActionChangeRange first;
        if (ranges == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(18);
        }
        if ((first = ranges[i2]).moveAfter(second = ranges[i2 + 1], true) && second.moveAfter(first.asInverted(), false)) {
            ranges[i2 + 1] = first;
            ranges[i2] = second;
            return true;
        }
        return false;
    }

    void trimStacks(@NotNull Iterable<DocumentReference> references) {
        if (references == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(19);
        }
        for (DocumentReference reference2 : references) {
            SharedUndoRedoStacksHolder.trimInvalid(this.getStack(reference2));
        }
        this.removeEmptyStacks();
    }

    private static void trimInvalid(@NotNull List<ActionChangeRange> stack) {
        if (stack == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(20);
        }
        Iterator<ActionChangeRange> iterator2 = stack.iterator();
        while (iterator2.hasNext()) {
            ActionChangeRange next = iterator2.next();
            if (next.isValid()) {
                return;
            }
            iterator2.remove();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeRange";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastRange";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRange";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/SharedUndoRedoStacksHolder";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesToMove";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/SharedUndoRedoStacksHolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastFromStack";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "canMoveToStackTop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addToStack";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRolledBackBy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areSymmetric";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeLastFromStack";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canMoveToStackTop";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveToStackTop";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedRanges";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "moveToEnd";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "swap";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "trimStacks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "trimInvalid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

