/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.client;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientAppSessionsManager;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientProjectSessionsManager;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u0015*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001b\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/client/ClientSessionsManager;", "T", "Lcom/intellij/openapi/client/ClientSession;", "", "()V", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/codeWithMe/ClientId;", "getSession", "clientId", "(Lcom/intellij/codeWithMe/ClientId;)Lcom/intellij/openapi/client/ClientSession;", "getSessions", "", "includeLocal", "", "registerSession", "", "disposable", "Lcom/intellij/openapi/Disposable;", "session", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/client/ClientSession;)V", "Companion", "Lcom/intellij/openapi/client/ClientAppSessionsManager;", "Lcom/intellij/openapi/client/ClientProjectSessionsManager;", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@ApiStatus.Internal
public abstract class ClientSessionsManager<T extends ClientSession> {
    private final ConcurrentHashMap<ClientId, T> sessions = new ConcurrentHashMap();
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> getSessions(boolean includeLocal) {
        void $this$filterTo$iv$iv;
        if (includeLocal) {
            Collection<T> collection = this.sessions.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"sessions.values");
            return CollectionsKt.toList((Iterable)collection);
        }
        Collection<T> collection = this.sessions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"sessions.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClientSession it = (ClientSession)element$iv$iv;
            boolean bl = false;
            if (!(!it.isLocal())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final T getSession(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        return (T)((ClientSession)this.sessions.get(clientId));
    }

    public final void registerSession(@NotNull Disposable disposable2, @NotNull T session2) {
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        Intrinsics.checkNotNullParameter(session2, (String)"session");
        ClientId clientId = session2.getClientId();
        if (this.sessions.putIfAbsent(clientId, session2) != null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ClientSessionsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Session with '" + clientId + "' is already registered");
        }
        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)session2));
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(this, clientId){
            final /* synthetic */ ClientSessionsManager this$0;
            final /* synthetic */ ClientId $clientId;

            public final void dispose() {
                ClientSessionsManager.access$getSessions$p(this.this$0).remove(this.$clientId);
            }
            {
                this.this$0 = clientSessionsManager;
                this.$clientId = clientId;
            }
        });
    }

    private ClientSessionsManager() {
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSessions$p(ClientSessionsManager $this) {
        return $this.sessions;
    }

    public /* synthetic */ ClientSessionsManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientProjectSession getProjectSession(@NotNull Project project, @NotNull ClientId clientId) {
        return Companion.getProjectSession(project, clientId);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientProjectSession getProjectSession(@NotNull Project project) {
        return com.intellij.openapi.client.ClientSessionsManager$Companion.getProjectSession$default(Companion, project, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientAppSession getAppSession(@NotNull ClientId clientId) {
        return Companion.getAppSession(clientId);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientAppSession getAppSession() {
        return com.intellij.openapi.client.ClientSessionsManager$Companion.getAppSession$default(Companion, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final List<ClientProjectSession> getProjectSessions(@NotNull Project project, boolean includeLocal) {
        return Companion.getProjectSessions(project, includeLocal);
    }

    @JvmStatic
    @NotNull
    public static final List<ClientAppSession> getAppSessions(boolean includeLocal) {
        return Companion.getAppSessions(includeLocal);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u000b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/client/ClientSessionsManager$Companion;", "", "()V", "getAppSession", "Lcom/intellij/openapi/client/ClientAppSession;", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "getAppSessions", "", "includeLocal", "", "getInstance", "Lcom/intellij/openapi/client/ClientAppSessionsManager;", "Lcom/intellij/openapi/client/ClientProjectSessionsManager;", "project", "Lcom/intellij/openapi/project/Project;", "getProjectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "getProjectSessions", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientProjectSession getProjectSession(@NotNull Project project, @NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            return (ClientProjectSession)this.getInstance(project).getSession(clientId);
        }

        public static /* synthetic */ ClientProjectSession getProjectSession$default(Companion companion, Project project, ClientId clientId, int n, Object object) {
            if ((n & 2) != 0) {
                clientId = ClientId.Companion.getCurrent();
            }
            return companion.getProjectSession(project, clientId);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientProjectSession getProjectSession(@NotNull Project project) {
            return com.intellij.openapi.client.ClientSessionsManager$Companion.getProjectSession$default(this, project, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientAppSession getAppSession(@NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            return (ClientAppSession)this.getInstance().getSession(clientId);
        }

        public static /* synthetic */ ClientAppSession getAppSession$default(Companion companion, ClientId clientId, int n, Object object) {
            if ((n & 1) != 0) {
                clientId = ClientId.Companion.getCurrent();
            }
            return companion.getAppSession(clientId);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientAppSession getAppSession() {
            return com.intellij.openapi.client.ClientSessionsManager$Companion.getAppSession$default(this, null, 1, null);
        }

        @JvmStatic
        @NotNull
        public final List<ClientProjectSession> getProjectSessions(@NotNull Project project, boolean includeLocal) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(project).getSessions(includeLocal);
        }

        @JvmStatic
        @NotNull
        public final List<ClientAppSession> getAppSessions(boolean includeLocal) {
            return this.getInstance().getSessions(includeLocal);
        }

        @ApiStatus.Internal
        @NotNull
        public final ClientAppSessionsManager getInstance() {
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.client.ClientAppSessionsManager");
            }
            return (ClientAppSessionsManager)object;
        }

        @ApiStatus.Internal
        @NotNull
        public final ClientProjectSessionsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ClientSessionsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.client.ClientProjectSessionsManager");
            }
            return (ClientProjectSessionsManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

