/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ModalityStateEx
extends ModalityState {
    private final WeakList<Object> myModalEntities;
    private static final Set<Object> ourTransparentEntities = Collections.newSetFromMap(CollectionFactory.createConcurrentWeakMap());

    public ModalityStateEx() {
        this.myModalEntities = new WeakList();
    }

    ModalityStateEx(@NotNull Collection<Object> modalEntities) {
        if (modalEntities == null) {
            ModalityStateEx.$$$reportNull$$$0(0);
        }
        this.myModalEntities = new WeakList();
        this.myModalEntities.addAll(modalEntities);
    }

    @NotNull
    List<Object> getModalEntities() {
        List list2 = this.myModalEntities.toStrongList();
        if (list2 == null) {
            ModalityStateEx.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public ModalityState appendProgress(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            ModalityStateEx.$$$reportNull$$$0(2);
        }
        ModalityStateEx modalityStateEx = this.appendEntity(progress2);
        if (modalityStateEx == null) {
            ModalityStateEx.$$$reportNull$$$0(3);
        }
        return modalityStateEx;
    }

    @NotNull
    ModalityStateEx appendEntity(@NotNull Object anEntity) {
        if (anEntity == null) {
            ModalityStateEx.$$$reportNull$$$0(4);
        }
        List<Object> modalEntities = this.getModalEntities();
        ArrayList<Object> list2 = new ArrayList<Object>(modalEntities.size() + 1);
        list2.addAll(modalEntities);
        list2.add(anEntity);
        return new ModalityStateEx(list2);
    }

    void forceModalEntities(List<Object> entities2) {
        this.myModalEntities.clear();
        this.myModalEntities.addAll(entities2);
    }

    public boolean dominates(@NotNull ModalityState anotherState) {
        if (anotherState == null) {
            ModalityStateEx.$$$reportNull$$$0(5);
        }
        if (anotherState == ModalityState.any()) {
            return false;
        }
        if (this.myModalEntities.isEmpty()) {
            return false;
        }
        List<Object> otherEntities = ((ModalityStateEx)anotherState).getModalEntities();
        for (Object entity : this.getModalEntities()) {
            if (otherEntities.contains(entity) || ourTransparentEntities.contains(entity)) continue;
            return true;
        }
        return false;
    }

    @NonNls
    public String toString() {
        return this == NON_MODAL ? "ModalityState.NON_MODAL" : "ModalityState:{" + StringUtil.join(this.getModalEntities(), it -> "[" + it + "]", (String)", ") + "}";
    }

    void removeModality(Object modalEntity) {
        this.myModalEntities.remove(modalEntity);
    }

    void markTransparent() {
        Object element2 = ContainerUtil.getLastItem(this.getModalEntities(), null);
        if (element2 != null) {
            ourTransparentEntities.add(element2);
        }
    }

    static void unmarkTransparent(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            ModalityStateEx.$$$reportNull$$$0(6);
        }
        ourTransparentEntities.remove(modalEntity);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntities";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ModalityStateEx";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anEntity";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ModalityStateEx";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalEntities";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "appendProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendProgress";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendEntity";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dominates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unmarkTransparent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

