/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public final class PopupMenuPreloader
implements Runnable {
    private static final Logger LOG = Logger.getInstance(PopupMenuPreloader.class);
    private static int ourEditorContextMenuPreloadCount;
    private final Supplier<? extends ActionGroup> myGroupSupplier;
    private final String myPlace;
    private final WeakReference<JComponent> myComponentRef;
    private final WeakReference<PopupHandler> myPopupHandlerRef;
    private boolean myDisposed;

    public static void install(final @NotNull JComponent component2, @NotNull String actionPlace, @Nullable PopupHandler popupHandler, @NotNull Supplier<? extends ActionGroup> groupSupplier) {
        if (component2 == null) {
            PopupMenuPreloader.$$$reportNull$$$0(0);
        }
        if (actionPlace == null) {
            PopupMenuPreloader.$$$reportNull$$$0(1);
        }
        if (groupSupplier == null) {
            PopupMenuPreloader.$$$reportNull$$$0(2);
        }
        if (component2 instanceof EditorComponentImpl && ourEditorContextMenuPreloadCount > 4) {
            return;
        }
        final Runnable runnable2 = () -> {
            if (popupHandler != null && !ArrayUtil.contains((Object)popupHandler, (Object[])component2.getMouseListeners()) || component2 instanceof EditorComponentImpl && !EditorUtil.isRealFileEditor(((EditorComponentImpl)component2).getEditor())) {
                return;
            }
            PopupMenuPreloader preloader = new PopupMenuPreloader(component2, actionPlace, popupHandler, groupSupplier);
            IdeEventQueue.getInstance().addIdleListener(preloader, 2000);
        };
        UiNotifyConnector.doWhenFirstShown((JComponent)component2, (Runnable)runnable2);
        component2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                component2.removeFocusListener(this);
                runnable2.run();
            }
        });
    }

    private PopupMenuPreloader(@NotNull JComponent component2, @NotNull String actionPlace, @Nullable PopupHandler popupHandler, @NotNull Supplier<? extends ActionGroup> groupSupplier) {
        if (component2 == null) {
            PopupMenuPreloader.$$$reportNull$$$0(3);
        }
        if (actionPlace == null) {
            PopupMenuPreloader.$$$reportNull$$$0(4);
        }
        if (groupSupplier == null) {
            PopupMenuPreloader.$$$reportNull$$$0(5);
        }
        this.myComponentRef = new WeakReference<JComponent>(component2);
        this.myPopupHandlerRef = popupHandler == null ? null : new WeakReference<PopupHandler>(popupHandler);
        this.myGroupSupplier = groupSupplier;
        this.myPlace = actionPlace;
    }

    @Override
    public void run() {
        PopupHandler popupHandler;
        JComponent component2 = (JComponent)this.myComponentRef.get();
        PopupHandler popupHandler2 = popupHandler = this.myPopupHandlerRef == null ? null : (PopupHandler)this.myPopupHandlerRef.get();
        if (component2 == null || !component2.isShowing() || this.myPopupHandlerRef != null && (popupHandler == null || !ArrayUtil.contains((Object)popupHandler, (Object[])component2.getMouseListeners()))) {
            this.dispose(-1L);
            return;
        }
        ActionGroup actionGroup2 = this.myGroupSupplier.get();
        if (actionGroup2 == null) {
            this.dispose(-1L);
            return;
        }
        DataContext dataContext = Utils.wrapToAsyncDataContext(DataManager.getInstance().getDataContext((Component)component2));
        boolean isInModalContext = ModalityState.stateForComponent((Component)component2).dominates(ModalityState.NON_MODAL);
        long start2 = System.nanoTime();
        CancellablePromise<List<AnAction>> promise = Utils.expandActionGroupAsync(isInModalContext, actionGroup2, new PresentationFactory(), dataContext, this.myPlace);
        promise.onSuccess(__ -> this.dispose(TimeoutUtil.getDurationMillis((long)start2)));
    }

    private void dispose(long millis) {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        IdeEventQueue.getInstance().removeIdleListener(this);
        if (millis != -1L) {
            if (this.myComponentRef.get() instanceof EditorComponentImpl) {
                ++ourEditorContextMenuPreloadCount;
            }
            LOG.info("Popup menu preloaded for `" + this.myPlace + "` in " + millis + " ms");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionPlace";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupSupplier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/PopupMenuPreloader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

