/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.StubItem;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBMenu;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.plaf.beg.IdeaMenuUI;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jetbrains.annotations.NotNull;

public final class ActionMenu
extends JBMenu {
    private final String myPlace;
    private DataContext myContext;
    private final ActionRef<ActionGroup> myGroup;
    private final PresentationFactory myPresentationFactory;
    private final Presentation myPresentation;
    private boolean myMnemonicEnabled;
    private MenuItemSynchronizer myMenuItemSynchronizer;
    private StubItem myStubItem;
    private final boolean myUseDarkIcons;
    private Disposable myDisposable;
    private JPopupMenu mySpecialMenu;

    public ActionMenu(DataContext context2, @NotNull String place, ActionGroup group2, PresentationFactory presentationFactory, boolean enableMnemonics, boolean useDarkIcons) {
        if (place == null) {
            ActionMenu.$$$reportNull$$$0(0);
        }
        this.myContext = context2;
        this.myPlace = place;
        this.myGroup = ActionRef.fromAction(group2);
        this.myPresentationFactory = presentationFactory;
        this.myPresentation = this.myPresentationFactory.getPresentation((AnAction)group2);
        this.myMnemonicEnabled = enableMnemonics;
        this.myUseDarkIcons = useDarkIcons;
        this.updateUI();
        this.init();
        if (SystemInfo.isMacSystemMenu) {
            this.installSynchronizer();
        }
        this.getPopupMenu();
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        if (!(this.getParent() instanceof JMenuBar)) {
            return super.getComponentGraphics(graphics);
        }
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(graphics));
    }

    public void updateContext(DataContext context2) {
        this.myContext = context2;
    }

    public AnAction getAnAction() {
        return this.myGroup.getAction();
    }

    public void addNotify() {
        super.addNotify();
        this.installSynchronizer();
    }

    private void installSynchronizer() {
        if (this.myMenuItemSynchronizer == null) {
            this.myMenuItemSynchronizer = new MenuItemSynchronizer();
            this.myGroup.getAction().addPropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myPresentation.addPropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
        }
    }

    public void removeNotify() {
        this.uninstallSynchronizer();
        super.removeNotify();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    private void uninstallSynchronizer() {
        if (this.myMenuItemSynchronizer != null) {
            this.myGroup.getAction().removePropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myPresentation.removePropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myMenuItemSynchronizer = null;
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.mySpecialMenu == null) {
            this.mySpecialMenu = new JBPopupMenu();
            this.mySpecialMenu.setInvoker((Component)((Object)this));
            this.popupListener = this.createWinListener(this.mySpecialMenu);
            ReflectionUtil.setField(JMenu.class, (Object)((Object)this), JPopupMenu.class, (String)"popupMenu", (Object)this.mySpecialMenu);
        }
        return super.getPopupMenu();
    }

    public void updateUI() {
        this.setUI(IdeaMenuUI.createUI((JComponent)((Object)this)));
        this.setFont(UIUtil.getMenuFont());
        JPopupMenu popupMenu = this.getPopupMenu();
        if (popupMenu != null) {
            popupMenu.updateUI();
        }
    }

    private void init() {
        boolean macSystemMenu = SystemInfo.isMacSystemMenu && this.myPlace.equals("MainMenu");
        this.myStubItem = macSystemMenu ? null : new StubItem();
        this.addStubItem();
        this.setBorderPainted(false);
        MenuListenerImpl menuListener = new MenuListenerImpl();
        this.addMenuListener(menuListener);
        this.getModel().addChangeListener(menuListener);
        this.setVisible(this.myPresentation.isVisible());
        this.setEnabled(this.myPresentation.isEnabled());
        this.setText(this.myPresentation.getText());
        this.updateIcon();
        this.setMnemonicEnabled(this.myMnemonicEnabled);
    }

    private void addStubItem() {
        if (this.myStubItem != null) {
            this.add(this.myStubItem);
        }
    }

    public void setMnemonicEnabled(boolean enable2) {
        this.myMnemonicEnabled = enable2;
        this.setText(this.myPresentation.getText(enable2));
        this.setMnemonic(this.myPresentation.getMnemonic());
        this.setDisplayedMnemonicIndex(this.myPresentation.getDisplayedMnemonicIndex());
    }

    public void setDisplayedMnemonicIndex(int index2) throws IllegalArgumentException {
        super.setDisplayedMnemonicIndex(this.myMnemonicEnabled ? index2 : -1);
    }

    public void setMnemonic(int mnemonic) {
        super.setMnemonic(this.myMnemonicEnabled ? mnemonic : 0);
    }

    private void updateIcon() {
        UISettings settings2 = UISettings.getInstanceOrNull();
        if (settings2 != null && settings2.getShowIconsInMenus()) {
            Presentation presentation2 = this.myPresentation;
            Icon icon2 = presentation2.getIcon();
            if (SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace) && icon2 != null) {
                icon2 = IconLoader.getMenuBarIcon((Icon)icon2, (boolean)this.myUseDarkIcons);
            }
            if (ActionMenu.isShowIcons()) {
                this.setIcon(null);
                this.setDisabledIcon(null);
            } else {
                this.setIcon(icon2);
                if (presentation2.getDisabledIcon() != null) {
                    this.setDisabledIcon(presentation2.getDisabledIcon());
                } else {
                    this.setDisabledIcon(icon2 == null ? null : IconLoader.getDisabledIcon((Icon)icon2));
                }
            }
        }
    }

    static boolean isShowIcons() {
        return SystemInfo.isMac && Registry.get((String)"ide.macos.main.menu.alignment.options").isOptionEnabled("No icons");
    }

    static boolean isAligned() {
        return SystemInfo.isMac && Registry.get((String)"ide.macos.main.menu.alignment.options").isOptionEnabled("Aligned");
    }

    static boolean isAlignedInGroup() {
        return SystemInfo.isMac && Registry.get((String)"ide.macos.main.menu.alignment.options").isOptionEnabled("Aligned in group");
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.showDescriptionInStatusBar(isIncluded, (Component)((Object)this), this.myPresentation.getDescription());
    }

    public static void showDescriptionInStatusBar(boolean isIncluded, Component component2, @NlsContexts.StatusBarText String description2) {
        StatusBar statusBar2;
        IdeFrame frame = (IdeFrame)(component2 instanceof IdeFrame ? component2 : SwingUtilities.getAncestorOfClass(IdeFrame.class, component2));
        if (frame != null && (statusBar2 = frame.getStatusBar()) != null) {
            statusBar2.setInfo(isIncluded ? description2 : null);
        }
    }

    public void setPopupMenuVisible(boolean b) {
        if (!(!b || SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace))) {
            this.fillMenuWithRetries();
            if (!this.isSelected()) {
                return;
            }
        }
        super.setPopupMenuVisible(b);
    }

    private void fillMenuWithRetries() {
        while (!this.tryFillMenu() && this.isSelected()) {
        }
    }

    private boolean tryFillMenu() {
        try {
            this.fillMenu();
        }
        catch (Utils.ProcessCanceledWithReasonException ex) {
            String reasonStr;
            String string = reasonStr = ex.reason instanceof String ? (String)ex.reason : "";
            if (reasonStr.contains("write-action") || reasonStr.contains("fast-track")) {
                return false;
            }
            ExceptionUtil.rethrow((Throwable)((Object)ex));
        }
        catch (Throwable ex) {
            ExceptionUtil.rethrow((Throwable)ex);
        }
        return true;
    }

    public void clearItems() {
        if (SystemInfo.isMacSystemMenu && this.myPlace.equals("MainMenu")) {
            for (Component menuComponent : this.getMenuComponents()) {
                if (menuComponent instanceof ActionMenu) {
                    ((ActionMenu)((Object)menuComponent)).clearItems();
                    ((ActionMenu)((Object)menuComponent)).uninstallSynchronizer();
                    continue;
                }
                if (!(menuComponent instanceof ActionMenuItem) || SystemInfo.isMac) continue;
                ((ActionMenuItem)((Object)menuComponent)).setAccelerator(KeyStroke.getKeyStroke(61451, 0));
            }
        }
        this.removeAll();
        this.validate();
    }

    public void fillMenu() {
        DataContext context2;
        if (this.myContext != null) {
            context2 = this.myContext;
        } else {
            DataManager dataManager = DataManager.getInstance();
            DataContext contextFromFocus = dataManager.getDataContext();
            context2 = contextFromFocus;
            if (PlatformDataKeys.CONTEXT_COMPONENT.getData(context2) == null) {
                IdeFrame frame = (IdeFrame)ComponentUtil.getParentOfType(IdeFrame.class, (Component)((Object)this));
                context2 = dataManager.getDataContext(IdeFocusManager.getGlobalInstance().getLastFocusedFor((Window)frame));
            }
            context2 = Utils.wrapDataContext(context2);
        }
        boolean isDarkMenu = SystemInfo.isMacSystemMenu && NSDefaults.isDarkMenuBar();
        Utils.fillMenu(this.myGroup.getAction(), (JComponent)((Object)this), this.myMnemonicEnabled, this.myPresentationFactory, context2, this.myPlace, true, isDarkMenu, RelativePoint.getNorthEastOf((JComponent)((Object)this)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/ActionMenu", "<init>"));
    }

    private static final class UsabilityHelper
    implements IdeEventQueue.EventDispatcher,
    AWTEventListener,
    Disposable {
        private Component myComponent;
        private Point myStartMousePoint;
        private Point myUpperTargetPoint;
        private Point myLowerTargetPoint;
        private SingleAlarm myCallbackAlarm = new SingleAlarm(() -> {
            Disposer.dispose((Disposable)this.myCallbackAlarm);
            this.myCallbackAlarm = null;
            if (this.myEventToRedispatch != null) {
                IdeEventQueue.getInstance().dispatchEvent(this.myEventToRedispatch);
            }
        }, 50, ModalityState.any(), (Disposable)this);
        private MouseEvent myEventToRedispatch;

        private UsabilityHelper(Component component2) {
            this.myComponent = component2;
            PointerInfo info2 = MouseInfo.getPointerInfo();
            Point point = this.myStartMousePoint = info2 != null ? info2.getLocation() : null;
            if (this.myStartMousePoint != null) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 1L);
                IdeEventQueue.getInstance().addDispatcher(this, this);
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            ComponentEvent componentEvent;
            Component component2;
            JPopupMenu popup2;
            if (event instanceof ComponentEvent && (popup2 = (JPopupMenu)ComponentUtil.getParentOfType(JPopupMenu.class, (Component)(component2 = (componentEvent = (ComponentEvent)event).getComponent()))) != null && popup2.getInvoker() == this.myComponent && popup2.isShowing()) {
                Rectangle bounds2 = popup2.getBounds();
                if (bounds2.isEmpty()) {
                    return;
                }
                bounds2.setLocation(popup2.getLocationOnScreen());
                if (this.myStartMousePoint.x < bounds2.x) {
                    this.myUpperTargetPoint = new Point(bounds2.x, bounds2.y);
                    this.myLowerTargetPoint = new Point(bounds2.x, bounds2.y + bounds2.height);
                }
                if (this.myStartMousePoint.x > bounds2.x + bounds2.width) {
                    this.myUpperTargetPoint = new Point(bounds2.x + bounds2.width, bounds2.y);
                    this.myLowerTargetPoint = new Point(bounds2.x + bounds2.width, bounds2.y + bounds2.height);
                }
            }
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                UsabilityHelper.$$$reportNull$$$0(0);
            }
            if (e instanceof MouseEvent && this.myUpperTargetPoint != null && this.myLowerTargetPoint != null && this.myCallbackAlarm != null) {
                if (e.getID() == 501 || e.getID() == 502 || e.getID() == 500) {
                    return false;
                }
                Point point = ((MouseEvent)e).getLocationOnScreen();
                Rectangle bounds2 = this.myComponent.getBounds();
                bounds2.setLocation(this.myComponent.getLocationOnScreen());
                boolean isMouseMovingTowardsSubmenu = bounds2.contains(point) || new Polygon(new int[]{this.myStartMousePoint.x, this.myUpperTargetPoint.x, this.myLowerTargetPoint.x}, new int[]{this.myStartMousePoint.y, this.myUpperTargetPoint.y, this.myLowerTargetPoint.y}, 3).contains(point);
                this.myEventToRedispatch = (MouseEvent)e;
                if (!isMouseMovingTowardsSubmenu) {
                    this.myCallbackAlarm.request();
                } else {
                    this.myCallbackAlarm.cancel();
                }
                return true;
            }
            return false;
        }

        public void dispose() {
            this.myComponent = null;
            this.myEventToRedispatch = null;
            this.myLowerTargetPoint = null;
            this.myUpperTargetPoint = null;
            this.myStartMousePoint = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ActionMenu$UsabilityHelper", "dispatch"));
        }
    }

    private class MenuItemSynchronizer
    implements PropertyChangeListener {
        private MenuItemSynchronizer() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("visible".equals(name)) {
                ActionMenu.this.setVisible(ActionMenu.this.myPresentation.isVisible());
                if (SystemInfo.isMacSystemMenu && ActionMenu.this.myPlace.equals("MainMenu")) {
                    ActionMenu.this.validate();
                }
            } else if ("enabled".equals(name)) {
                ActionMenu.this.setEnabled(ActionMenu.this.myPresentation.isEnabled());
            } else if ("mnemonicKey".equals(name)) {
                ActionMenu.this.setMnemonic(ActionMenu.this.myPresentation.getMnemonic());
            } else if ("mnemonicIndex".equals(name)) {
                ActionMenu.this.setDisplayedMnemonicIndex(ActionMenu.this.myPresentation.getDisplayedMnemonicIndex());
            } else if ("textWithSuffix".equals(name)) {
                ActionMenu.this.setText(ActionMenu.this.myPresentation.getText(true));
            } else if ("icon".equals(name) || "disabledIcon".equals(name)) {
                ActionMenu.this.updateIcon();
            }
        }
    }

    private class MenuListenerImpl
    implements ChangeListener,
    MenuListener {
        ScheduledFuture myDelayedClear;
        boolean isSelected = false;

        private MenuListenerImpl() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ButtonModel model2 = (ButtonModel)e.getSource();
            boolean modelSelected = model2.isSelected();
            if (modelSelected != this.isSelected) {
                this.isSelected = modelSelected;
                if (modelSelected) {
                    this.menuSelected();
                } else {
                    this.menuDeselected();
                }
            }
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            this.onMenuHidden();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
        }

        private void menuDeselected() {
            if (ActionMenu.this.myDisposable != null) {
                Disposer.dispose((Disposable)ActionMenu.this.myDisposable);
                ActionMenu.this.myDisposable = null;
            }
            this.onMenuHidden();
        }

        private void onMenuHidden() {
            Runnable clearSelf = () -> {
                ActionMenu.this.clearItems();
                ActionMenu.this.addStubItem();
            };
            if (SystemInfo.isMacSystemMenu && ActionMenu.this.myPlace.equals("MainMenu")) {
                this.myDelayedClear = EdtScheduledExecutorService.getInstance().schedule(clearSelf, 1000L, TimeUnit.MILLISECONDS);
            } else {
                clearSelf.run();
            }
        }

        private void menuSelected() {
            UsabilityHelper helper = new UsabilityHelper((Component)((Object)ActionMenu.this));
            if (ActionMenu.this.myDisposable == null) {
                ActionMenu.this.myDisposable = Disposer.newDisposable();
            }
            Disposer.register((Disposable)ActionMenu.this.myDisposable, (Disposable)helper);
            if (this.myDelayedClear != null) {
                this.myDelayedClear.cancel(false);
                this.myDelayedClear = null;
                ActionMenu.this.clearItems();
            }
            if (SystemInfo.isMacSystemMenu && "MainMenu".equals(ActionMenu.this.myPlace)) {
                ActionMenu.this.fillMenuWithRetries();
            }
        }
    }
}

