/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationGroupEP
implements PluginAware {
    static final ExtensionPointName<NotificationGroupEP> EP_NAME = new ExtensionPointName("com.intellij.notificationGroup");
    @Attribute(value="id")
    @RequiredElement
    @NlsSafe
    public String id;
    @Attribute(value="displayType")
    @RequiredElement
    public DisplayType displayType;
    @Attribute(value="isLogByDefault")
    public boolean isLogByDefault = true;
    @Attribute(value="toolWindowId")
    public String toolWindowId;
    @Attribute(value="icon")
    public String icon;
    @Attribute(value="bundle")
    public String bundle;
    @Attribute(value="key")
    public @NlsContexts.NotificationTitle String key;
    @Attribute(value="notificationIds", converter=IdParser.class)
    @Nullable
    public List<String> notificationIds;
    private PluginDescriptor pluginDescriptor;

    @NlsContexts.NotificationTitle
    @Nullable
    public String getDisplayName(@NotNull PluginDescriptor pluginDescriptor) {
        String baseName;
        if (pluginDescriptor == null) {
            NotificationGroupEP.$$$reportNull$$$0(0);
        }
        String string = baseName = this.bundle == null ? pluginDescriptor.getResourceBundleBaseName() : this.bundle;
        if (baseName == null || this.key == null) {
            return this.id;
        }
        ResourceBundle resourceBundle = DynamicBundle.INSTANCE.getResourceBundle(baseName, pluginDescriptor.getPluginClassLoader());
        return BundleBase.messageOrDefault((ResourceBundle)resourceBundle, (String)this.key, null, (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            NotificationGroupEP.$$$reportNull$$$0(1);
        }
        return this.icon == null ? null : IconLoader.findIcon((String)this.icon, (ClassLoader)pluginDescriptor.getPluginClassLoader());
    }

    public void setPluginDescriptor(@NotNull PluginDescriptor value2) {
        if (value2 == null) {
            NotificationGroupEP.$$$reportNull$$$0(2);
        }
        this.pluginDescriptor = value2;
    }

    @Nullable
    public NotificationDisplayType getDisplayType() {
        return this.displayType == null ? null : this.displayType.getNotificationDisplayType();
    }

    public String toString() {
        return "NotificationGroupEP{id='" + this.id + "', displayType=" + this.displayType + ", isLogByDefault=" + this.isLogByDefault + ", toolWindowId='" + this.toolWindowId + "', icon='" + this.icon + "', bundle='" + this.bundle + "', key='" + this.key + "', notificationIds='" + this.notificationIds + "', pluginDescriptor=" + this.pluginDescriptor + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/notification/impl/NotificationGroupEP";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setPluginDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum DisplayType {
        NONE(NotificationDisplayType.NONE),
        BALLOON(NotificationDisplayType.BALLOON),
        STICKY_BALLOON(NotificationDisplayType.STICKY_BALLOON),
        TOOL_WINDOW(NotificationDisplayType.TOOL_WINDOW);

        private final NotificationDisplayType myNotificationDisplayType;

        private DisplayType(NotificationDisplayType type) {
            this.myNotificationDisplayType = type;
        }

        NotificationDisplayType getNotificationDisplayType() {
            return this.myNotificationDisplayType;
        }
    }

    private static final class IdParser
    extends Converter<List<String>> {
        private IdParser() {
        }

        @NotNull
        public List<String> fromString(@NotNull String value2) {
            if (value2 == null) {
                IdParser.$$$reportNull$$$0(0);
            }
            if (value2.isEmpty()) {
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    IdParser.$$$reportNull$$$0(1);
                }
                return list2;
            }
            String[] values2 = StringUtilRt.convertLineSeparators((String)value2, (String)"").split(";");
            ArrayList<String> result2 = new ArrayList<String>(values2.length);
            for (String item : values2) {
                if (item.isEmpty()) continue;
                result2.add(item.trim());
            }
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                IdParser.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @NotNull
        public String toString(@NotNull List<String> ids) {
            if (ids == null) {
                IdParser.$$$reportNull$$$0(3);
            }
            String string = String.join((CharSequence)",", ids);
            if (string == null) {
                IdParser.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/NotificationGroupEP$IdParser";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ids";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/NotificationGroupEP$IdParser";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

