/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.BranchedVirtualFile;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BranchedVirtualFileImpl
extends BranchedVirtualFile {
    @NotNull
    private final ModelBranchImpl myBranch;
    private final boolean myDirectory;
    @Nullable
    private VirtualFile myOriginal;
    private BranchedVirtualFileImpl myChangedParent;
    private Ref<BranchedVirtualFileImpl[]> myChangedChildren;
    private byte[] myByteContent;

    BranchedVirtualFileImpl(@NotNull ModelBranchImpl branch, @Nullable VirtualFile original, @NotNull String name, boolean isDirectory, @Nullable BranchedVirtualFileImpl parent) {
        if (branch == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(1);
        }
        super(original, name);
        this.myChangedParent = parent;
        this.putUserData(AbstractFileViewProvider.FREE_THREADED, true);
        this.myOriginal = original;
        this.myBranch = branch;
        this.myDirectory = isDirectory;
    }

    @NotNull
    protected ModelBranchImpl getBranch() {
        this.myBranch.checkBranchIsAlive();
        ModelBranchImpl modelBranchImpl = this.myBranch;
        if (modelBranchImpl == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(2);
        }
        return modelBranchImpl;
    }

    public void setContent(Object requestor, @NotNull CharSequence content2, boolean fireEvent) {
        if (content2 == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("Branch files shouldn't be modified");
    }

    public boolean isDirectory() {
        this.myBranch.checkBranchIsAlive();
        return this.myDirectory;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        this.myBranch.checkBranchIsAlive();
        if (this.isDirectory()) {
            throw new IOException("Cannot write a directory: " + (Object)((Object)this));
        }
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM((OutputStream)new ByteArrayOutputStream(){

            @Override
            public void close() {
                assert (BranchedVirtualFileImpl.this.isWritable());
                BranchedVirtualFileImpl.this.setModificationStamp(newModificationStamp);
                BranchedVirtualFileImpl.access$102(BranchedVirtualFileImpl.this, this.toByteArray());
            }
        }, (VirtualFile)this);
        if (outputStream == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(4);
        }
        return outputStream;
    }

    @NotNull
    public CharSequence getContent() {
        this.myBranch.checkBranchIsAlive();
        if (this.isDirectory()) {
            throw new IllegalStateException("Cannot get content of directory: " + (Object)((Object)this));
        }
        if (!this.getFileType().isBinary()) {
            CharSequence charSequence;
            FileViewProvider vp;
            if (this.myOriginal != null && (vp = PsiManagerEx.getInstanceEx(this.myBranch.getProject()).getFileManager().findViewProvider(this.myOriginal)) != null) {
                Document document = FileDocumentManager.getInstance().getCachedDocument(this.myOriginal);
                if (document != null && PsiDocumentManager.getInstance((Project)this.myBranch.getProject()).isUncommited(document)) {
                    throw new IllegalStateException("Content loading is only allowed for committed original files");
                }
                String string = vp.getContents().toString();
                if (string == null) {
                    BranchedVirtualFileImpl.$$$reportNull$$$0(5);
                }
                return string;
            }
            try {
                charSequence = LoadTextUtil.getTextByBinaryPresentation(this.contentsToByteArray(), (VirtualFile)this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (charSequence == null) {
                BranchedVirtualFileImpl.$$$reportNull$$$0(6);
            }
            return charSequence;
        }
        throw new UnsupportedOperationException("No string content for binary file " + (Object)((Object)this));
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        this.myBranch.checkBranchIsAlive();
        if (this.isDirectory()) {
            throw new IOException("Cannot get content of directory: " + (Object)((Object)this));
        }
        if (this.myByteContent != null) {
            byte[] byArray = (byte[])this.myByteContent.clone();
            if (byArray == null) {
                BranchedVirtualFileImpl.$$$reportNull$$$0(7);
            }
            return byArray;
        }
        if (this.myOriginal == null) {
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                BranchedVirtualFileImpl.$$$reportNull$$$0(8);
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = this.myOriginal.contentsToByteArray();
        if (byArray == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(9);
        }
        return byArray;
    }

    public void rename(Object requestor, @NotNull String newName2) throws IOException {
        if (newName2 == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(10);
        }
        this.myBranch.checkBranchIsAlive();
        super.rename(requestor, newName2);
        BranchedVirtualFileImpl parent = this.getParent();
        if (parent != null && parent.myChangedChildren == null) {
            parent.myChangedChildren = Ref.create((Object)parent.getChildren());
        }
        this.myBranch.addVfsStructureChange(this);
    }

    public void move(Object requestor, @NotNull VirtualFile _newParent) {
        if (_newParent == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(11);
        }
        this.myBranch.checkBranchIsAlive();
        assert (ModelBranch.getFileBranch((VirtualFile)_newParent) == this.myBranch);
        BranchedVirtualFileImpl newParent = (BranchedVirtualFileImpl)_newParent;
        BranchedVirtualFileImpl oldParent = this.getParent();
        if (oldParent == null) {
            throw new UnsupportedOperationException("Unable to move root directory");
        }
        if (newParent.equals((Object)oldParent)) {
            return;
        }
        this.myChangedParent = newParent;
        oldParent.myChangedChildren = Ref.create((Object)((BranchedVirtualFileImpl[])ArrayUtil.remove((Object[])oldParent.getChildren(), (Object)((Object)this))));
        BranchedVirtualFileImpl newFile = this.isDirectory() ? new BranchedVirtualFileImpl(this.myBranch, this.myOriginal, this.getName(), true, newParent) : this;
        newParent.myChangedChildren = Ref.create((Object)((BranchedVirtualFileImpl[])ArrayUtil.insert((Object[])newParent.getChildren(), (int)0, (Object)((Object)newFile))));
        this.myBranch.addVfsStructureChange(this);
    }

    @Nullable
    public VirtualFile findChild(@NotNull String name) {
        if (name == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(12);
        }
        this.myBranch.checkBranchIsAlive();
        if (this.myChangedChildren != null) {
            BranchedVirtualFileImpl[] array2 = (BranchedVirtualFileImpl[])this.myChangedChildren.get();
            return array2 == null ? null : (VirtualFile)ContainerUtil.find((Object[])array2, f -> name.equals(f.getName()));
        }
        assert (this.myOriginal != null);
        VirtualFile child2 = this.myOriginal.findChild(name);
        VirtualFile copy2 = child2 == null ? null : this.myBranch.findFileCopy(child2);
        return copy2 != null && copy2.isValid() && this.equals(copy2.getParent()) && name.equals(copy2.getName()) ? copy2 : null;
    }

    public BranchedVirtualFileImpl getParent() {
        this.myBranch.checkBranchIsAlive();
        if (this.myChangedParent != null) {
            return this.myChangedParent;
        }
        assert (this.myOriginal != null);
        VirtualFile parent = this.myOriginal.getParent();
        return parent == null ? null : this.myBranch.findPhysicalFileCopy(parent);
    }

    public BranchedVirtualFileImpl[] getChildren() {
        this.myBranch.checkBranchIsAlive();
        if (this.myChangedChildren != null) {
            BranchedVirtualFileImpl[] array2 = (BranchedVirtualFileImpl[])this.myChangedChildren.get();
            return array2 == null || array2.length == 0 ? array2 : (BranchedVirtualFileImpl[])array2.clone();
        }
        assert (this.myOriginal != null);
        this.myBranch.assertAllChildrenLoaded(this.myOriginal);
        Object[] baseChildren = this.myOriginal.getChildren();
        if (baseChildren == null) {
            return null;
        }
        return (BranchedVirtualFileImpl[])ContainerUtil.map2Array((Object[])baseChildren, BranchedVirtualFileImpl.class, f -> Objects.requireNonNull(this.myBranch.findPhysicalFileCopy((VirtualFile)f)));
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) {
        if (name == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(13);
        }
        this.myBranch.checkBranchIsAlive();
        VirtualFile virtualFile2 = this.createChild(name, true);
        if (virtualFile2 == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(14);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) {
        if (name == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(15);
        }
        this.myBranch.checkBranchIsAlive();
        VirtualFile virtualFile2 = this.createChild(name, false);
        if (virtualFile2 == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(16);
        }
        return virtualFile2;
    }

    private VirtualFile createChild(String name, boolean isDirectory) {
        this.myBranch.checkBranchIsAlive();
        BranchedVirtualFileImpl created = new BranchedVirtualFileImpl(this.myBranch, null, name, isDirectory, this);
        this.myChangedChildren = Ref.create((Object)((BranchedVirtualFileImpl[])ArrayUtil.insert((Object[])this.getChildren(), (int)0, (Object)((Object)created))));
        created.myChangedChildren = Ref.create((Object)(isDirectory ? new BranchedVirtualFileImpl[]{} : null));
        this.myBranch.addVfsStructureChange(created);
        return created;
    }

    @Nullable
    VirtualFile getOriginal() {
        this.myBranch.checkBranchIsAlive();
        return this.myOriginal;
    }

    @NotNull
    VirtualFile getOrCreateOriginal() throws IOException {
        this.myBranch.checkBranchIsAlive();
        VirtualFile result2 = this.myOriginal;
        if (result2 == null) {
            this.myOriginal = result2 = this.createFile();
        }
        VirtualFile virtualFile2 = result2;
        if (virtualFile2 == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(17);
        }
        return virtualFile2;
    }

    @NotNull
    private VirtualFile createFile() throws IOException {
        VirtualFile original;
        this.myBranch.checkBranchIsAlive();
        String name = this.getName();
        VirtualFile originalParent = this.getParent().getOrCreateOriginal();
        VirtualFile virtualFile2 = original = this.isDirectory() ? originalParent.createChildDirectory((Object)this, name) : originalParent.createChildData((Object)this, name);
        if (!this.isDirectory()) {
            original.setBinaryContent(this.contentsToByteArray());
        }
        VirtualFile virtualFile3 = original;
        if (virtualFile3 == null) {
            BranchedVirtualFileImpl.$$$reportNull$$$0(18);
        }
        return virtualFile3;
    }

    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (!(obj2 instanceof BranchedVirtualFileImpl)) {
            return false;
        }
        return this.myOriginal != null && ((Object)((Object)this.myBranch)).equals((Object)((BranchedVirtualFileImpl)((Object)obj2)).myBranch) && this.myOriginal.equals(((BranchedVirtualFileImpl)((Object)obj2)).myOriginal);
    }

    public String toString() {
        return "BranchedVirtualFile[" + ((Object)((Object)this.myBranch)).hashCode() + "]: " + this.getPresentableUrl();
    }

    static /* synthetic */ byte[] access$102(BranchedVirtualFileImpl x0, byte[] x1) {
        x0.myByteContent = x1;
        return x1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/BranchedVirtualFileImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_newParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/BranchedVirtualFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranch";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateOriginal";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

