/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.generation.EscapingCommenter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class XmlCommenter
implements EscapingCommenter {
    private static final String DOUBLE_DASH = "--";
    private static final String ESCAPED_DOUBLE_DASH = "&#45;&#45;";
    private static final String GT = ">";
    private static final String ESCAPED_GT = "&gt;";

    public String getLineCommentPrefix() {
        return null;
    }

    @NotNull
    public String getBlockCommentPrefix() {
        return "<!--";
    }

    @NotNull
    public String getBlockCommentSuffix() {
        return "-->";
    }

    public String getCommentedBlockCommentPrefix() {
        return "&lt;!&ndash;";
    }

    public String getCommentedBlockCommentSuffix() {
        return "&ndash;&gt;";
    }

    public void escape(Document document, RangeMarker range2) {
        String prefix2 = this.getBlockCommentPrefix();
        String suffix = this.getBlockCommentSuffix();
        int start2 = range2.getStartOffset();
        int prefixStart = start2 = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)start2, (String)" \t\n");
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)prefixStart, (CharSequence)prefix2)) {
            start2 += prefix2.length();
        }
        int end = range2.getEndOffset();
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(end - suffix.length()), (CharSequence)suffix)) {
            end -= suffix.length();
        }
        if (start2 >= end) {
            return;
        }
        for (int i2 = end - DOUBLE_DASH.length(); i2 >= start2; --i2) {
            if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)i2, (CharSequence)DOUBLE_DASH) || CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)i2, (CharSequence)suffix) || CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(i2 - 2), (CharSequence)prefix2)) continue;
            document.replaceString(i2, i2 + DOUBLE_DASH.length(), (CharSequence)ESCAPED_DOUBLE_DASH);
        }
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)start2, (CharSequence)GT)) {
            document.replaceString(start2, start2 + GT.length(), (CharSequence)ESCAPED_GT);
        }
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)prefixStart, (CharSequence)(prefix2 + "-"))) {
            document.insertString(start2, (CharSequence)" ");
        }
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(range2.getEndOffset() - suffix.length() - 1), (CharSequence)("-" + suffix))) {
            document.insertString(range2.getEndOffset() - suffix.length(), (CharSequence)" ");
        }
    }

    public void unescape(Document document, RangeMarker range2) {
        int start2 = range2.getStartOffset();
        for (int i2 = range2.getEndOffset(); i2 >= start2; --i2) {
            if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)i2, (CharSequence)ESCAPED_DOUBLE_DASH)) continue;
            document.replaceString(i2, i2 + ESCAPED_DOUBLE_DASH.length(), (CharSequence)DOUBLE_DASH);
        }
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)start2, (CharSequence)ESCAPED_GT)) {
            document.replaceString(start2, start2 + ESCAPED_GT.length(), (CharSequence)GT);
        }
    }
}

