/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonTrailingCommaRemover
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element2, @NotNull TextRange range2) {
        PsiElement rootPsi;
        if (element2 == null) {
            JsonTrailingCommaRemover.$$$reportNull$$$0(0);
        }
        if (range2 == null) {
            JsonTrailingCommaRemover.$$$reportNull$$$0(1);
        }
        if ((rootPsi = element2.getPsi()).getLanguage() != JsonLanguage.INSTANCE) {
            TextRange textRange = range2;
            if (textRange == null) {
                JsonTrailingCommaRemover.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        JsonCodeStyleSettings settings2 = (JsonCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)rootPsi.getContainingFile(), JsonCodeStyleSettings.class);
        if (settings2.KEEP_TRAILING_COMMA) {
            TextRange textRange = range2;
            if (textRange == null) {
                JsonTrailingCommaRemover.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)rootPsi.getProject());
        Document document = psiDocumentManager.getDocument(rootPsi.getContainingFile());
        if (document == null) {
            TextRange textRange = range2;
            if (textRange == null) {
                JsonTrailingCommaRemover.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        DocumentUtil.executeInBulk(document, true, () -> {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            Visitor visitor = new Visitor(document);
            rootPsi.accept((PsiElementVisitor)visitor);
            psiDocumentManager.commitDocument(document);
        });
        TextRange textRange = range2;
        if (textRange == null) {
            JsonTrailingCommaRemover.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/formatter/JsonTrailingCommaRemover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/formatter/JsonTrailingCommaRemover";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends JsonRecursiveElementVisitor {
        private final Document myDocument;
        private int myOffsetDelta;

        Visitor(Document document) {
            this.myDocument = document;
        }

        @Override
        public void visitArray(@NotNull JsonArray o) {
            if (o == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitArray(o);
            PsiElement lastChild = o.getLastChild();
            if (lastChild == null || lastChild.getNode().getElementType() != JsonElementTypes.R_BRACKET) {
                return;
            }
            this.deleteTrailingCommas((PsiElement)ObjectUtils.coalesce((Object)((PsiElement)ContainerUtil.getLastItem(o.getValueList())), (Object)o.getFirstChild()));
        }

        @Override
        public void visitObject(@NotNull JsonObject o) {
            if (o == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitObject(o);
            PsiElement lastChild = o.getLastChild();
            if (lastChild == null || lastChild.getNode().getElementType() != JsonElementTypes.R_CURLY) {
                return;
            }
            this.deleteTrailingCommas((PsiElement)ObjectUtils.coalesce((Object)((PsiElement)ContainerUtil.getLastItem(o.getPropertyList())), (Object)o.getFirstChild()));
        }

        private void deleteTrailingCommas(@Nullable PsiElement lastElementOrOpeningBrace) {
            PsiElement element2;
            PsiElement psiElement = element2 = lastElementOrOpeningBrace != null ? lastElementOrOpeningBrace.getNextSibling() : null;
            while (element2 != null) {
                if (element2.getNode().getElementType() == JsonElementTypes.COMMA || element2 instanceof PsiErrorElement && ",".equals(element2.getText())) {
                    this.deleteNode(element2.getNode());
                } else if (!(element2 instanceof PsiComment) && !(element2 instanceof PsiWhiteSpace)) break;
                element2 = element2.getNextSibling();
            }
        }

        private void deleteNode(@NotNull ASTNode node2) {
            if (node2 == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            int length = node2.getTextLength();
            this.myDocument.deleteString(node2.getStartOffset() + this.myOffsetDelta, node2.getStartOffset() + length + this.myOffsetDelta);
            this.myOffsetDelta -= length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/json/formatter/JsonTrailingCommaRemover$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArray";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitObject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

