/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.validation;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.util.Random;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class TestMacMessagesAction
extends AnAction {
    static int num = 1;
    static String TITLE = "Title";
    static String MESSAGE = "Message";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            TestMacMessagesAction.$$$reportNull$$$0(0);
        }
        final Project project = e.getProject();
        new DialogWrapper(project){
            {
                super(arg0);
                this.setSize(500, 500);
                this.setTitle("Dialog 1");
                this.init();
            }

            protected JComponent createCenterPanel() {
                JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(5));
                JLabel titleLabel = new JLabel("Title:");
                final JTextField titleField = new JTextField(TITLE);
                Insets insets = titleField.getBorder().getBorderInsets(titleField);
                titleField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        TITLE = titleField.getText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/validation/TestMacMessagesAction$1$1", "textChanged"));
                    }
                });
                titleLabel.setLabelFor(titleField);
                BorderLayoutPanel titlePanel = new BorderLayoutPanel(5, 5);
                titlePanel.add((Component)titleLabel, "West");
                titlePanel.add((Component)titleField, "Center");
                panel2.add((Component)titlePanel);
                JLabel messageLabel = new JLabel("Message:");
                final JTextArea messageArea = new JTextArea(MESSAGE, 3, 30);
                messageArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        MESSAGE = messageArea.getText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/validation/TestMacMessagesAction$1$2", "textChanged"));
                    }
                });
                messageLabel.setLabelFor(messageArea);
                BorderLayoutPanel messagePanel = new BorderLayoutPanel(5, 5);
                messagePanel.add((Component)messageLabel, "West");
                JBScrollPane scrollPane = new JBScrollPane((Component)messageArea);
                scrollPane.setBorder((Border)new CompoundBorder(new LineBorder(UIUtil.getPanelBackground(), insets.top), scrollPane.getBorder()));
                messagePanel.add((Component)scrollPane, "Center");
                panel2.add((Component)messagePanel);
                JButton yesNoCancel = new JButton("Show YesNoCancel Alert");
                yesNoCancel.addActionListener(event -> System.out.println(Messages.showYesNoCancelDialog((String)MESSAGE, (String)TITLE, (String)"YesText", (String)"NoText", (String)"CancelText", null)));
                panel2.add(yesNoCancel);
                JButton yesNo1 = new JButton("Show YesNo Alert");
                yesNo1.addActionListener(event -> Messages.showYesNoDialog((Project)null, (String)MESSAGE, (String)TITLE, (Icon)Messages.getQuestionIcon()));
                panel2.add(yesNo1);
                JButton yesNo2 = new JButton("Show YesNo Alert with DoNotAsk");
                yesNo2.addActionListener(event -> Messages.showYesNoDialog(null, (String)MESSAGE, (String)TITLE, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption(){

                    public boolean isToBeShown() {
                        return false;
                    }

                    public void setToBeShown(boolean toBeShown, int exitCode) {
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return false;
                    }

                    @NotNull
                    @NlsContexts.Checkbox
                    public String getDoNotShowMessage() {
                        return "Do not ask me again";
                    }
                }));
                panel2.add(yesNo2);
                JButton ok = new JButton("Show Ok Alert");
                ok.addActionListener(event -> Messages.showInfoMessage((Component)ok, (String)MESSAGE, (String)TITLE));
                panel2.add(ok);
                JButton warn = new JButton("Show Warning Alert");
                warn.addActionListener(event -> Messages.showWarningDialog((Project)null, (String)MESSAGE, (String)TITLE));
                panel2.add(warn);
                JButton error2 = new JButton("Show Error Alert");
                error2.addActionListener(event -> Messages.showErrorDialog((Project)null, (String)MESSAGE, (String)TITLE));
                panel2.add(error2);
                JButton help = new JButton("Show Alert with help button");
                help.addActionListener(event -> ((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)TITLE, (String)MESSAGE).help("my.help.id")).show(project));
                panel2.add(help);
                TestMacMessagesAction.alertWithButtons(panel2, "Show Buttons with Cancel Alert", new String[]{"Button1", "Cancel", "Button3", "Button4", "Button5"}, 1);
                TestMacMessagesAction.alertWithButtons(panel2, "Show Buttons with Cancel Alert", new String[]{"Button1", "Button2", "Button3", "Cancel", "Button5"}, 2);
                TestMacMessagesAction.alertWithButtons(panel2, "Show Buttons with Cancel Alert", new String[]{"Button1", "Button2", "Button3", "Button4", "Cancel"}, 4);
                JButton dialogAlert = new JButton("Dialog -> YesNo Alert");
                dialogAlert.addActionListener(event -> new DialogWrapper(project){
                    {
                        this.setSize(400, 400);
                        this.setTitle("Dialog 2");
                        this.init();
                    }

                    protected JComponent createCenterPanel() {
                        final JButton b = new JButton("Click me again " + num);
                        ++num;
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e1) {
                                this.getWindow().setVisible(false);
                                Messages.showYesNoDialog((Component)b, (String)MESSAGE, (String)TITLE, (Icon)Messages.getQuestionIcon());
                            }
                        });
                        return b;
                    }
                }.show());
                panel2.add(dialogAlert);
                JButton changeTitleDialog = new JButton("Dialog(dynamic title) -> Alert");
                changeTitleDialog.addActionListener(event -> new DialogWrapper(project){
                    {
                        this.setSize(400, 400);
                        this.setTitle("Dialog [0]");
                        this.init();
                    }

                    protected JComponent createCenterPanel() {
                        final JButton b = new JButton("Run");
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e1) {
                                this.setTitle("Dialog [0]");
                                Thread thread2 = new Thread(() -> {
                                    try {
                                        int i2 = 0;
                                        while (i2 < 300) {
                                            int ii = i2++;
                                            SwingUtilities.invokeLater(() -> this.setTitle("Dialog [" + ii + "]"));
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }, "");
                                thread2.start();
                                Messages.showYesNoDialog((Component)b, (String)MESSAGE, (String)TITLE, (Icon)Messages.getQuestionIcon());
                                if (thread2.isAlive()) {
                                    thread2.interrupt();
                                }
                            }
                        });
                        return b;
                    }
                }.show());
                panel2.add(changeTitleDialog);
                JButton secondDialog = new JButton("Dialog -> Alert || Modal Dialog (~5sec)");
                secondDialog.addActionListener(event -> {
                    new Thread(() -> SwingUtilities.invokeLater(() -> {
                        DialogWrapper dialog2 = new DialogWrapper(project){
                            {
                                this.setSize(400, 400);
                                this.setTitle("Dialog");
                                this.init();
                            }

                            protected JComponent createCenterPanel() {
                                return new JCheckBox("Check me!");
                            }
                        };
                        dialog2.setModal(true);
                        dialog2.show();
                    }), "").start();
                    Messages.showYesNoDialog((Component)secondDialog, (String)MESSAGE, (String)TITLE, (Icon)Messages.getQuestionIcon());
                });
                panel2.add(secondDialog);
                JButton secondAlert = new JButton("Dialog -> Alert || Alert (~5sec)");
                secondAlert.addActionListener(event -> {
                    new Thread(() -> {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(() -> Messages.showInfoMessage((String)"Message", (String)"Title"));
                    }, "").start();
                    Messages.showYesNoDialog((Component)secondAlert, (String)MESSAGE, (String)TITLE, (Icon)Messages.getQuestionIcon());
                });
                panel2.add(secondAlert);
                JButton html = new JButton("Show Alert with HTML content");
                html.addActionListener(event -> Messages.showDialog((String)"<html>Message <a>Message</a> Message<br>Test <b>Test</b> Test<br>&nbsp;&nbsp;&nbsp;Foo &lt;&gt;&amp;&#39;&quot; Foo</html>", (String)"<html>Title <b>AA</b></html>", (String[])new String[]{"Y&es", "<html>ZZZZ</html>", "Cancel"}, (int)0, null, (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption(){

                    public boolean isToBeShown() {
                        return false;
                    }

                    public void setToBeShown(boolean toBeShown, int exitCode) {
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return false;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        return "<html>Delete branch:</br>EE-F1-0A</html>";
                    }
                }));
                panel2.add(html);
                JButton decompiler = new JButton("Decompiler");
                decompiler.addActionListener(event -> System.out.println(Messages.showDialog((Component)decompiler, (String)"IMPORTANT: BY ACCESSING AND USING JETBRAINS DECOMPILER, YOU AGREE TO THE CERTAIN TERMS AND CONDITIONS SET FORTH IN THE END-USER LICENSE AGREEMENT AND QUOTED BELOW. IF YOU DO NOT AGREE WITH THESE TERMS OR CONDITIONS, DO NOT ACCESS OR USE JETBRAINS DECOMPILER. The Software includes decompiling functionality (\"\"JetBrains Decompiler\"\") that enables reproducing source code from the original binary code. Licensee aknowledges that binary code and source code might be protected by copyright and trademark laws. Before using JetBrains Decompiler, Licensee should make sure that decompilation of binary code is not prohibited by the applicable license agreement (except to the extent that Licensee may be expressly permitted under applicable law) or that Licensee has obtained permission to decompile the binary code from the copyright owner. Using JetBrains Decompiler is entirely optional. Licensor does neither encourage nor condone the use of JetBrains Decompiler, and disclaims any liability for Licensee's use of  JetBrains Decompiler in violation of applicable laws.", (String)"Decompiler Legal Notice \u2014 Accept", (String[])new String[]{"Yes", "No"}, (int)0, (Icon)AllIcons.General.Tip)));
                panel2.add(decompiler);
                JButton progress2 = new JButton("Progress");
                progress2.addActionListener(event -> {
                    if (Messages.showYesNoDialog((String)"Continue?", (String)TITLE, null) != 0) {
                        return;
                    }
                    Runnable runnable2 = () -> {
                        ProgressIndicator indicator2 = ProgressManager.getInstance().getProgressIndicator();
                        Semaphore done = new Semaphore();
                        done.down();
                        ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            try {
                                int count = new Random(System.currentTimeMillis()).nextInt(10);
                                indicator2.setText("Count: " + count);
                                for (int i2 = 0; i2 < count; ++i2) {
                                    Thread.sleep(1000L);
                                    indicator2.setText("Count: " + i2 + "/" + count);
                                }
                            }
                            catch (InterruptedException exception) {
                                exception.printStackTrace();
                            }
                            finally {
                                done.up();
                            }
                        });
                        while (!done.waitFor(1000L) && !indicator2.isCanceled()) {
                        }
                        ApplicationManager.getApplication().invokeAndWait(() -> Messages.showInfoMessage((String)"Finish11111", (String)"Title"), ModalityState.any());
                    };
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable2, "Progress", true, null, (JComponent)progress2);
                    Messages.showInfoMessage((String)"Finish", (String)TITLE);
                });
                panel2.add(progress2);
                JButton popupButton = new JButton("Popup");
                popupButton.addActionListener(event -> {
                    NewItemSimplePopupPanel contentPanel2 = new NewItemSimplePopupPanel();
                    JTextField nameField = contentPanel2.getTextField();
                    JBPopup popup2 = NewItemPopupUtil.createNewItemPopup(IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), (JComponent)((Object)contentPanel2), nameField);
                    contentPanel2.setApplyAction((Consumer<? super InputEvent>)((Consumer)_event -> Messages.showYesNoCancelDialog((String)MESSAGE, (String)TITLE, (String)"YesText", (String)"NoText", (String)"CancelText", null)));
                    popup2.showCenteredInCurrentWindow(project);
                });
                panel2.add(popupButton);
                return panel2;
            }
        }.show();
    }

    private static void alertWithButtons(JPanel panel2, String title2, String[] buttons, int index2) {
        JButton button4 = new JButton(title2);
        button4.addActionListener(event -> System.out.println(Messages.showDialog((Component)button4, (String)MESSAGE, (String)TITLE, (String[])buttons, (int)index2, null)));
        panel2.add(button4);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/validation/TestMacMessagesAction", "actionPerformed"));
    }
}

