/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.internal.statistic.eventLog.util.StringUtil;
import com.intellij.internal.ui.JEditorPaneDemoAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/ui/JEditorPaneDemoAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "DEFAULT_HTML", "", "PREFERENCE_KEY", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
public final class JEditorPaneDemoAction
extends DumbAwareAction {
    private final String PREFERENCE_KEY;
    @Language(value="HTML")
    private final String DEFAULT_HTML;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        new DialogWrapper(this, e, e.getProject(), null, true, DialogWrapper.IdeModalityType.IDE, false){
            @NotNull
            private final JEditorPane myView;
            @NotNull
            private final Editor myEditor;
            final /* synthetic */ JEditorPaneDemoAction this$0;
            final /* synthetic */ AnActionEvent $e;

            @NotNull
            public final JEditorPane getMyView() {
                return this.myView;
            }

            @NotNull
            public final Editor getMyEditor() {
                return this.myEditor;
            }

            @NotNull
            protected DialogWrapper.DialogStyle getStyle() {
                return DialogWrapper.DialogStyle.COMPACT;
            }

            @NotNull
            protected String getDimensionServiceKey() {
                return "HTMLRenderingPlayground";
            }

            @NotNull
            protected JComponent createCenterPanel() {
                OnePixelSplitter splitter = new OnePixelSplitter(false, 0.33f, 0.18f, 0.82f);
                splitter.setSplitterProportionKey("HTMLRenderingPlayground.Splitter");
                splitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myEditor.getComponent()));
                splitter.setSecondComponent((JComponent)new JBScrollPane((Component)this.myView));
                return (JComponent)splitter;
            }

            @NotNull
            protected Action[] createActions() {
                return new Action[0];
            }
            {
                EditorFactory editorFactory;
                this.this$0 = this$0;
                this.$e = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
                this.myView = new JEditorPane();
                this.setTitle("HTML Rendering Playground");
                this.setResizable(true);
                this.myView.setContentType("text/html");
                this.myView.setEditable(false);
                this.myView.setEditorKit(UIUtil.getHTMLEditorKit());
                this.myView.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
                UIUtil.doNotScrollToCaret((JTextComponent)this.myView);
                String html = Preferences.userRoot().get(JEditorPaneDemoAction.access$getPREFERENCE_KEY$p(this$0), "");
                if (StringUtil.isEmpty((String)html)) {
                    html = JEditorPaneDemoAction.access$getDEFAULT_HTML$p(this$0);
                }
                EditorFactory editorFactory2 = editorFactory = EditorFactory.getInstance();
                Intrinsics.checkNotNull((Object)editorFactory2);
                Document document = editorFactory2.createDocument((CharSequence)html);
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editorFactory!!.createDocument(html)");
                Document editorDocument = document;
                FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension("html");
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"FileTypeManager.getInsta\u2026leTypeByExtension(\"html\")");
                FileType htmlFileType = fileType;
                FileDocumentManagerBase.registerDocument(editorDocument, (VirtualFile)new LightVirtualFile(this.getTitle() + ".html", htmlFileType, (CharSequence)html));
                Editor editor = editorFactory.createEditor(editorDocument, $captured_local_variable$1.getProject(), htmlFileType, false);
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editorFactory.createEdit\u2026ect, htmlFileType, false)");
                this.myEditor = editor;
                EditorSettings editorSettings = this.myEditor.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"myEditor.settings");
                EditorSettings settings2 = editorSettings;
                settings2.setLineNumbersShown(false);
                settings2.setWhitespacesShown(true);
                settings2.setLineMarkerAreaShown(false);
                settings2.setIndentGuidesShown(false);
                settings2.setAdditionalColumnsCount(0);
                settings2.setAdditionalLinesCount(0);
                settings2.setRightMarginShown(false);
                settings2.setRightMargin(60);
                settings2.setGutterIconsShown(false);
                settings2.setIndentGuidesShown(false);
                EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)this.myEditor.getGutter();
                Intrinsics.checkNotNull((Object)editorGutterComponentEx);
                editorGutterComponentEx.setPaintBackground(false);
                editorDocument.addDocumentListener(new DocumentListener(this){
                    final /* synthetic */ actionPerformed.1 this$0;

                    public void documentChanged(@NotNull DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        try {
                            JEditorPane jEditorPane = this.this$0.getMyView();
                            Document document = event.getDocument();
                            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
                            jEditorPane.setText(document.getText());
                            Preferences preferences = Preferences.userRoot();
                            String string = JEditorPaneDemoAction.access$getPREFERENCE_KEY$p(this.this$0.this$0);
                            Document document2 = event.getDocument();
                            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"event.document");
                            preferences.put(string, document2.getText());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    {
                        this.this$0 = this$0;
                    }
                });
                Document document2 = this.myEditor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"myEditor.document");
                this.myView.setText(document2.getText());
                this.init();
            }
        }.show();
    }

    public JEditorPaneDemoAction() {
        super("HTML Rendering Playground");
        this.PREFERENCE_KEY = "HTML_RENDERING_PLAYGROUND";
        this.DEFAULT_HTML = "<html>\n<head>\n    <style type=\"text/css\">\n        body {\n            margin: 10px;\n            background: #C0C0C0;\n            color: #333333;\n        }\n\n        code {\n            background-color: #eeee11;\n            margin: 4px;\n        }\n\n        pre {\n            padding: 10px;\n        }\n    </style>\n</head>\n<body>\n<h1>This is HTML rendering demo.</h1>\nSome key features are supported:\n<ol>\n    <li>Of course <i>Italic</i> & <b>bold</b></li>\n    <li>Not so often used <sub>subscript</sub> <strike>strikethrough</strike> and <sup>superscript</sup>\n    <li>Tags <small>small</small> and <strong>strong</strong>. And <u>underlined</u> too.</li>\n    <li><a href=\"https://www.jetbrains.com/\">External links</a></li>\n    <li>This is <code>@Code</code> tag to be <code>highlighted</code></li>\n    <li>Emoji etc. if you are lucky enough to see it <span style=\"color:red;\">[&#9829;]</span>[&#128512;]</li>\n</ol>\nThe tag below is &lt;pre&gt;:\n<pre style=\"background-color:white;color:black;\">\nclass HelloWorld {\n    public static void main(String[] args) {\n        System.out.println(\"Hello World!\");\n    }\n}</pre>\n<ul>\n    <li>User-friendly link <a href=\"https://docs.oracle.com/en/java/javase/11/docs/api/java.desktop/javax/swing/text/html/CSS.html\">\n        CSS support in Java engine</a></li>\n    <li>Not so user-friendly link <a href=\"https://docs.oracle.com/en/java/javase/11/docs/api/java.desktop/javax/swing/text/html/CSS.html\">\n        https://docs.oracle.com/en/java/javase/11/docs/api/java.desktop/javax/swing/text/html/CSS.html</a></li>\n</ul>\n<p>\n<div style=\"color:white;background-color:#909090; border:solid 1px #fedcba; text-align:center;\">Outer div\n    <div style=\"background-color:#606060; width:50%; margin:20px;padding:11px; border:solid 1px orange;\">Inner div with width 50%</div>\n</div>\n</p><br>\n<p>\n    Well, we can do something with it...</p>\n</body>\n</html>";
    }

    public static final /* synthetic */ String access$getPREFERENCE_KEY$p(JEditorPaneDemoAction $this) {
        return $this.PREFERENCE_KEY;
    }

    public static final /* synthetic */ String access$getDEFAULT_HTML$p(JEditorPaneDemoAction $this) {
        return $this.DEFAULT_HTML;
    }
}

