/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.catboost;

import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.ResourcesModelMetadataReader;
import com.intellij.internal.ml.catboost.NaiveCatBoostModel;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/ml/catboost/CatBoostResourcesModelMetadataReader;", "Lcom/intellij/internal/ml/ResourcesModelMetadataReader;", "metadataHolder", "Ljava/lang/Class;", "featuresDirectory", "", "modelDirectory", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)V", "loadModel", "Lcom/intellij/internal/ml/catboost/NaiveCatBoostModel;", "intellij.platform.ide.impl"})
public final class CatBoostResourcesModelMetadataReader
extends ResourcesModelMetadataReader {
    private final String modelDirectory;

    @NotNull
    public final NaiveCatBoostModel loadModel() {
        String resource = this.modelDirectory + "/model.bin";
        InputStream inputStream2 = this.getMetadataHolder().getClassLoader().getResourceAsStream(resource);
        if (inputStream2 == null) {
            throw (Throwable)new InconsistentMetadataException("Metadata file not found: " + resource + ". Resources holder: " + this.getMetadataHolder().getName());
        }
        InputStream fileStream = inputStream2;
        NaiveCatBoostModel naiveCatBoostModel = NaiveCatBoostModel.loadModel(fileStream);
        Intrinsics.checkNotNullExpressionValue((Object)naiveCatBoostModel, (String)"NaiveCatBoostModel.loadModel(fileStream)");
        return naiveCatBoostModel;
    }

    public CatBoostResourcesModelMetadataReader(@NotNull Class<?> metadataHolder, @NotNull String featuresDirectory, @NotNull String modelDirectory) {
        Intrinsics.checkNotNullParameter(metadataHolder, (String)"metadataHolder");
        Intrinsics.checkNotNullParameter((Object)featuresDirectory, (String)"featuresDirectory");
        Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
        super(metadataHolder, featuresDirectory);
        this.modelDirectory = modelDirectory;
    }
}

