/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.util.DirectoryChooserModuleTreeView;
import com.intellij.ide.util.DirectoryChooserView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryChooser
extends DialogWrapper {
    private static final String FILTER_NON_EXISTING = "filter_non_existing";
    private static final String DEFAULT_SELECTION = "last_directory_selection";
    private final DirectoryChooserView myView;
    private boolean myFilterExisting;
    private PsiDirectory myDefaultSelection;
    private final List<ItemWrapper> myItems;
    private PsiElement mySelection;
    private final TabbedPaneWrapper myTabbedPaneWrapper;
    private final ChooseByNamePanel myByClassPanel;
    private final ChooseByNamePanel myByFilePanel;

    public DirectoryChooser(@NotNull Project project) {
        if (project == null) {
            DirectoryChooser.$$$reportNull$$$0(0);
        }
        this(project, new DirectoryChooserModuleTreeView(project));
    }

    public DirectoryChooser(@NotNull Project project, @NotNull DirectoryChooserView view) {
        if (project == null) {
            DirectoryChooser.$$$reportNull$$$0(1);
        }
        if (view == null) {
            DirectoryChooser.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myItems = new ArrayList<ItemWrapper>();
        this.myView = view;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        this.myFilterExisting = propertiesComponent.isTrueValue(FILTER_NON_EXISTING);
        this.myTabbedPaneWrapper = new TabbedPaneWrapper(this.getDisposable());
        String gotoClassText = GotoClassPresentationUpdater.getTabTitle();
        this.myByClassPanel = gotoClassText.startsWith("Class") ? this.createChooserPanel(project, true) : null;
        this.myByFilePanel = this.createChooserPanel(project, false);
        this.init();
    }

    private ChooseByNamePanel createChooserPanel(@NotNull Project project, boolean useClass) {
        if (project == null) {
            DirectoryChooser.$$$reportNull$$$0(3);
        }
        FilteringGotoByModel model2 = useClass ? new GotoClassModel2(project){

            @Override
            public boolean loadInitialCheckBoxState() {
                return true;
            }

            @Override
            public void saveInitialCheckBoxState(boolean state) {
            }
        } : new GotoFileModel(project){

            @Override
            public boolean loadInitialCheckBoxState() {
                return true;
            }

            @Override
            public void saveInitialCheckBoxState(boolean state) {
            }
        };
        ChooseByNamePanel panel2 = new ChooseByNamePanel(project, model2, "", false, null){

            @Override
            protected void showTextFieldPanel() {
            }

            @Override
            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    List<Object> elements = this.getChosenElements();
                    if (!elements.isEmpty()) {
                        this.myActionListener.elementChosen(elements.get(0));
                    }
                    DirectoryChooser.this.doOKAction();
                } else {
                    DirectoryChooser.this.doCancelAction();
                }
            }
        };
        UiNotifyConnector.doWhenFirstShown((JComponent)panel2.getPanel(), () -> panel2.invoke(new ChooseByNamePopupComponent.Callback(){

            public void elementChosen(Object element2) {
                DirectoryChooser.this.setSelection(element2);
            }
        }, ModalityState.stateForComponent((Component)this.getRootPane()), false));
        Disposer.register((Disposable)this.myDisposable, (Disposable)panel2);
        return panel2;
    }

    protected void doOKAction() {
        PsiDirectory directory;
        ItemWrapper item;
        PropertiesComponent.getInstance().setValue(FILTER_NON_EXISTING, this.myFilterExisting);
        JComponent selectedTab = this.myTabbedPaneWrapper.getSelectedComponent();
        if (selectedTab == this.myByFilePanel.getPanel() || this.myByClassPanel != null && selectedTab == this.myByClassPanel.getPanel()) {
            this.setSelection(selectedTab == this.myByFilePanel.getPanel() ? this.myByFilePanel.getChosenElement() : this.myByClassPanel.getChosenElement());
        }
        if ((item = this.myView.getSelectedItem()) != null && (directory = item.getDirectory()) != null) {
            PropertiesComponent.getInstance((Project)directory.getProject()).setValue(DEFAULT_SELECTION, directory.getVirtualFile().getPath());
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.add((AnAction)new FilterExistentAction());
        JComponent toolbarComponent = ActionManager.getInstance().createActionToolbar("DirectoryChooser", (ActionGroup)actionGroup2, true).getComponent();
        toolbarComponent.setBorder(null);
        panel2.add((Component)toolbarComponent, "North");
        Runnable runnable2 = () -> this.enableButtons();
        this.myView.onSelectionChange(runnable2);
        JComponent component2 = this.myView.getComponent();
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)component2);
        int prototypeWidth = component2.getFontMetrics(component2.getFont()).stringWidth("X:\\1234567890\\1234567890\\com\\company\\system\\subsystem");
        jScrollPane.setPreferredSize(new Dimension(Math.max(300, prototypeWidth), 300));
        jScrollPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 15);
        this.installEnterAction(component2);
        panel2.add((Component)jScrollPane, "Center");
        this.myTabbedPaneWrapper.addTab(LangBundle.message((String)"tab.title.directory.structure", (Object[])new Object[0]), panel2);
        if (this.myByClassPanel != null) {
            this.myTabbedPaneWrapper.addTab(LangBundle.message((String)"tab.title.by.class", (Object[])new Object[0]), this.myByClassPanel.getPanel());
        }
        this.myTabbedPaneWrapper.addTab(LangBundle.message((String)"tab.title.by.file", (Object[])new Object[0]), this.myByFilePanel.getPanel());
        return this.myTabbedPaneWrapper.getComponent();
    }

    private void setSelection(Object element2) {
        if (element2 instanceof PsiElement) {
            this.mySelection = (PsiElement)element2;
        }
    }

    private void installEnterAction(JComponent component2) {
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        InputMap inputMap = component2.getInputMap();
        ActionMap actionMap = component2.getActionMap();
        Object oldActionKey = inputMap.get(enterKeyStroke);
        final Action oldAction = oldActionKey != null ? actionMap.get(oldActionKey) : null;
        inputMap.put(enterKeyStroke, "clickButton");
        actionMap.put("clickButton", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DirectoryChooser.this.isOKActionEnabled()) {
                    DirectoryChooser.this.doOKAction();
                } else if (oldAction != null) {
                    oldAction.actionPerformed(e);
                }
            }
        });
    }

    protected String getDimensionServiceKey() {
        return "chooseDestDirectoryDialog";
    }

    private void buildFragments() {
        ArrayList<String[]> paths2 = new ArrayList<String[]>();
        for (int i2 = 0; i2 < this.myView.getItemsSize(); ++i2) {
            ItemWrapper item = this.myView.getItemByIndex(i2);
            paths2.add(ArrayUtilRt.toStringArray((Collection)FileUtil.splitPath((String)item.getPresentableUrl())));
        }
        FragmentBuilder headBuilder = new FragmentBuilder(paths2){

            @Override
            protected void append(String fragment2, StringBuffer buffer) {
                buffer.append(this.mySeparator);
                buffer.append(fragment2);
            }

            @Override
            protected int getFragmentIndex(String[] path2, int index2) {
                return path2.length > index2 ? index2 : -1;
            }
        };
        String commonHead = headBuilder.execute();
        final int headLimit = headBuilder.getIndex();
        FragmentBuilder tailBuilder = new FragmentBuilder(paths2){

            @Override
            protected void append(String fragment2, StringBuffer buffer) {
                buffer.insert(0, fragment2 + this.mySeparator);
            }

            @Override
            protected int getFragmentIndex(String[] path2, int index2) {
                int result2 = path2.length - 1 - index2;
                return result2 > headLimit ? result2 : -1;
            }
        };
        String commonTail = tailBuilder.execute();
        int tailLimit = tailBuilder.getIndex();
        for (int i3 = 0; i3 < this.myView.getItemsSize(); ++i3) {
            ItemWrapper item = this.myView.getItemByIndex(i3);
            String special = DirectoryChooser.concat((String[])paths2.get(i3), headLimit, tailLimit);
            item.setFragments(DirectoryChooser.createFragments(commonHead, special, commonTail));
        }
    }

    @Nullable
    private static String concat(String[] strings, int headLimit, int tailLimit) {
        if (strings.length <= headLimit + tailLimit) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String separator = "";
        for (int i2 = headLimit; i2 < strings.length - tailLimit; ++i2) {
            buffer.append(separator);
            buffer.append(strings[i2]);
            separator = File.separator;
        }
        return buffer.toString();
    }

    private static PathFragment[] createFragments(String head, String special, String tail) {
        ArrayList<PathFragment> list2 = new ArrayList<PathFragment>(3);
        if (head != null) {
            if (special != null || tail != null) {
                list2.add(new PathFragment(head + File.separatorChar, true));
            } else {
                return new PathFragment[]{new PathFragment(head, true)};
            }
        }
        if (special != null) {
            if (tail != null) {
                list2.add(new PathFragment(special + File.separatorChar, false));
            } else {
                list2.add(new PathFragment(special, false));
            }
        }
        if (tail != null) {
            list2.add(new PathFragment(tail, true));
        }
        return list2.toArray(new PathFragment[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView.getComponent();
    }

    public void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection2, Project project, String postfixToShow) {
        this.fillList(directories, defaultSelection2, project, postfixToShow, null);
    }

    public void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection2, Project project, Map<PsiDirectory, String> postfixes) {
        this.fillList(directories, defaultSelection2, project, null, postfixes);
    }

    private void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection2, Project project, String postfixToShow, Map<PsiDirectory, String> postfixes) {
        if (this.myView.getItemsSize() > 0) {
            this.myView.clearItems();
        }
        if (defaultSelection2 == null && (defaultSelection2 = DirectoryChooser.getDefaultSelection(directories, project)) == null && directories.length > 0) {
            defaultSelection2 = directories[0];
        }
        int selectionIndex = -1;
        for (int i2 = 0; i2 < directories.length; ++i2) {
            PsiDirectory directory = directories[i2];
            if (!directory.equals(defaultSelection2)) continue;
            selectionIndex = i2;
            break;
        }
        if (selectionIndex < 0 && directories.length == 1) {
            selectionIndex = 0;
        }
        if (selectionIndex < 0) {
            VirtualFile[] sourceRoots2;
            PsiManager manager2 = PsiManager.getInstance((Project)project);
            for (VirtualFile sourceRoot : sourceRoots2 = ProjectRootManager.getInstance((Project)project).getContentSourceRoots()) {
                PsiDirectory directory;
                if (!sourceRoot.isDirectory() || (directory = manager2.findDirectory(sourceRoot)) == null || !DirectoryChooser.isParent(defaultSelection2, directory)) continue;
                defaultSelection2 = directory;
                break;
            }
        }
        int existingIdx = 0;
        for (int i3 = 0; i3 < directories.length; ++i3) {
            PsiDirectory directory = directories[i3];
            String postfixForDirectory = postfixes == null ? postfixToShow : postfixes.get(directory);
            ItemWrapper itemWrapper = new ItemWrapper(directory, postfixForDirectory);
            this.myItems.add(itemWrapper);
            if (this.myFilterExisting) {
                if (selectionIndex == i3) {
                    selectionIndex = -1;
                }
                if (postfixForDirectory != null && directory.getVirtualFile().findFileByRelativePath(StringUtil.trimStart((String)postfixForDirectory, (String)File.separator)) == null) {
                    if (!DirectoryChooser.isParent(directory, defaultSelection2)) continue;
                    this.myDefaultSelection = directory;
                    continue;
                }
            }
            this.myView.addItem(itemWrapper);
            if (selectionIndex < 0 && DirectoryChooser.isParent(directory, defaultSelection2)) {
                selectionIndex = existingIdx;
            }
            ++existingIdx;
        }
        this.buildFragments();
        this.myView.listFilled();
        if (this.myView.getItemsSize() > 0) {
            if (selectionIndex != -1) {
                this.myView.selectItemByIndex(selectionIndex);
            } else {
                this.myView.selectItemByIndex(0);
            }
        } else {
            this.myView.clearSelection();
        }
        this.enableButtons();
        this.myView.getComponent().repaint();
    }

    @Nullable
    private static PsiDirectory getDefaultSelection(PsiDirectory[] directories, Project project) {
        VirtualFile directoryByDefault;
        String defaultSelectionPath = PropertiesComponent.getInstance((Project)project).getValue(DEFAULT_SELECTION);
        if (defaultSelectionPath != null && (directoryByDefault = LocalFileSystem.getInstance().findFileByPath(defaultSelectionPath)) != null) {
            PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(directoryByDefault);
            return directory != null && ArrayUtil.find((Object[])directories, (Object)directory) > -1 ? directory : null;
        }
        return null;
    }

    private static boolean isParent(PsiDirectory directory, PsiDirectory parentCandidate) {
        while (directory != null) {
            if (directory.equals(parentCandidate)) {
                return true;
            }
            directory = directory.getParentDirectory();
        }
        return false;
    }

    private void enableButtons() {
        this.setOKActionEnabled(this.myView.getSelectedItem() != null);
    }

    @Nullable
    public PsiDirectory getSelectedDirectory() {
        PsiFile file2;
        if (this.mySelection != null && (file2 = this.mySelection.getContainingFile()) != null) {
            return file2.getContainingDirectory();
        }
        ItemWrapper wrapper2 = this.myView.getSelectedItem();
        if (wrapper2 == null) {
            return null;
        }
        return wrapper2.myDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/DirectoryChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createChooserPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FilterExistentAction
    extends ToggleAction {
        FilterExistentAction() {
            super(RefactoringBundle.messagePointer((String)"directory.chooser.hide.non.existent.checkBox.text", (Object[])new Object[0]), () -> UIUtil.removeMnemonic((String)RefactoringBundle.message((String)"directory.chooser.hide.non.existent.checkBox.text")), AllIcons.General.Filter);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterExistentAction.$$$reportNull$$$0(0);
            }
            return DirectoryChooser.this.myFilterExisting;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            PsiDirectory directory;
            if (e == null) {
                FilterExistentAction.$$$reportNull$$$0(1);
            }
            DirectoryChooser.this.myFilterExisting = state;
            ItemWrapper selectedItem = DirectoryChooser.this.myView.getSelectedItem();
            PsiDirectory psiDirectory = directory = selectedItem != null ? selectedItem.getDirectory() : null;
            if (directory == null && DirectoryChooser.this.myDefaultSelection != null) {
                directory = DirectoryChooser.this.myDefaultSelection;
            }
            DirectoryChooser.this.myView.clearItems();
            int idx = 0;
            int selectionId = -1;
            for (ItemWrapper item : DirectoryChooser.this.myItems) {
                if (DirectoryChooser.this.myFilterExisting && item.myPostfix != null && item.getDirectory().getVirtualFile().findFileByRelativePath(StringUtil.trimStart((String)item.myPostfix, (String)File.separator)) == null) continue;
                if (item.getDirectory() == directory) {
                    selectionId = idx;
                }
                ++idx;
                DirectoryChooser.this.myView.addItem(item);
            }
            DirectoryChooser.this.buildFragments();
            DirectoryChooser.this.myView.listFilled();
            if (selectionId < 0) {
                DirectoryChooser.this.myView.clearSelection();
                if (DirectoryChooser.this.myView.getItemsSize() > 0) {
                    DirectoryChooser.this.myView.selectItemByIndex(0);
                }
            } else {
                DirectoryChooser.this.myView.selectItemByIndex(selectionId);
            }
            DirectoryChooser.this.enableButtons();
            DirectoryChooser.this.myView.getComponent().repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/DirectoryChooser$FilterExistentAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PathFragment {
        private final String myText;
        private final boolean myCommon;

        public PathFragment(String text2, boolean isCommon) {
            this.myText = text2;
            this.myCommon = isCommon;
        }

        @NlsSafe
        public String getText() {
            return this.myText;
        }

        public boolean isCommon() {
            return this.myCommon;
        }
    }

    public static class ItemWrapper {
        final PsiDirectory myDirectory;
        private PathFragment[] myFragments;
        private final String myPostfix;
        private String myRelativeToProjectPath = null;

        public ItemWrapper(PsiDirectory directory, String postfix) {
            this.myDirectory = directory;
            this.myPostfix = postfix != null && postfix.length() > 0 ? postfix : null;
        }

        public PathFragment[] getFragments() {
            return this.myFragments;
        }

        public void setFragments(PathFragment[] fragments) {
            this.myFragments = fragments;
        }

        public Icon getIcon(FileIndex fileIndex) {
            if (this.myDirectory != null) {
                VirtualFile virtualFile2 = this.myDirectory.getVirtualFile();
                if (fileIndex.isInTestSourceContent(virtualFile2)) {
                    return PlatformIcons.MODULES_TEST_SOURCE_FOLDER;
                }
                if (fileIndex.isInSourceContent(virtualFile2)) {
                    return PlatformIcons.MODULES_SOURCE_FOLDERS_ICON;
                }
            }
            return PlatformIcons.FOLDER_ICON;
        }

        public String getPresentableUrl() {
            Object directoryUrl;
            if (this.myDirectory != null) {
                String projectHomeUrl;
                directoryUrl = this.myDirectory.getVirtualFile().getPresentableUrl();
                VirtualFile baseDir = this.myDirectory.getProject().getBaseDir();
                if (baseDir != null && ((String)directoryUrl).startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
                    directoryUrl = "..." + ((String)directoryUrl).substring(projectHomeUrl.length());
                }
            } else {
                directoryUrl = "";
            }
            return this.myPostfix != null ? (String)directoryUrl + this.myPostfix : directoryUrl;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }

        @NlsSafe
        public String getRelativeToProjectPath() {
            if (this.myRelativeToProjectPath == null) {
                PsiDirectory directory = this.getDirectory();
                VirtualFile virtualFile2 = directory != null ? directory.getVirtualFile() : null;
                this.myRelativeToProjectPath = virtualFile2 != null ? ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile2, (Project)directory.getProject(), (boolean)true, (boolean)false, (boolean)true) + (String)ObjectUtils.notNull((Object)this.myPostfix, (Object)"") : this.getPresentableUrl();
            }
            return this.myRelativeToProjectPath;
        }
    }

    private static abstract class FragmentBuilder {
        private final ArrayList<String[]> myPaths;
        private final StringBuffer myBuffer = new StringBuffer();
        private int myIndex;
        protected String mySeparator = "";

        FragmentBuilder(ArrayList<String[]> pathes) {
            this.myPaths = pathes;
            this.myIndex = 0;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @Nullable
        public String execute() {
            String commonHead;
            while ((commonHead = this.getCommonFragment(this.myIndex)) != null) {
                this.append(commonHead, this.myBuffer);
                this.mySeparator = File.separator;
                ++this.myIndex;
            }
            return this.myIndex > 0 ? this.myBuffer.toString() : null;
        }

        protected abstract void append(String var1, StringBuffer var2);

        @Nullable
        private String getCommonFragment(int count) {
            String commonFragment = null;
            for (String[] path2 : this.myPaths) {
                int index2 = this.getFragmentIndex(path2, count);
                if (index2 == -1) {
                    return null;
                }
                if (commonFragment == null) {
                    commonFragment = path2[index2];
                    continue;
                }
                if (Comparing.strEqual((String)commonFragment, (String)path2[index2], (boolean)SystemInfo.isFileSystemCaseSensitive)) continue;
                return null;
            }
            return commonFragment;
        }

        protected abstract int getFragmentIndex(String[] var1, int var2);
    }
}

