/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.jetbrains.annotations.Nullable;

public class DarculaTabbedPaneUI
extends BasicTabbedPaneUI {
    private TabStyle tabStyle;
    private PropertyChangeListener panePropertyListener;
    private ComponentListener paneComponentListener;
    private ChangeListener paneChangeListener;
    private MouseListener paneMouseListener;
    private MouseMotionListener paneMouseMotionListener;
    private JButton myShowHiddenTabsButton;
    private ArrayList<Component> myHiddenArrowButtons;
    private int hoverTab = -1;
    private boolean tabsOverlapBorder;
    private boolean useSelectedRectBackup = false;
    private static final JBValue OFFSET = new JBValue.Float(1.0f);

    public static ComponentUI createUI(JComponent c) {
        return new DarculaTabbedPaneUI();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        if (this.tabPane.getTabLayoutPolicy() == 1 && !Boolean.getBoolean("use.basic.tabs.scrolling")) {
            this.myHiddenArrowButtons = new ArrayList(2);
            Arrays.asList(this.tabPane.getComponents()).forEach(child2 -> {
                if (child2 instanceof BasicArrowButton) {
                    this.myHiddenArrowButtons.add((Component)child2);
                }
            });
            this.tabPane.setLayout(new WrappingLayout((BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout()));
            this.myShowHiddenTabsButton = new ShowHiddenTabsButton();
            this.tabPane.add(this.myShowHiddenTabsButton);
        }
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        if (this.myShowHiddenTabsButton != null) {
            this.tabPane.remove(this.myShowHiddenTabsButton);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.tabPane.getLayout() instanceof WrappingLayout) {
            this.tabPane.setLayout(((WrappingLayout)this.tabPane.getLayout()).myDelegate);
        }
        super.uninstallUI(c);
        this.myHiddenArrowButtons = null;
        this.myShowHiddenTabsButton = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.modifyFontSize();
        Object rStyle = UIManager.get("TabbedPane.tabFillStyle");
        this.tabStyle = rStyle != null ? TabStyle.valueOf(rStyle.toString()) : TabStyle.underline;
        this.contentBorderInsets = this.tabPane.getTabLayoutPolicy() == 0 ? JBUI.insetsTop((int)1) : JBUI.emptyInsets();
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
    }

    private void modifyFontSize() {
        if (SystemInfo.isMac || SystemInfo.isLinux) {
            Font font = UIManager.getFont("TabbedPane.font");
            this.tabPane.setFont(RelativeFont.NORMAL.fromResource("TabbedPane.fontSizeOffset", -1).derive(font));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.panePropertyListener = evt -> {
            String propName = evt.getPropertyName();
            if ("JTabbedPane.hasFullBorder".equals(propName) || "tabLayoutPolicy".equals(propName)) {
                boolean fullBorder;
                boolean bl = fullBorder = this.tabPane.getClientProperty("JTabbedPane.hasFullBorder") == Boolean.TRUE;
                this.contentBorderInsets = this.tabPane.getTabLayoutPolicy() == 0 ? (fullBorder ? JBUI.insets((int)1) : JBUI.insetsTop((int)1)) : (fullBorder ? JBUI.insets((int)0, (int)1, (int)1, (int)1) : JBUI.emptyInsets());
                this.tabPane.revalidate();
                this.tabPane.repaint();
            } else if ("enabled".equals(propName)) {
                for (int ti = 0; ti < this.tabPane.getTabCount(); ++ti) {
                    Component tc = this.tabPane.getTabComponentAt(ti);
                    if (tc == null) continue;
                    tc.setEnabled(evt.getNewValue() == Boolean.TRUE);
                }
                this.tabPane.repaint();
            } else if ("tabPlacement".equals(propName)) {
                int index2 = this.tabPane.getSelectedIndex();
                this.tabPane.setSelectedIndex(-1);
                SwingUtilities.invokeLater(() -> this.tabPane.setSelectedIndex(index2));
            }
        };
        this.tabPane.addPropertyChangeListener(this.panePropertyListener);
        this.paneComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DarculaTabbedPaneUI.this.ensureSelectedTabIsVisble();
            }
        };
        this.tabPane.addComponentListener(this.paneComponentListener);
        this.paneChangeListener = e -> this.ensureSelectedTabIsVisble();
        this.tabPane.addChangeListener(this.paneChangeListener);
        this.paneMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DarculaTabbedPaneUI.this.hoverTab = DarculaTabbedPaneUI.this.tabForCoordinate(DarculaTabbedPaneUI.this.tabPane, e.getX(), e.getY());
                DarculaTabbedPaneUI.this.tabPane.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DarculaTabbedPaneUI.this.hoverTab = -1;
                DarculaTabbedPaneUI.this.tabPane.repaint();
            }
        };
        this.tabPane.addMouseListener(this.paneMouseListener);
        this.paneMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DarculaTabbedPaneUI.this.hoverTab = DarculaTabbedPaneUI.this.tabForCoordinate(DarculaTabbedPaneUI.this.tabPane, e.getX(), e.getY());
                DarculaTabbedPaneUI.this.tabPane.repaint();
            }
        };
        this.tabPane.addMouseMotionListener(this.paneMouseMotionListener);
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane2, int x, int y) {
        if (this.myShowHiddenTabsButton != null) {
            Point p = new Point(x, y);
            JViewport viewport = this.getScrollableTabViewport();
            if (viewport != null) {
                Point vpp = viewport.getLocation();
                Point viewp = viewport.getViewPosition();
                p.x = x - vpp.x + viewp.x;
                p.y = y - vpp.y + viewp.y;
            }
            x = p.x;
            y = p.y;
        }
        return super.tabForCoordinate(pane2, x, y);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.panePropertyListener != null) {
            this.tabPane.removePropertyChangeListener(this.panePropertyListener);
        }
        if (this.paneComponentListener != null) {
            this.tabPane.removeComponentListener(this.paneComponentListener);
        }
        if (this.paneChangeListener != null) {
            this.tabPane.removeChangeListener(this.paneChangeListener);
        }
        if (this.paneMouseListener != null) {
            this.tabPane.removeMouseListener(this.paneMouseListener);
        }
        if (this.paneMouseMotionListener != null) {
            this.tabPane.removeMouseMotionListener(this.paneMouseMotionListener);
        }
    }

    private boolean isTopBottom() {
        return this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3;
    }

    private void ensureSelectedTabIsVisble() {
        Dimension extentSize;
        Rectangle tabRect;
        int index2 = this.tabPane.getSelectedIndex();
        JViewport viewport = this.getScrollableTabViewport();
        if (viewport == null || this.rects.length <= index2 || index2 < 0) {
            return;
        }
        Dimension viewSize = viewport.getViewSize();
        Rectangle viewRect = viewport.getViewRect();
        if (viewRect.contains(tabRect = this.rects[index2])) {
            return;
        }
        Point tabViewPosition = new Point();
        if (this.isTopBottom()) {
            int location = tabRect.x < viewRect.x ? tabRect.x : tabRect.x + tabRect.width - viewRect.width;
            viewport.setViewPosition(new Point(Math.max(0, Math.min(viewSize.width - viewRect.width, location)), tabRect.y));
            tabViewPosition.x = index2 == 0 ? 0 : tabRect.x;
            extentSize = new Dimension(viewSize.width - tabViewPosition.x, viewRect.height);
        } else {
            int location = tabRect.y < viewRect.y ? tabRect.y : tabRect.y + tabRect.height - viewRect.height;
            viewport.setViewPosition(new Point(tabRect.x, Math.max(0, Math.min(viewSize.height - viewRect.height, location))));
            tabViewPosition.y = index2 == 0 ? 0 : tabRect.y;
            extentSize = new Dimension(viewRect.width, viewSize.height - tabViewPosition.y);
        }
        viewport.setExtentSize(extentSize);
        PointerInfo info2 = MouseInfo.getPointerInfo();
        if (info2 != null) {
            Point mouseLocation = info2.getLocation();
            SwingUtilities.convertPointFromScreen(mouseLocation, this.tabPane);
            int oldHoverTab = this.hoverTab;
            this.hoverTab = this.tabForCoordinate(this.tabPane, mouseLocation.x, mouseLocation.y);
            if (oldHoverTab != this.hoverTab) {
                this.tabPane.repaint();
            }
        }
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        JBInsets i2 = JBInsets.create((Insets)this.contentBorderInsets);
        DarculaTabbedPaneUI.rotateInsets(this.contentBorderInsets, (Insets)i2, tabPlacement);
        return i2;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            Rectangle bounds2 = g.getClipBounds();
            g.setColor((Color)JBColor.namedColor((String)"TabbedPane.contentAreaColor", (int)0xBFBFBF));
            if (tabPlacement == 2 || tabPlacement == 4) {
                g.fillRect(bounds2.x + bounds2.width - OFFSET.get(), bounds2.y, OFFSET.get(), bounds2.y + bounds2.height);
            } else {
                g.fillRect(bounds2.x, bounds2.y + bounds2.height - OFFSET.get(), bounds2.x + bounds2.width, OFFSET.get());
            }
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        switch (this.tabStyle) {
            case fill: {
                if (this.tabPane.isEnabled()) {
                    g.setColor(isSelected ? JBUI.CurrentTheme.TabbedPane.ENABLED_SELECTED_COLOR : (tabIndex == this.hoverTab ? JBUI.CurrentTheme.TabbedPane.HOVER_COLOR : this.tabPane.getBackground()));
                    break;
                }
                g.setColor(isSelected ? JBUI.CurrentTheme.TabbedPane.DISABLED_SELECTED_COLOR : this.tabPane.getBackground());
                break;
            }
            default: {
                Color c = this.tabPane.getBackground();
                if (this.tabPane.isEnabled()) {
                    if (this.tabPane.hasFocus() && isSelected) {
                        c = JBUI.CurrentTheme.TabbedPane.FOCUS_COLOR;
                    } else if (tabIndex == this.hoverTab) {
                        c = JBUI.CurrentTheme.TabbedPane.HOVER_COLOR;
                    }
                }
                g.setColor(c);
            }
        }
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            if (tabPlacement == 2 || tabPlacement == 4) {
                w -= OFFSET.get();
            } else {
                h -= OFFSET.get();
            }
        }
        g.fillRect(x, y, w, h);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title2, Rectangle textRect, boolean isSelected) {
        View v = this.getTextViewForTab(tabIndex);
        if (v != null || this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title2, textRect, isSelected);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            g.setFont(font);
            g.setColor(JBUI.CurrentTheme.TabbedPane.DISABLED_TEXT_COLOR);
            UIUtilities.drawStringUnderlineCharAt((JComponent)this.tabPane, (Graphics)g, (String)title2, (int)mnemIndex, (int)textRect.x, (int)(textRect.y + metrics.getAscent()));
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected && this.tabStyle == TabStyle.underline) {
            g.setColor(this.tabPane.isEnabled() ? JBUI.CurrentTheme.TabbedPane.ENABLED_SELECTED_COLOR : JBUI.CurrentTheme.TabbedPane.DISABLED_SELECTED_COLOR);
            boolean wrap2 = this.tabPane.getTabLayoutPolicy() == 0;
            switch (tabPlacement) {
                case 2: {
                    int offset = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get() - (wrap2 ? OFFSET.get() : 0);
                    g.fillRect(x + w - offset, y, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get(), h);
                    break;
                }
                case 4: {
                    int offset = wrap2 ? OFFSET.get() : 0;
                    g.fillRect(x - offset, y, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get(), h);
                    break;
                }
                case 3: {
                    int offset = wrap2 ? OFFSET.get() : 0;
                    g.fillRect(x, y - offset, w, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get());
                    break;
                }
                default: {
                    int offset = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get() - (wrap2 ? OFFSET.get() : 0);
                    g.fillRect(x, y + h - offset, w, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get());
                }
            }
        }
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        int delta = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get();
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            delta -= OFFSET.get();
        }
        switch (tabPlacement) {
            case 2: 
            case 4: {
                return 0;
            }
            case 3: {
                return delta / 2;
            }
        }
        return -delta / 2;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int delta = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get();
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            delta -= OFFSET.get();
        }
        switch (tabPlacement) {
            case 1: 
            case 3: {
                return 0;
            }
            case 2: {
                return -delta / 2;
            }
        }
        return delta / 2;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) - 3;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) - 2;
        int minHeight = JBUI.CurrentTheme.TabbedPane.TAB_HEIGHT.get() - (this.tabPane.getTabLayoutPolicy() == 0 ? OFFSET.get() : 0);
        return Math.max(height, minHeight);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (Boolean.getBoolean("use.basic.tabs.scrolling")) {
            super.paint(g, c);
            return;
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
        if (this.tabsOverlapBorder) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
        if (this.myShowHiddenTabsButton == null) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        }
        if (!this.tabsOverlapBorder) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
    }

    @Nullable
    private JViewport getScrollableTabViewport() {
        Optional<JViewport> optional = UIUtil.findComponentsOfType((JComponent)this.tabPane, JViewport.class).stream().filter(viewport -> "TabbedPane.scrollableViewport".equals(viewport.getName())).findFirst();
        return optional.orElse(null);
    }

    @Override
    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        JViewport viewport = this.getScrollableTabViewport();
        if (this.myShowHiddenTabsButton != null && viewport != null) {
            Point vpp = viewport.getLocation();
            Point viewp = viewport.getViewPosition();
            dest.x = this.rects[tabIndex].x + vpp.x - viewp.x;
            dest.y = this.rects[tabIndex].y + vpp.y - viewp.y;
        } else {
            dest.x = this.rects[tabIndex].x;
            dest.y = this.rects[tabIndex].y;
        }
        return dest;
    }

    private class WrappingLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        private final BasicTabbedPaneUI.TabbedPaneLayout myDelegate;

        private WrappingLayout(BasicTabbedPaneUI.TabbedPaneLayout delegate2) {
            super(DarculaTabbedPaneUI.this);
            this.myDelegate = delegate2;
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return DarculaTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return DarculaTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        @Override
        public void calculateLayoutInfo() {
            this.myDelegate.calculateLayoutInfo();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.myDelegate.addLayoutComponent(name, comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.myDelegate.removeLayoutComponent(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.myDelegate.preferredLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.myDelegate.minimumLayoutSize(parent);
        }

        @Override
        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }

        @Override
        public void layoutContainer(Container parent) {
            DarculaTabbedPaneUI.this.myShowHiddenTabsButton.setBounds(new Rectangle());
            int selectedIndex = DarculaTabbedPaneUI.this.tabPane.getSelectedIndex();
            Rectangle selectedRectBackup = DarculaTabbedPaneUI.this.useSelectedRectBackup && selectedIndex != -1 && DarculaTabbedPaneUI.this.rects != null && DarculaTabbedPaneUI.this.rects.length > selectedIndex ? new Rectangle(DarculaTabbedPaneUI.this.rects[selectedIndex]) : null;
            this.myDelegate.layoutContainer(parent);
            if (selectedRectBackup != null) {
                ((DarculaTabbedPaneUI)DarculaTabbedPaneUI.this).rects[selectedIndex] = selectedRectBackup;
            }
            DarculaTabbedPaneUI.this.useSelectedRectBackup = true;
            ObjectUtils.consumeIfNotNull((Object)ReflectionUtil.getDeclaredField(BasicTabbedPaneUI.class, (String)"tabScroller"), field -> ObjectUtils.consumeIfNotNull((Object)ReflectionUtil.getFieldValue((Field)field, (Object)DarculaTabbedPaneUI.this), it -> ObjectUtils.consumeIfNotNull((Object)ReflectionUtil.getDeclaredField(it.getClass(), (String)"croppedEdge"), edgeField -> ObjectUtils.consumeIfNotNull((Object)ReflectionUtil.getFieldValue((Field)edgeField, (Object)it), edge -> ReflectionUtil.resetField((Object)edge, (String)"shape")))));
            if (DarculaTabbedPaneUI.this.myShowHiddenTabsButton != null && !DarculaTabbedPaneUI.this.myHiddenArrowButtons.isEmpty()) {
                Rectangle bounds2 = null;
                for (Component button4 : DarculaTabbedPaneUI.this.myHiddenArrowButtons) {
                    bounds2 = bounds2 == null ? button4.getBounds() : bounds2.union(button4.getBounds());
                    button4.setBounds(new Rectangle());
                }
                JViewport viewport = DarculaTabbedPaneUI.this.getScrollableTabViewport();
                if (bounds2.isEmpty() && viewport != null) {
                    Rectangle viewportBounds = viewport.getBounds();
                    if (DarculaTabbedPaneUI.this.isTopBottom()) {
                        int buttonsWidth = 2 * DarculaTabbedPaneUI.this.myHiddenArrowButtons.get((int)0).getPreferredSize().width;
                        viewportBounds.width -= buttonsWidth;
                        viewport.setBounds(viewportBounds);
                        DarculaTabbedPaneUI.this.ensureSelectedTabIsVisble();
                        bounds2 = new Rectangle(viewport.getX() + viewport.getWidth(), viewport.getY(), buttonsWidth, viewport.getHeight());
                    } else {
                        int buttonHeight = 2 * DarculaTabbedPaneUI.this.myHiddenArrowButtons.get((int)0).getPreferredSize().height;
                        viewportBounds.height -= buttonHeight;
                        viewport.setBounds(viewportBounds);
                        DarculaTabbedPaneUI.this.ensureSelectedTabIsVisble();
                        bounds2 = new Rectangle(viewport.getX(), viewport.getY() + viewport.getHeight(), viewport.getWidth(), buttonHeight);
                    }
                    DarculaTabbedPaneUI.this.myShowHiddenTabsButton.setBounds(bounds2);
                    return;
                }
                int placement = DarculaTabbedPaneUI.this.tabPane.getTabPlacement();
                int size2 = placement == 1 || placement == 3 ? this.preferredTabAreaHeight(DarculaTabbedPaneUI.this.tabPane.getTabPlacement(), DarculaTabbedPaneUI.this.tabPane.getWidth()) : this.preferredTabAreaWidth(DarculaTabbedPaneUI.this.tabPane.getTabPlacement(), DarculaTabbedPaneUI.this.tabPane.getWidth());
                switch (placement) {
                    case 1: {
                        bounds2.y -= size2 - bounds2.height;
                    }
                    case 3: {
                        bounds2.height = size2;
                        break;
                    }
                    case 2: {
                        bounds2.x -= size2 - bounds2.width;
                    }
                    case 4: {
                        bounds2.width = size2;
                    }
                }
                DarculaTabbedPaneUI.this.myShowHiddenTabsButton.setBounds(bounds2);
            }
        }
    }

    private class ShowHiddenTabsButton
    extends JButton
    implements UIResource {
        private ShowHiddenTabsButton() {
            super(AllIcons.Actions.FindAndShowNextMatches);
            this.setToolTipText(IdeBundle.message((String)"show.hidden.tabs", (Object[])new Object[0]));
        }

        @Override
        protected void fireActionPerformed(ActionEvent event) {
            JViewport viewport = DarculaTabbedPaneUI.this.getScrollableTabViewport();
            if (viewport == null) {
                return;
            }
            LinkedHashMap<Integer, Rectangle> invisibleTabs = new LinkedHashMap<Integer, Rectangle>();
            for (int i2 = 0; i2 < DarculaTabbedPaneUI.this.tabPane.getTabCount(); ++i2) {
                Rectangle rectangle = DarculaTabbedPaneUI.this.rects[i2];
                if (viewport.getViewRect().contains(rectangle)) continue;
                invisibleTabs.put(i2, rectangle);
            }
            JBPopupMenu menu = new JBPopupMenu();
            for (Map.Entry entry2 : invisibleTabs.entrySet()) {
                final int index2 = (Integer)entry2.getKey();
                menu.add(new JMenuItem(DarculaTabbedPaneUI.this.tabPane.getTitleAt(index2), DarculaTabbedPaneUI.this.tabPane.getIconAt(index2)){

                    @Override
                    protected void fireActionPerformed(ActionEvent event) {
                        DarculaTabbedPaneUI.this.tabPane.setSelectedIndex(index2);
                    }
                });
            }
            menu.show((Component)this, 0, this.getHeight());
        }
    }

    private static enum TabStyle {
        underline,
        fill;

    }
}

