/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class UIThemeMetadata {
    private static final NotNullLazyValue<ObjectReader> themeReader = NotNullLazyValue.lazy(() -> new ObjectMapper().readerFor(UIThemeMetadata.class));
    private String name;
    private String pluginId;
    private boolean fixed;
    private List<UIKeyMetadata> ui;

    static UIThemeMetadata loadFromJson(InputStream stream, PluginId pluginId) throws IOException {
        UIThemeMetadata metadata = (UIThemeMetadata)((ObjectReader)themeReader.getValue()).readValue(stream);
        metadata.pluginId = pluginId.getIdString();
        return metadata;
    }

    @NlsSafe
    public String getName() {
        return this.name;
    }

    @NlsSafe
    public String getPluginId() {
        return this.pluginId;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public List<UIKeyMetadata> getUiKeyMetadata() {
        return this.ui;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    private void setUi(List<UIKeyMetadata> ui2) {
        this.ui = ui2;
    }

    public static final class UIKeyMetadata {
        private String key;
        private String description;
        private String source;
        private boolean deprecated;
        private String since;

        public boolean isDeprecated() {
            return this.deprecated;
        }

        @NlsSafe
        public String getKey() {
            return this.key;
        }

        @Nullable
        @NlsSafe
        public String getDescription() {
            return this.description;
        }

        @Nullable
        @NlsSafe
        public String getSource() {
            return this.source;
        }

        @Nullable
        @NlsSafe
        public String getSince() {
            return this.since;
        }

        private void setKey(String key) {
            this.key = key;
        }

        private void setDescription(String description2) {
            this.description = description2;
        }

        private void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }

        private void setSource(String source) {
            this.source = source;
        }

        public void setSince(String since) {
            this.since = since;
        }

        public String toString() {
            return "UIKeyMetadata{key='" + this.key + "', description='" + this.description + "', source='" + this.source + "', deprecated=" + this.deprecated + ", since='" + this.since + "'}";
        }
    }
}

