/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RepositoryHelper {
    private static final Logger LOG = Logger.getInstance(RepositoryHelper.class);
    private static final String PLUGIN_LIST_FILE = "availables.xml";
    private static final String MARKETPLACE_PLUGIN_ID = "com.intellij.marketplace";
    private static final String ULTIMATE_MODULE = "com.intellij.modules.ultimate";

    @NotNull
    public static List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>(UpdateSettings.getInstance().getPluginHosts());
        String pluginsUrl = ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl();
        if (pluginsUrl != null && !"__BUILTIN_PLUGINS_URL__".equals(pluginsUrl)) {
            hosts.add(pluginsUrl);
        }
        hosts.add(null);
        ArrayList<String> arrayList = hosts;
        if (arrayList == null) {
            RepositoryHelper.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable ProgressIndicator indicator2) throws IOException {
        return new ArrayList<IdeaPluginDescriptor>(RepositoryHelper.loadPlugins(repositoryUrl, null, indicator2));
    }

    @NotNull
    public static List<PluginNode> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber build2, @Nullable ProgressIndicator indicator2) throws IOException {
        Path pluginListFile;
        Url url;
        if (repositoryUrl == null) {
            LOG.error("Using deprecated API for getting plugins from Marketplace");
            String base = ApplicationInfoImpl.getShadowInstance().getPluginsListUrl();
            url = Urls.newFromEncoded((String)base).addParameters(Map.of("uuid", PluginDownloader.getMarketplaceDownloadsUUID()));
            pluginListFile = Paths.get(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        } else {
            url = Urls.newFromEncoded((String)repositoryUrl);
            pluginListFile = null;
        }
        if (!"file".equals(url.getScheme())) {
            url = url.addParameters(Map.of("build", ApplicationInfoImpl.orFromPluginsCompatibleBuild(build2)));
        }
        if (indicator2 != null) {
            indicator2.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{url.getAuthority()}));
        }
        List descriptors2 = (List)MarketplaceRequests.readOrUpdateFile(pluginListFile, url.toExternalForm(), indicator2, IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[]{url.getAuthority()}), MarketplaceRequests::parsePluginList);
        return RepositoryHelper.process(descriptors2, build2 != null ? build2 : PluginManagerCore.getBuildNumber(), repositoryUrl);
    }

    @NotNull
    private static List<PluginNode> process(@NotNull List<PluginNode> list2, @NotNull BuildNumber build2, @Nullable String repositoryUrl) {
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(1);
        }
        if (build2 == null) {
            RepositoryHelper.$$$reportNull$$$0(2);
        }
        LinkedHashMap<PluginId, PluginNode> result2 = new LinkedHashMap<PluginId, PluginNode>(list2.size());
        boolean isPaidPluginsRequireMarketplacePlugin = RepositoryHelper.isPaidPluginsRequireMarketplacePlugin();
        for (PluginNode node2 : list2) {
            PluginNode previous;
            PluginId pluginId = node2.getPluginId();
            if (repositoryUrl != null && node2.getDownloadUrl() == null) {
                LOG.debug("Malformed plugin record (id:" + pluginId + " repository:" + repositoryUrl + ")");
                continue;
            }
            if (PluginManagerCore.isBrokenPlugin(node2) || PluginManagerCore.isIncompatible(node2, build2)) {
                LOG.debug("An incompatible plugin (id:" + pluginId + " repository:" + repositoryUrl + ")");
                continue;
            }
            if (repositoryUrl != null) {
                node2.setRepositoryName(repositoryUrl);
            }
            if (node2.getName() == null) {
                String url = node2.getDownloadUrl();
                node2.setName(FileUtilRt.getNameWithoutExtension((String)url.substring(url.lastIndexOf(47) + 1)));
            }
            if ((previous = (PluginNode)result2.get(pluginId)) == null || VersionComparatorUtil.compare((String)node2.getVersion(), (String)previous.getVersion()) > 0) {
                result2.put(pluginId, node2);
            }
            RepositoryHelper.addMarketplacePluginDependencyIfRequired(node2, isPaidPluginsRequireMarketplacePlugin);
        }
        List<PluginNode> list3 = result2.values().stream().collect(Collectors.toUnmodifiableList());
        if (list3 == null) {
            RepositoryHelper.$$$reportNull$$$0(3);
        }
        return list3;
    }

    public static void addMarketplacePluginDependencyIfRequired(@NotNull PluginNode node2) {
        if (node2 == null) {
            RepositoryHelper.$$$reportNull$$$0(4);
        }
        boolean isPaidPluginsRequireMarketplacePlugin = RepositoryHelper.isPaidPluginsRequireMarketplacePlugin();
        RepositoryHelper.addMarketplacePluginDependencyIfRequired(node2, isPaidPluginsRequireMarketplacePlugin);
    }

    private static boolean isPaidPluginsRequireMarketplacePlugin() {
        boolean isCommunityIDE = !RepositoryHelper.ideContainsUltimateModule();
        boolean isVendorNotJetBrains = !ApplicationInfoImpl.getShadowInstance().isVendorJetBrains();
        return isCommunityIDE || isVendorNotJetBrains;
    }

    private static void addMarketplacePluginDependencyIfRequired(@NotNull PluginNode node2, boolean isPaidPluginsRequireMarketplacePlugin) {
        if (node2 == null) {
            RepositoryHelper.$$$reportNull$$$0(5);
        }
        if (isPaidPluginsRequireMarketplacePlugin && node2.getProductCode() != null) {
            node2.addDepends(MARKETPLACE_PLUGIN_ID, false);
        }
    }

    private static boolean ideContainsUltimateModule() {
        IdeaPluginDescriptor corePlugin = PluginManagerCore.getPlugin(PluginManagerCore.CORE_ID);
        IdeaPluginDescriptorImpl corePluginImpl = corePlugin instanceof IdeaPluginDescriptorImpl ? (IdeaPluginDescriptorImpl)corePlugin : null;
        return corePluginImpl != null && corePluginImpl.modules.contains(PluginId.getId((String)ULTIMATE_MODULE));
    }

    @ApiStatus.Internal
    @NotNull
    public static Collection<PluginNode> mergePluginsFromRepositories(@NotNull List<PluginNode> marketplacePlugins, @NotNull List<PluginNode> customPlugins, boolean addMissing) {
        if (marketplacePlugins == null) {
            RepositoryHelper.$$$reportNull$$$0(6);
        }
        if (customPlugins == null) {
            RepositoryHelper.$$$reportNull$$$0(7);
        }
        LinkedHashMap<PluginId, PluginNode> compatiblePluginMap = new LinkedHashMap<PluginId, PluginNode>(marketplacePlugins.size());
        for (PluginNode marketplacePlugin : marketplacePlugins) {
            compatiblePluginMap.put(marketplacePlugin.getPluginId(), marketplacePlugin);
        }
        for (PluginNode customPlugin : customPlugins) {
            PluginId pluginId = customPlugin.getPluginId();
            IdeaPluginDescriptor plugin2 = (IdeaPluginDescriptor)compatiblePluginMap.get(pluginId);
            if ((plugin2 != null || !addMissing) && (plugin2 == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(customPlugin.getVersion(), plugin2) <= 0)) continue;
            compatiblePluginMap.put(pluginId, customPlugin);
        }
        Collection<PluginNode> collection = compatiblePluginMap.values();
        if (collection == null) {
            RepositoryHelper.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/RepositoryHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marketplacePlugins";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginHosts";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/RepositoryHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mergePluginsFromRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMarketplacePluginDependencyIfRequired";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergePluginsFromRepositories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

