/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginReplacement;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.InstallationSourceEnum;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginInstallOperation {
    private static final Logger LOG = Logger.getInstance(PluginInstallOperation.class);
    private static final Cache<String, Optional<PluginId>> ourCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    @NotNull
    private final List<PluginNode> myPluginsToInstall;
    @NotNull
    private final Collection<PluginNode> myCustomReposPlugins;
    @NotNull
    private final PluginEnabler myPluginEnabler;
    @NotNull
    private final ProgressIndicator myIndicator;
    private boolean mySuccess;
    private final Set<PluginInstallCallbackData> myDependant;
    private boolean myAllowInstallWithoutRestart;
    private final List<PendingDynamicPluginInstall> myPendingDynamicPluginInstalls;
    private boolean myRestartRequired;
    private boolean myShownErrors;
    private static final Map<PluginId, ActionCallback> ourInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
    private final Map<PluginId, ActionCallback> myLocalInstallCallbacks;
    private final Map<PluginId, ActionCallback> myLocalWaitInstallCallbacks;
    private static final Object ourInstallLock = new Object();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public PluginInstallOperation(@NotNull List<PluginNode> pluginsToInstall, @NotNull List<? extends IdeaPluginDescriptor> customReposPlugins, @NotNull PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator2) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(0);
        }
        if (customReposPlugins == null) {
            PluginInstallOperation.$$$reportNull$$$0(1);
        }
        if (pluginEnabler == null) {
            PluginInstallOperation.$$$reportNull$$$0(2);
        }
        if (indicator2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(3);
        }
        this(pluginsToInstall, ContainerUtil.filterIsInstance(customReposPlugins, PluginNode.class), (PluginEnabler)pluginEnabler, indicator2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginInstallOperation(@NotNull List<PluginNode> pluginsToInstall, @NotNull Collection<PluginNode> customReposPlugins, @NotNull PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator2) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(4);
        }
        if (customReposPlugins == null) {
            PluginInstallOperation.$$$reportNull$$$0(5);
        }
        if (pluginEnabler == null) {
            PluginInstallOperation.$$$reportNull$$$0(6);
        }
        if (indicator2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(7);
        }
        this.mySuccess = true;
        this.myDependant = new HashSet<PluginInstallCallbackData>();
        this.myAllowInstallWithoutRestart = false;
        this.myPendingDynamicPluginInstalls = new ArrayList<PendingDynamicPluginInstall>();
        this.myRestartRequired = false;
        this.myLocalInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
        this.myLocalWaitInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
        this.myPluginsToInstall = pluginsToInstall;
        this.myCustomReposPlugins = customReposPlugins;
        this.myPluginEnabler = pluginEnabler;
        this.myIndicator = indicator2;
        Object object = ourInstallLock;
        synchronized (object) {
            for (PluginNode node2 : pluginsToInstall) {
                PluginId id2 = node2.getPluginId();
                ActionCallback callback2 = ourInstallCallbacks.get(id2);
                if (callback2 == null) {
                    this.createInstallCallback(id2);
                    continue;
                }
                this.myLocalWaitInstallCallbacks.put(id2, callback2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstallCallback(@NotNull PluginId id2, @NotNull ActionCallback callback2, boolean isDone) {
        if (id2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(8);
        }
        if (callback2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(9);
        }
        Object object = ourInstallLock;
        synchronized (object) {
            ActionCallback oldValue = ourInstallCallbacks.get(id2);
            if (oldValue == callback2) {
                ourInstallCallbacks.remove(id2);
            }
        }
        if (isDone) {
            callback2.setDone();
        } else {
            callback2.setRejected();
        }
    }

    private void createInstallCallback(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(10);
        }
        ActionCallback callback2 = new ActionCallback();
        ourInstallCallbacks.put(id2, callback2);
        this.myLocalInstallCallbacks.put(id2, callback2);
    }

    public void setAllowInstallWithoutRestart(boolean allowInstallWithoutRestart) {
        this.myAllowInstallWithoutRestart = allowInstallWithoutRestart;
    }

    public List<PendingDynamicPluginInstall> getPendingDynamicPluginInstalls() {
        return this.myPendingDynamicPluginInstalls;
    }

    public boolean isRestartRequired() {
        return this.myRestartRequired;
    }

    public void run() {
        this.updateUrls();
        this.mySuccess = this.prepareToInstall(this.myPluginsToInstall);
    }

    public boolean isSuccess() {
        return this.mySuccess;
    }

    public Set<PluginInstallCallbackData> getInstalledDependentPlugins() {
        return this.myDependant;
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    private void updateUrls() {
        boolean unknownNodes = false;
        for (PluginNode node2 : this.myPluginsToInstall) {
            if (node2.getRepositoryName() != "__unknown_repository__") continue;
            unknownNodes = true;
            break;
        }
        if (!unknownNodes) {
            return;
        }
        SmartList hosts = new SmartList();
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.addAll(UpdateSettings.getInstance().getPluginHosts());
        HashMap<PluginId, PluginNode> allPlugins = new HashMap<PluginId, PluginNode>();
        for (String host : hosts) {
            try {
                for (PluginNode descriptor2 : RepositoryHelper.loadPlugins(host, null, this.myIndicator)) {
                    allPlugins.put(descriptor2.getPluginId(), descriptor2);
                }
            }
            catch (IOException iOException) {
            }
        }
        for (PluginNode node3 : this.myPluginsToInstall) {
            if (node3.getRepositoryName() != "__unknown_repository__") continue;
            PluginNode descriptor3 = (PluginNode)allPlugins.get(node3.getPluginId());
            node3.setRepositoryName(descriptor3 != null ? descriptor3.getRepositoryName() : null);
            if (descriptor3 == null) continue;
            node3.setDownloadUrl(descriptor3.getDownloadUrl());
        }
    }

    private boolean prepareToInstall(@NotNull List<PluginNode> pluginsToInstall) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(11);
        }
        SmartList pluginIds2 = new SmartList();
        for (PluginNode pluginNode : pluginsToInstall) {
            pluginIds2.add(pluginNode.getPluginId());
        }
        boolean result2 = false;
        for (PluginNode pluginNode : pluginsToInstall) {
            this.myIndicator.setText(pluginNode.getName());
            try {
                result2 |= this.prepareToInstallWithCallback(pluginNode, (List<PluginId>)pluginIds2);
            }
            catch (IOException e) {
                String title2 = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Plugin Error", (String)title2), title2, pluginNode.getName() + ": " + e.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result2;
    }

    private boolean prepareToInstallWithCallback(@NotNull PluginNode pluginNode, @NotNull List<PluginId> pluginIds2) throws IOException {
        PluginId id2;
        ActionCallback localCallback;
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(12);
        }
        if (pluginIds2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(13);
        }
        if ((localCallback = this.myLocalInstallCallbacks.remove(id2 = pluginNode.getPluginId())) == null) {
            ActionCallback callback2 = this.myLocalWaitInstallCallbacks.remove(id2);
            if (callback2 == null) {
                return this.prepareToInstall(pluginNode, pluginIds2);
            }
            return callback2.waitFor(-1L) && callback2.isDone();
        }
        try {
            boolean result2 = this.prepareToInstall(pluginNode, pluginIds2);
            PluginInstallOperation.removeInstallCallback(id2, localCallback, result2);
            return result2;
        }
        catch (IOException | RuntimeException e) {
            PluginInstallOperation.removeInstallCallback(id2, localCallback, false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToInstall(@NotNull PluginNode pluginNode, @NotNull List<PluginId> pluginIds2) throws IOException {
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(14);
        }
        if (pluginIds2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(15);
        }
        if (!this.checkMissingDependencies(pluginNode, pluginIds2)) {
            return false;
        }
        IdeaPluginDescriptor toDisable = this.checkDependenciesAndReplacements(pluginNode);
        this.myShownErrors = false;
        PluginDownloader downloader = PluginDownloader.createDownloader(pluginNode, pluginNode.getRepositoryName(), null);
        IdeaPluginDescriptor previousDescriptor = PluginManagerCore.getPlugin(pluginNode.getPluginId());
        String previousVersion = previousDescriptor == null ? null : previousDescriptor.getVersion();
        PluginManagerUsageCollector.pluginInstallationStarted(pluginNode, downloader.isFromMarketplace() ? InstallationSourceEnum.MARKETPLACE : InstallationSourceEnum.CUSTOM_REPOSITORY, previousVersion);
        IdeaPluginDescriptorImpl descriptor2 = downloader.prepareToInstallAndLoadDescriptor(this.myIndicator);
        if (descriptor2 != null) {
            boolean allowNoRestart;
            if (pluginNode.getDependencies().isEmpty() && !descriptor2.getDependencies().isEmpty() && !this.checkMissingDependencies(descriptor2, pluginIds2)) {
                return false;
            }
            boolean bl = allowNoRestart = this.myAllowInstallWithoutRestart && DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor2);
            if (allowNoRestart) {
                this.myPendingDynamicPluginInstalls.add(new PendingDynamicPluginInstall(downloader.getFile().toPath(), descriptor2));
                InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
                if (state != null) {
                    state.onPluginInstall(downloader.getDescriptor(), false, false);
                }
            } else {
                this.myRestartRequired = true;
                Object object = PluginInstaller.ourLock;
                synchronized (object) {
                    downloader.install();
                }
            }
            this.myDependant.add(new PluginInstallCallbackData(downloader.getFile().toPath(), descriptor2, !allowNoRestart));
            pluginNode.setStatus(PluginNode.Status.DOWNLOADED);
            if (toDisable != null) {
                this.myPluginEnabler.disablePlugins(Set.of(toDisable));
            }
        } else {
            this.myShownErrors = downloader.isShownErrors();
            return false;
        }
        return true;
    }

    @Nullable
    IdeaPluginDescriptor checkDependenciesAndReplacements(@NotNull IdeaPluginDescriptor pluginNode) {
        PluginReplacement pluginReplacement;
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(16);
        }
        if ((pluginReplacement = (PluginReplacement)ContainerUtil.find((Object[])((PluginReplacement[])PluginReplacement.EP_NAME.getExtensions()), r -> r.getNewPluginId().equals(pluginNode.getPluginId().getIdString()))) == null) {
            return null;
        }
        PluginId oldPluginId = pluginReplacement.getOldPluginDescriptor().getPluginId();
        IdeaPluginDescriptor oldPlugin = PluginManagerCore.getPlugin(oldPluginId);
        if (oldPlugin == null) {
            LOG.warn("Plugin with id '" + oldPluginId + "' not found");
            return null;
        }
        if (this.myPluginEnabler.isDisabled(oldPlugin.getPluginId())) {
            return null;
        }
        AtomicBoolean toDisable = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            boolean choice = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)pluginReplacement.getReplacementMessage(oldPlugin, pluginNode), (String)IdeBundle.message((String)"plugin.manager.obsolete.plugins.detected.title", (Object[])new Object[0])).yesText(IdeBundle.message((String)"button.disable", (Object[])new Object[0]))).noText(Messages.getNoButton())).icon(Messages.getWarningIcon())).guessWindowAndAsk();
            toDisable.set(choice);
        }, ModalityState.any());
        return toDisable.get() ? oldPlugin : null;
    }

    boolean checkMissingDependencies(@NotNull IdeaPluginDescriptor pluginNode, @Nullable List<PluginId> pluginIds2) {
        List dependencies;
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(17);
        }
        if (!(dependencies = pluginNode.getDependencies()).isEmpty()) {
            ArrayList<PluginNode> depends = new ArrayList<PluginNode>();
            ArrayList<PluginNode> optionalDeps = new ArrayList<PluginNode>();
            for (IdeaPluginDependency dependency : dependencies) {
                PluginId depPluginId = dependency.getPluginId();
                if (PluginManagerCore.isModuleDependency(depPluginId)) {
                    PluginId pluginIdByModule;
                    IdeaPluginDescriptor descriptorByModule = PluginManagerCore.findPluginByModuleDependency(depPluginId);
                    PluginId pluginId = pluginIdByModule = descriptorByModule != null ? descriptorByModule.getPluginId() : PluginInstallOperation.getCachedPluginId(depPluginId.getIdString());
                    if (pluginIdByModule == null) continue;
                    depPluginId = pluginIdByModule;
                }
                if (PluginManagerCore.isPluginInstalled(depPluginId) || InstalledPluginsState.getInstance().wasInstalled(depPluginId) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart(depPluginId) || pluginIds2 != null && pluginIds2.contains(depPluginId)) continue;
                IdeaPluginDescriptor depPluginDescriptor = this.findPluginInRepo(depPluginId);
                PluginNode depPlugin = depPluginDescriptor instanceof PluginNode ? (PluginNode)depPluginDescriptor : new PluginNode(depPluginId, depPluginId.getIdString(), "-1");
                if (depPluginDescriptor == null) continue;
                if (dependency.isOptional()) {
                    optionalDeps.add(depPlugin);
                    continue;
                }
                depends.add(depPlugin);
            }
            if (!this.prepareDependencies(pluginNode, depends, "plugin.manager.dependencies.detected.title", "plugin.manager.dependencies.detected.message")) {
                return false;
            }
            if (Registry.is((String)"ide.plugins.suggest.install.optional.dependencies") && !this.prepareDependencies(pluginNode, optionalDeps, "plugin.manager.optional.dependencies.detected.title", "plugin.manager.optional.dependencies.detected.message")) {
                return false;
            }
        }
        return true;
    }

    private boolean prepareDependencies(@NotNull IdeaPluginDescriptor pluginNode, @NotNull List<PluginNode> depends, @NotNull String titleKey, @NotNull String messageKey) {
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(18);
        }
        if (depends == null) {
            PluginInstallOperation.$$$reportNull$$$0(19);
        }
        if (titleKey == null) {
            PluginInstallOperation.$$$reportNull$$$0(20);
        }
        if (messageKey == null) {
            PluginInstallOperation.$$$reportNull$$$0(21);
        }
        if (depends.isEmpty()) {
            return true;
        }
        boolean[] proceed = new boolean[1];
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                Object object = ourInstallLock;
                synchronized (object) {
                    ArrayList<PluginNode> dependsToShow = new ArrayList<PluginNode>();
                    Iterator I = depends.iterator();
                    while (I.hasNext()) {
                        PluginNode node2 = (PluginNode)I.next();
                        PluginId id2 = node2.getPluginId();
                        ActionCallback callback2 = ourInstallCallbacks.get(id2);
                        if (callback2 == null || callback2.isRejected()) {
                            if (InstalledPluginsState.getInstance().wasInstalled(id2) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart(id2)) {
                                I.remove();
                                continue;
                            }
                            dependsToShow.add(node2);
                            continue;
                        }
                        this.myLocalWaitInstallCallbacks.put(id2, callback2);
                    }
                    if (dependsToShow.isEmpty()) {
                        proceed[0] = true;
                        return;
                    }
                    String title2 = IdeBundle.message((String)titleKey, (Object[])new Object[0]);
                    String deps = PluginInstallOperation.getPluginsText(depends);
                    String message2 = IdeBundle.message((String)messageKey, (Object[])new Object[]{pluginNode.getName(), deps});
                    boolean bl = proceed[0] = Messages.showYesNoDialog((String)message2, (String)title2, (String)IdeBundle.message((String)"button.install", (Object[])new Object[0]), (String)Messages.getNoButton(), (Icon)Messages.getWarningIcon()) == 0;
                    if (proceed[0]) {
                        for (PluginNode depend : dependsToShow) {
                            this.createInstallCallback(depend.getPluginId());
                        }
                    }
                }
            }, ModalityState.any());
        }
        catch (Exception e) {
            return false;
        }
        if (depends.isEmpty()) {
            return true;
        }
        return proceed[0] && this.prepareToInstall(depends);
    }

    @NotNull
    private static String getPluginsText(@NotNull List<PluginNode> pluginNodes) {
        int size2;
        if (pluginNodes == null) {
            PluginInstallOperation.$$$reportNull$$$0(22);
        }
        if ((size2 = pluginNodes.size()) == 1) {
            String string = "\"" + pluginNodes.get(0).getName() + "\" plugin";
            if (string == null) {
                PluginInstallOperation.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = StringUtil.join(pluginNodes.subList(0, size2 - 1), node2 -> "\"" + node2.getName() + "\"", (String)", ") + " and \"" + pluginNodes.get(size2 - 1) + "\" plugins";
        if (string == null) {
            PluginInstallOperation.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    private IdeaPluginDescriptor findPluginInRepo(@NotNull PluginId depPluginId) {
        if (depPluginId == null) {
            PluginInstallOperation.$$$reportNull$$$0(25);
        }
        IdeaPluginDescriptor pluginFromCustomRepos = ((Stream)this.myCustomReposPlugins.stream().parallel()).filter(p -> p.getPluginId().equals((Object)depPluginId)).findAny().orElse(null);
        PluginNode pluginFromMarketplace = MarketplaceRequests.getInstance().getLastCompatiblePluginUpdate(depPluginId);
        if (pluginFromCustomRepos == null) {
            return pluginFromMarketplace;
        }
        if (pluginFromMarketplace == null) {
            return pluginFromCustomRepos;
        }
        if (PluginDownloader.compareVersionsSkipBrokenAndIncompatible(pluginFromCustomRepos.getVersion(), pluginFromMarketplace) > 0) {
            return pluginFromCustomRepos;
        }
        return pluginFromMarketplace;
    }

    @Nullable
    private static PluginId getCachedPluginId(@NotNull String pluginId) {
        Optional cachedModule;
        if (pluginId == null) {
            PluginInstallOperation.$$$reportNull$$$0(26);
        }
        if ((cachedModule = (Optional)ourCache.getIfPresent((Object)pluginId)) != null && cachedModule.isPresent()) {
            return (PluginId)cachedModule.get();
        }
        PluginId result2 = MarketplaceRequests.getInstance().getCompatibleUpdateByModule(pluginId);
        ourCache.put((Object)pluginId, Optional.ofNullable(result2));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customReposPlugins";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNode";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depends";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleKey";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNodes";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depPluginId";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeInstallCallback";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInstallCallback";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstallWithCallback";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkDependenciesAndReplacements";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkMissingDependencies";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepareDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsText";
                break;
            }
            case 23: 
            case 24: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findPluginInRepo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPluginId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

