/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.ui;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.jetbrains.annotations.Nullable;

public class PasswordPromptComponent {
    private JPanel myRootPanel;
    private JPanel myMessagePanel;
    private JPanel myUserPanel;
    private JPasswordField myPasswordField;
    private JCheckBox myRememberCheckBox;
    private JLabel myPasswordLabel;
    private JTextField myUserTextField;
    private JLabel myIconLabel;

    public PasswordPromptComponent(boolean memoryOnly, @NlsContexts.DialogMessage String message2) {
        this(memoryOnly, message2, true, null);
    }

    public PasswordPromptComponent(boolean memoryOnly, @NlsContexts.DialogMessage String message2, boolean showUserName, @NlsContexts.Label @Nullable String passwordFieldLabel) {
        this.$$$setupUI$$$();
        this.myIconLabel.setText("");
        this.myIconLabel.setIcon(Messages.getWarningIcon());
        JTextPane messageField = Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)message2, (UIUtil.FontSize)UIUtil.FontSize.SMALL);
        this.myMessagePanel.add((Component)Messages.wrapToScrollPaneIfNeeded((JComponent)messageField, (int)80, (int)4), "Center");
        if (memoryOnly) {
            this.myRememberCheckBox.setVisible(false);
            this.myRememberCheckBox.setEnabled(false);
            this.myRememberCheckBox.setSelected(false);
        } else {
            this.myRememberCheckBox.setSelected(PasswordSafe.getInstance().isRememberPasswordByDefault());
            this.myRememberCheckBox.setToolTipText(IdeBundle.message((String)"tooltip.text.password.will.be.stored.between.application.sessions", (Object[])new Object[0]));
        }
        this.setUserInputVisible(showUserName);
        if (passwordFieldLabel != null) {
            this.myPasswordLabel.setText(passwordFieldLabel);
        }
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUserTextField.isEnabled() && StringUtil.isEmpty((String)this.myUserTextField.getText()) ? this.myUserTextField : this.myPasswordField;
    }

    private void setUserInputVisible(boolean visible) {
        UIUtil.setEnabled((Component)this.myUserPanel, (boolean)visible, (boolean)true);
        this.myUserPanel.setVisible(visible);
    }

    public String getUserName() {
        return this.myUserTextField.getText();
    }

    public void setUserName(String text2) {
        this.myUserTextField.setText(text2);
    }

    public char[] getPassword() {
        return this.myPasswordField.getPassword();
    }

    public void setPassword(String text2) {
        this.myPasswordField.setText(text2);
    }

    public boolean isRememberSelected() {
        return this.myRememberCheckBox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel2;
        JPasswordField jPasswordField;
        JLabel jLabel2;
        JTextField jTextField;
        JPanel jPanel3;
        JCheckBox jCheckBox;
        JPanel jPanel4;
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(15, 10, 0, 20), null, 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 1, 1, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10), null, 0, 0, null, null));
        this.myRememberCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", PasswordPromptComponent.class).getString("checkbox.password.safe.remember"));
        jPanel6.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myUserPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/IdeBundle", PasswordPromptComponent.class).getString("label.password.safe.user"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUserTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myPasswordLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/IdeBundle", PasswordPromptComponent.class).getString("label.password.safe.password"));
        jPanel7.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPasswordField.setText("");
        jPanel7.add((Component)jPasswordField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        this.myMessagePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myIconLabel = jLabel = new JLabel();
        jLabel.setText("icon");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

