/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorMacro
extends Macro {
    private final String myName;
    @Nls
    private final String myDescription;

    public EditorMacro(@NotNull String name, @NotNull @Nls String description2) {
        if (name == null) {
            EditorMacro.$$$reportNull$$$0(0);
        }
        if (description2 == null) {
            EditorMacro.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myDescription = description2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            EditorMacro.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            EditorMacro.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public final String expand(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            EditorMacro.$$$reportNull$$$0(4);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null) {
            return this.expand(editor);
        }
        return null;
    }

    protected static String getColumnNumber(Editor editor, LogicalPosition pos) {
        if (EditorUtil.inVirtualSpace(editor, pos)) {
            return String.valueOf(pos.column + 1);
        }
        int offset = editor.logicalPositionToOffset(pos);
        int lineStart = editor.getDocument().getLineStartOffset(editor.getDocument().getLineNumber(offset));
        return String.valueOf(offset - lineStart + 1);
    }

    @Nullable
    protected abstract String expand(Editor var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/macro/EditorMacro";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/macro/EditorMacro";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

