/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.convert;

import com.intellij.conversion.CannotConvertException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.JDOMUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class JDomConvertingUtil {
    private JDomConvertingUtil() {
    }

    public static Element load(Path file2) throws CannotConvertException {
        try {
            return JDOMUtil.load((Path)file2);
        }
        catch (IOException | JDOMException e) {
            throw new CannotConvertException(file2 + ": " + e.getMessage(), e);
        }
    }

    public static String getOptionValue(Element element2, String optionName) {
        return JDOMExternalizerUtil.readField((Element)element2, (String)optionName);
    }

    public static Condition<Element> createAttributeValueFilter(@NonNls String name, @NonNls String value2) {
        return JDomConvertingUtil.createAttributeValueFilter(name, Collections.singleton(value2));
    }

    public static Condition<Element> createAttributeValueFilter(@NonNls String name, @NonNls Collection<String> value2) {
        return element2 -> value2.contains(element2.getAttributeValue(name));
    }

    public static Condition<Element> createElementWithAttributeFilter(String elementName, String attributeName, String attributeValue) {
        return Conditions.and(JDomConvertingUtil.createElementNameFilter(elementName), JDomConvertingUtil.createAttributeValueFilter(attributeName, attributeValue));
    }

    public static Condition<Element> createElementNameFilter(@NonNls String elementName) {
        return element2 -> elementName.equals(element2.getName());
    }

    public static List<Element> removeChildren(Element element2, Condition<? super Element> filter) {
        ArrayList<Element> toRemove2 = new ArrayList<Element>();
        List list2 = element2.getChildren();
        for (Element e : list2) {
            if (!filter.value((Object)e)) continue;
            toRemove2.add(e);
        }
        for (Element e : toRemove2) {
            element2.removeContent((Content)e);
        }
        return toRemove2;
    }

    @Nullable
    public static Element findChild(Element parent, Condition<? super Element> filter) {
        List list2 = parent.getChildren();
        for (Element e : list2) {
            if (!filter.value((Object)e)) continue;
            return e;
        }
        return null;
    }

    public static void removeDuplicatedOptions(Element element2) {
        ArrayList children2 = new ArrayList(element2.getChildren("option"));
        HashSet<String> names2 = new HashSet<String>();
        for (Element child2 : children2) {
            if (names2.add(child2.getAttributeValue("name"))) continue;
            element2.removeContent((Content)child2);
        }
    }
}

