/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.OpenUntrustedProjectChoice;
import com.intellij.ide.impl.TrustChangeNotifier;
import com.intellij.ide.impl.TrustedCheckResult;
import com.intellij.ide.impl.TrustedPathsSettings;
import com.intellij.ide.impl.TrustedProjectSettings;
import com.intellij.ide.impl.TrustedProjectsStatistics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004\u001a@\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u00042\b\b\u0001\u0010\u0011\u001a\u00020\u0004\u001a\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001e\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a\b\u0010\u001c\u001a\u00020\u0006H\u0002\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\b\u001a\n\u0010\u001f\u001a\u00020\u0006*\u00020\b\u001a\u0012\u0010 \u001a\u00020!*\u00020\b2\u0006\u0010\"\u001a\u00020\u0006\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TRUSTED_PROJECTS_HELP_TOPIC", "", "confirmLoadingUntrustedProject", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "message", "trustButtonText", "distrustButtonText", "confirmOpeningUntrustedProject", "Lcom/intellij/ide/impl/OpenUntrustedProjectChoice;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cancelButtonText", "projectTypeNames", "", "createDoNotAskOptionForLocation", "Lcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;", "projectLocationPath", "getImplicitTrustedCheckResult", "Lcom/intellij/ide/impl/TrustedCheckResult;", "projectDir", "Ljava/nio/file/Path;", "isProjectImplicitlyTrusted", "isTrustedCheckDisabled", "getTrustedState", "Lcom/intellij/util/ThreeState;", "isTrusted", "setTrusted", "", "value", "intellij.platform.ide.impl"})
@JvmName(name="TrustedProjects")
@ApiStatus.Experimental
public final class TrustedProjects {
    @NotNull
    public static final String TRUSTED_PROJECTS_HELP_TOPIC = "Project_security";
    private static final Logger LOG;

    @NotNull
    public static final OpenUntrustedProjectChoice confirmOpeningUntrustedProject(@NotNull VirtualFile virtualFile2, @NotNull List<String> projectTypeNames) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(projectTypeNames, (String)"projectTypeNames");
        String string = StringUtil.naturalJoin(projectTypeNames);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.naturalJoin(projectTypeNames)");
        String systemsPresentation = string;
        String string2 = IdeBundle.message((String)"untrusted.project.open.dialog.title", (Object[])new Object[]{systemsPresentation, projectTypeNames.size()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"untru\u2026n, projectTypeNames.size)");
        String string3 = IdeBundle.message((String)"untrusted.project.open.dialog.text", (Object[])new Object[]{systemsPresentation, projectTypeNames.size()});
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdeBundle.message(\"untru\u2026n, projectTypeNames.size)");
        String string4 = IdeBundle.message((String)"untrusted.project.dialog.trust.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"IdeBundle.message(\"untru\u2026ect.dialog.trust.button\")");
        String string5 = IdeBundle.message((String)"untrusted.project.open.dialog.distrust.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"IdeBundle.message(\"untru\u2026.dialog.distrust.button\")");
        String string6 = IdeBundle.message((String)"untrusted.project.open.dialog.cancel.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"IdeBundle.message(\"untru\u2026en.dialog.cancel.button\")");
        return TrustedProjects.confirmOpeningUntrustedProject(virtualFile2, string2, string3, string4, string5, string6);
    }

    @NotNull
    public static final OpenUntrustedProjectChoice confirmOpeningUntrustedProject(@NotNull VirtualFile virtualFile2, @NlsContexts.DialogTitle @NotNull String title2, @NlsContexts.DialogMessage @NotNull String message2, @NlsContexts.Button @NotNull String trustButtonText, @NlsContexts.Button @NotNull String distrustButtonText, @NlsContexts.Button @NotNull String cancelButtonText) {
        OpenUntrustedProjectChoice openUntrustedProjectChoice;
        String choice;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)trustButtonText, (String)"trustButtonText");
        Intrinsics.checkNotNullParameter((Object)distrustButtonText, (String)"distrustButtonText");
        Intrinsics.checkNotNullParameter((Object)cancelButtonText, (String)"cancelButtonText");
        VirtualFile projectDir = virtualFile2.isDirectory() ? virtualFile2 : virtualFile2.getParent();
        TrustedCheckResult trustedCheckResult = TrustedProjects.getImplicitTrustedCheckResult$default(projectDir.toNioPath(), null, 2, null);
        if (trustedCheckResult instanceof TrustedCheckResult.Trusted) {
            return OpenUntrustedProjectChoice.IMPORT;
        }
        MessageDialogBuilder.Message message3 = new MessageDialogBuilder.Message(title2, message2).buttons(new String[]{trustButtonText, distrustButtonText, cancelButtonText}).defaultButton(trustButtonText).focusedButton(distrustButtonText);
        VirtualFile virtualFile3 = projectDir;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"projectDir");
        VirtualFile virtualFile4 = virtualFile3.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"projectDir.parent");
        String string = virtualFile4.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectDir.parent.path");
        String string2 = choice = MessageDialogBuilder.Message.show$default((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)message3.doNotAsk(TrustedProjects.createDoNotAskOptionForLocation(string))).asWarning()).help(TRUSTED_PROJECTS_HELP_TOPIC)), null, null, (int)3, null);
        if (Intrinsics.areEqual((Object)string2, (Object)trustButtonText)) {
            openUntrustedProjectChoice = OpenUntrustedProjectChoice.IMPORT;
        } else if (Intrinsics.areEqual((Object)string2, (Object)distrustButtonText)) {
            openUntrustedProjectChoice = OpenUntrustedProjectChoice.OPEN_WITHOUT_IMPORTING;
        } else if (Intrinsics.areEqual((Object)string2, (Object)cancelButtonText) || string2 == null) {
            openUntrustedProjectChoice = OpenUntrustedProjectChoice.CANCEL;
        } else {
            LOG.error("Illegal choice " + choice);
            return OpenUntrustedProjectChoice.CANCEL;
        }
        OpenUntrustedProjectChoice openChoice = openUntrustedProjectChoice;
        TrustedProjectsStatistics.Companion.getNEW_PROJECT_OPEN_OR_IMPORT_CHOICE().log((Object)openChoice);
        return openChoice;
    }

    public static final boolean confirmLoadingUntrustedProject(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title2, @NlsContexts.DialogMessage @NotNull String message2, @NlsContexts.Button @NotNull String trustButtonText, @NlsContexts.Button @NotNull String distrustButtonText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)trustButtonText, (String)"trustButtonText");
        Intrinsics.checkNotNullParameter((Object)distrustButtonText, (String)"distrustButtonText");
        TrustedCheckResult trustedCheckResult = TrustedProjects.getImplicitTrustedCheckResult(project);
        if (trustedCheckResult instanceof TrustedCheckResult.Trusted) {
            TrustedProjects.setTrusted(project, true);
            return true;
        }
        boolean answer = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(title2, message2).yesText(trustButtonText)).noText(distrustButtonText)).asWarning()).help(TRUSTED_PROJECTS_HELP_TOPIC)).ask(project);
        TrustedProjects.setTrusted(project, answer);
        TrustedProjectsStatistics.Companion.getLOAD_UNTRUSTED_PROJECT_CONFIRMATION_CHOICE().log(project, (Object)answer);
        return answer;
    }

    public static final boolean isTrusted(@NotNull Project $this$isTrusted) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrusted, (String)"$this$isTrusted");
        return TrustedProjects.getTrustedState($this$isTrusted) == ThreeState.YES;
    }

    @NotNull
    public static final ThreeState getTrustedState(@NotNull Project $this$getTrustedState) {
        Intrinsics.checkNotNullParameter((Object)$this$getTrustedState, (String)"$this$getTrustedState");
        Project $this$service$iv = $this$getTrustedState;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ThreeState explicit = ((TrustedProjectSettings)((Object)object)).getTrustedState();
        if (explicit != ThreeState.UNSURE) {
            return explicit;
        }
        return TrustedProjects.getImplicitTrustedCheckResult($this$getTrustedState) instanceof TrustedCheckResult.Trusted ? ThreeState.YES : ThreeState.UNSURE;
    }

    public static final void setTrusted(@NotNull Project $this$setTrusted, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)$this$setTrusted, (String)"$this$setTrusted");
        Project $this$service$iv = $this$setTrusted;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ThreeState oldValue = ((TrustedProjectSettings)((Object)object)).getTrustedState();
        $this$service$iv = $this$setTrusted;
        $i$f$service = false;
        Object object2 = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
        TrustedProjectSettings trustedProjectSettings = (TrustedProjectSettings)((Object)object2);
        ThreeState threeState = ThreeState.fromBoolean((boolean)value2);
        Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"ThreeState.fromBoolean(value)");
        trustedProjectSettings.setTrustedState(threeState);
        if (value2 && oldValue != ThreeState.YES) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            ((TrustChangeNotifier)application.getMessageBus().syncPublisher(TrustChangeNotifier.TOPIC)).projectTrusted($this$setTrusted);
        }
    }

    @NotNull
    public static final DialogWrapper.DoNotAskOption createDoNotAskOptionForLocation(@NotNull String projectLocationPath) {
        Intrinsics.checkNotNullParameter((Object)projectLocationPath, (String)"projectLocationPath");
        return (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(projectLocationPath){
            final /* synthetic */ String $projectLocationPath;

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected && exitCode == 0) {
                    TrustedProjectsStatistics.Companion.getTRUST_LOCATION_CHECKBOX_SELECTED().log();
                    boolean $i$f$service = false;
                    Class<TrustedPathsSettings> serviceClass$iv = TrustedPathsSettings.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    ((TrustedPathsSettings)((Object)object)).addTrustedPath(this.$projectLocationPath);
                }
            }

            @NotNull
            public String getDoNotShowMessage() {
                String path2 = FileUtil.getLocationRelativeToUserHome((String)this.$projectLocationPath, (boolean)false);
                String string = IdeBundle.message((String)"untrusted.project.warning.trust.location.checkbox", (Object[])new Object[]{path2});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"untru\u2026location.checkbox\", path)");
                return string;
            }
            {
                this.$projectLocationPath = $captured_local_variable$0;
            }
        };
    }

    public static final boolean isProjectImplicitlyTrusted(@Nullable Path projectDir) {
        return TrustedProjects.getImplicitTrustedCheckResult$default(projectDir, null, 2, null) instanceof TrustedCheckResult.Trusted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTrustedCheckDisabled() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) return true;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (application2.isHeadlessEnvironment()) return true;
        if (!SystemProperties.is((String)"idea.is.integration.test")) return false;
        return true;
    }

    private static final TrustedCheckResult getImplicitTrustedCheckResult(Project project) {
        Path path2;
        String string = project.getBasePath();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            path2 = Paths.get(it, new String[0]);
        } else {
            path2 = null;
        }
        return TrustedProjects.getImplicitTrustedCheckResult(path2, project);
    }

    private static final TrustedCheckResult getImplicitTrustedCheckResult(Path projectDir, Project project) {
        if (TrustedProjects.isTrustedCheckDisabled()) {
            return TrustedCheckResult.Trusted.INSTANCE;
        }
        if (projectDir != null) {
            boolean $i$f$service = false;
            Class<TrustedPathsSettings> serviceClass$iv = TrustedPathsSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            if (((TrustedPathsSettings)((Object)object)).isPathTrusted(projectDir)) {
                TrustedProjectsStatistics.Companion.getPROJECT_IMPLICITLY_TRUSTED_BY_PATH().log(project);
                return TrustedCheckResult.Trusted.INSTANCE;
            }
        }
        return new TrustedCheckResult.NotTrusted(null);
    }

    static /* synthetic */ TrustedCheckResult getImplicitTrustedCheckResult$default(Path path2, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        return TrustedProjects.getImplicitTrustedCheckResult(path2, project);
    }

    static {
        Logger logger = Logger.getInstance((String)"com.intellij.ide.impl.TrustedProjects");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"com.\u2026de.impl.TrustedProjects\")");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$isTrustedCheckDisabled() {
        return TrustedProjects.isTrustedCheckDisabled();
    }
}

