/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FavoritesPanel {
    private final Project myProject;
    private final FavoritesTreeViewPanel myViewPanel;
    private final DnDAwareTree myTree;
    private final Image myFavoritesImage;

    public FavoritesPanel(@NotNull Project project) {
        if (project == null) {
            FavoritesPanel.$$$reportNull$$$0(0);
        }
        this.myFavoritesImage = IconUtil.toImage(AllIcons.Toolwindows.ToolWindowFavorites);
        this.myProject = project;
        this.myViewPanel = new FavoritesTreeViewPanel(this.myProject);
        this.myTree = this.myViewPanel.getTree();
        FavoritesViewTreeBuilder treeBuilder = this.myViewPanel.getBuilder();
        if (treeBuilder != null) {
            Disposer.register((Disposable)this.myProject, (Disposable)treeBuilder);
        }
        this.setupDnD();
    }

    public FavoritesTreeViewPanel getPanel() {
        return this.myViewPanel;
    }

    private void setupDnD() {
        DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setBeanProvider(info2 -> {
            FavoriteTreeNodeDescriptor root;
            Object o;
            TreePath path2 = this.myTree.getPathForLocation(info2.getPoint().x, info2.getPoint().y);
            if (path2 != null && path2.getPathCount() == 3 && (o = path2.getLastPathComponent()) instanceof DefaultMutableTreeNode && (o = ((DefaultMutableTreeNode)o).getUserObject()) instanceof FavoriteTreeNodeDescriptor && (root = ((FavoriteTreeNodeDescriptor)((Object)((Object)o))).getFavoritesRoot()) != null && root != o && (o = root.getElement()) instanceof FavoritesListNode && ((FavoritesListNode)((Object)((Object)o))).getProvider() == null) {
                return new DnDDragStartBean((Object)path2);
            }
            if (path2 != null && path2.getPathCount() == 2 && (o = path2.getLastPathComponent()) instanceof DefaultMutableTreeNode && (o = ((DefaultMutableTreeNode)o).getUserObject()) instanceof FavoriteTreeNodeDescriptor && (root = ((FavoriteTreeNodeDescriptor)((Object)((Object)o))).getFavoritesRoot()) == o) {
                return new DnDDragStartBean((Object)path2);
            }
            return new DnDDragStartBean(""){

                public boolean isEmpty() {
                    return true;
                }
            };
        }).setTargetChecker(new DnDTargetChecker(){

            public boolean update(DnDEvent event) {
                Object obj2 = event.getAttachedObject();
                if ("".equals(obj2)) {
                    event.setDropPossible(false);
                    return false;
                }
                int pathCount = 0;
                if (obj2 instanceof TreePath && (pathCount = ((TreePath)obj2).getPathCount()) < 2) {
                    event.setDropPossible(false);
                    return true;
                }
                FavoritesListNode node2 = FavoritesPanel.this.myViewPanel.findFavoritesListNode(event.getPoint());
                if (obj2 instanceof TreePath && pathCount == 3 && FavoritesPanel.this.myViewPanel.myTree.getPath((PresentableNodeDescriptor)node2).isDescendant((TreePath)obj2) || node2 != null && node2.getProvider() != null) {
                    event.setDropPossible(false);
                    return false;
                }
                FavoritesPanel.this.highlight(node2, event);
                if (obj2 instanceof TreePath && pathCount == 2 && node2 != null && node2.getProvider() == null) {
                    event.setDropPossible(true);
                    return true;
                }
                if (node2 != null) {
                    event.setDropPossible(true);
                    return true;
                }
                event.setDropPossible(false);
                return false;
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                FavoritesListNode node2 = FavoritesPanel.this.myViewPanel.findFavoritesListNode(event.getPoint());
                FavoritesManager mgr = FavoritesManager.getInstance(FavoritesPanel.this.myProject);
                if (node2 == null) {
                    return;
                }
                String listTo = (String)node2.getValue();
                Object obj2 = event.getAttachedObject();
                if (obj2 instanceof TreePath) {
                    Rectangle bounds2;
                    TreePath path2 = (TreePath)obj2;
                    String listFrom = (String)FavoritesTreeViewPanel.getListNodeFromPath(path2).getValue();
                    if (listTo.equals(listFrom)) {
                        return;
                    }
                    if (path2.getPathCount() == 3) {
                        AbstractTreeNode abstractTreeNode = ((FavoriteTreeNodeDescriptor)((Object)((DefaultMutableTreeNode)path2.getLastPathComponent()).getUserObject())).getElement();
                        Object element2 = abstractTreeNode.getValue();
                        mgr.removeRoot(listFrom, Collections.singletonList(abstractTreeNode));
                        if (element2 instanceof SmartPsiElementPointer) {
                            element2 = ((SmartPsiElementPointer)element2).getElement();
                        }
                        mgr.addRoots(listTo, null, element2);
                    }
                    if (path2.getPathCount() == 2 && (bounds2 = FavoritesPanel.this.myTree.getPathBounds(FavoritesPanel.this.myTree.getPath((PresentableNodeDescriptor)node2))) != null) {
                        mgr.setOrder(listFrom, listTo, event.getPoint().y < bounds2.y + bounds2.height / 2);
                    }
                } else if (obj2 instanceof Transferable && ((Transferable)obj2).isDataFlavorSupported(DnDEventImpl.ourDataFlavor)) {
                    List elements = Collections.emptyList();
                    try {
                        Object data2 = ((Transferable)obj2).getTransferData(DnDEventImpl.ourDataFlavor);
                        if (data2 instanceof Object[]) {
                            elements = JBIterable.of((Object[])((Object[])data2)).filter(PsiElement.class).toList();
                        }
                    }
                    catch (UnsupportedFlavorException | IOException exception) {
                        // empty catch block
                    }
                    if (!elements.isEmpty()) {
                        FavoritesPanel.this.myViewPanel.dropPsiElements(mgr, node2, elements.toArray(PsiElement.EMPTY_ARRAY));
                    }
                } else if (obj2 instanceof TransferableWrapper) {
                    FavoritesPanel.this.myViewPanel.dropPsiElements(mgr, node2, ((TransferableWrapper)obj2).getPsiElements());
                } else if (obj2 instanceof DnDNativeTarget.EventInfo) {
                    FavoritesPanel.this.myViewPanel.dropPsiElements(mgr, node2, (PsiElement[])FavoritesPanel.this.getPsiFiles(FileCopyPasteUtil.getFileList(((DnDNativeTarget.EventInfo)obj2).getTransferable())));
                }
            }
        }).setImageProvider(info2 -> new DnDImage(this.myFavoritesImage, new Point(-this.myFavoritesImage.getWidth(null) / 2, -this.myFavoritesImage.getHeight(null) / 2))).enableAsNativeTarget().setDisposableParent((Disposable)this.myProject).install();
    }

    private void highlight(FavoritesListNode node2, DnDEvent event) {
        int pathCount = 0;
        Object object = event.getAttachedObject();
        if (object instanceof TreePath) {
            pathCount = ((TreePath)object).getPathCount();
        }
        if (node2 != null) {
            Rectangle bounds2;
            Object userObject;
            Object pathObj;
            TreePath pathToList;
            for (pathToList = this.myTree.getPath((PresentableNodeDescriptor)node2); !(pathToList == null || (pathObj = pathToList.getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)pathObj).getUserObject()) instanceof FavoriteTreeNodeDescriptor && ((FavoriteTreeNodeDescriptor)((Object)userObject)).getElement() == node2); pathToList = pathToList.getParentPath()) {
            }
            if (pathToList != null && (bounds2 = this.myTree.getPathBounds(pathToList)) != null) {
                if (pathCount == 2) {
                    boolean below;
                    FavoritesListNode pathToReorder = FavoritesTreeViewPanel.getListNodeFromPath((TreePath)object);
                    FavoritesListNode anchorPath = FavoritesTreeViewPanel.getListNodeFromPath(pathToList);
                    boolean bl = below = event.getPoint().y >= bounds2.y + bounds2.height / 2;
                    if (pathToReorder == null || anchorPath == null || !FavoritesManager.getInstance(this.myProject).canReorder((String)pathToReorder.getValue(), (String)anchorPath.getValue(), !below)) {
                        event.hideHighlighter();
                        return;
                    }
                    if (below) {
                        bounds2.y += bounds2.height - 2;
                    }
                    bounds2.height = 2;
                }
                event.setHighlighting(new RelativeRectangle((Component)((Object)this.myTree), bounds2), 1);
            }
        } else {
            event.hideHighlighter();
        }
    }

    private PsiFileSystemItem @Nullable [] getPsiFiles(@Nullable List<? extends File> fileList) {
        if (fileList == null) {
            return null;
        }
        ArrayList<PsiFileSystemItem> sourceFiles = new ArrayList<PsiFileSystemItem>();
        for (File file2 : fileList) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            PsiFileSystemItem psiFile = PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)vFile);
            if (psiFile == null) continue;
            sourceFiles.add(psiFile);
        }
        return sourceFiles.toArray(new PsiFileSystemItem[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/FavoritesPanel", "<init>"));
    }
}

