/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.util.BitUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001f\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001e\"\u00020\n\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ide/actions/SwitcherKeyReleaseListener;", "Ljava/awt/event/KeyAdapter;", "event", "Ljava/awt/event/InputEvent;", "consumer", "Ljava/util/function/Consumer;", "(Ljava/awt/event/InputEvent;Ljava/util/function/Consumer;)V", "getConsumer", "()Ljava/util/function/Consumer;", "forbiddenMnemonic", "", "getForbiddenMnemonic", "()Ljava/lang/String;", "initialModifiers", "getInitialModifiers", "isEnabled", "", "()Z", "wasAltDown", "wasAltGraphDown", "wasControlDown", "wasMetaDown", "keyStroke", "Ljavax/swing/KeyStroke;", "getMnemonic", "keyCode", "", "getShortcuts", "Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "keys", "", "([Ljava/lang/String;)Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "keyReleased", "", "keyEvent", "Ljava/awt/event/KeyEvent;", "intellij.platform.ide.impl"})
public final class SwitcherKeyReleaseListener
extends KeyAdapter {
    private final boolean wasAltDown;
    private final boolean wasAltGraphDown;
    private final boolean wasControlDown;
    private final boolean wasMetaDown;
    private final boolean isEnabled;
    @Nullable
    private final String initialModifiers;
    @Nullable
    private final String forbiddenMnemonic;
    @NotNull
    private final Consumer<InputEvent> consumer;

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    @Nullable
    public final String getInitialModifiers() {
        return this.initialModifiers;
    }

    @Nullable
    public final String getForbiddenMnemonic() {
        return this.forbiddenMnemonic;
    }

    @Nullable
    public final String getForbiddenMnemonic(@NotNull KeyStroke keyStroke) {
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        return BitUtil.isSet((int)keyStroke.getModifiers(), (int)512) != this.wasAltDown ? null : (BitUtil.isSet((int)keyStroke.getModifiers(), (int)8192) != this.wasAltGraphDown ? null : (BitUtil.isSet((int)keyStroke.getModifiers(), (int)128) != this.wasControlDown ? null : (BitUtil.isSet((int)keyStroke.getModifiers(), (int)256) != this.wasMetaDown ? null : this.getMnemonic(keyStroke.getKeyCode()))));
    }

    private final String getMnemonic(int keyCode) {
        int n = keyCode;
        int n2 = n;
        return 48 <= n2 && 57 >= n2 ? String.valueOf((char)keyCode) : (65 <= (n2 = n) && 90 >= n2 ? String.valueOf((char)keyCode) : null);
    }

    @NotNull
    public final CustomShortcutSet getShortcuts(String ... keys2) {
        String string;
        String it;
        Collection collection;
        String item$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)keys2, (String)"keys");
        String string2 = this.initialModifiers;
        if (string2 == null) {
            CustomShortcutSet customShortcutSet = CustomShortcutSet.fromString((String[])Arrays.copyOf(keys2, keys2.length));
            Intrinsics.checkNotNullExpressionValue((Object)customShortcutSet, (String)"CustomShortcutSet.fromString(*keys)");
            return customShortcutSet;
        }
        String modifiers = string2;
        boolean bl = false;
        List list2 = new ArrayList();
        String[] $this$mapTo$iv = keys2;
        boolean $i$f$mapTo = false;
        String[] stringArray = $this$mapTo$iv;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string3 = item$iv = stringArray[n];
            collection = list2;
            boolean bl2 = false;
            string = modifiers + it;
            collection.add(string);
        }
        $this$mapTo$iv = keys2;
        $i$f$mapTo = false;
        stringArray = $this$mapTo$iv;
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv = stringArray[n];
            collection = list2;
            boolean bl3 = false;
            string = modifiers + "shift " + it;
            collection.add(string);
        }
        CustomShortcutSet customShortcutSet = CustomShortcutSet.fromStrings((Collection)list2);
        Intrinsics.checkNotNullExpressionValue((Object)customShortcutSet, (String)"CustomShortcutSet.fromStrings(list)");
        return customShortcutSet;
    }

    @Override
    public void keyReleased(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        switch (keyEvent.getKeyCode()) {
            case 18: {
                if (!this.wasAltDown) break;
                this.consumer.accept(keyEvent);
                break;
            }
            case 65406: {
                if (!this.wasAltGraphDown) break;
                this.consumer.accept(keyEvent);
                break;
            }
            case 17: {
                if (!this.wasControlDown) break;
                this.consumer.accept(keyEvent);
                break;
            }
            case 157: {
                if (!this.wasMetaDown) break;
                this.consumer.accept(keyEvent);
                break;
            }
        }
    }

    @NotNull
    public final Consumer<InputEvent> getConsumer() {
        return this.consumer;
    }

    /*
     * WARNING - void declaration
     */
    public SwitcherKeyReleaseListener(@Nullable InputEvent event, @NotNull Consumer<InputEvent> consumer) {
        String string;
        String string2;
        SwitcherKeyReleaseListener switcherKeyReleaseListener;
        boolean bl;
        boolean bl2;
        String string3;
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.consumer = consumer;
        InputEvent inputEvent = event;
        this.wasAltDown = inputEvent != null && true == inputEvent.isAltDown();
        InputEvent inputEvent2 = event;
        this.wasAltGraphDown = inputEvent2 != null && true == inputEvent2.isAltGraphDown();
        InputEvent inputEvent3 = event;
        this.wasControlDown = inputEvent3 != null && true == inputEvent3.isControlDown();
        InputEvent inputEvent4 = event;
        this.wasMetaDown = inputEvent4 != null && true == inputEvent4.isMetaDown();
        this.isEnabled = this.wasAltDown || this.wasAltGraphDown || this.wasControlDown || this.wasMetaDown;
        SwitcherKeyReleaseListener switcherKeyReleaseListener2 = this;
        if (!this.isEnabled) {
            string3 = null;
        } else {
            void $this$apply;
            StringBuilder stringBuilder = new StringBuilder();
            bl2 = false;
            bl = false;
            StringBuilder stringBuilder2 = stringBuilder;
            switcherKeyReleaseListener = switcherKeyReleaseListener2;
            boolean bl3 = false;
            if (this.wasAltDown) {
                $this$apply.append("alt ");
            }
            if (this.wasAltGraphDown) {
                $this$apply.append("altGraph ");
            }
            if (this.wasControlDown) {
                $this$apply.append("control ");
            }
            if (this.wasMetaDown) {
                $this$apply.append("meta ");
            }
            string2 = Unit.INSTANCE;
            switcherKeyReleaseListener2 = switcherKeyReleaseListener;
            string3 = stringBuilder.toString();
        }
        switcherKeyReleaseListener2.initialModifiers = string3;
        SwitcherKeyReleaseListener switcherKeyReleaseListener3 = this;
        InputEvent inputEvent5 = event;
        if (!(inputEvent5 instanceof KeyEvent)) {
            inputEvent5 = null;
        }
        KeyEvent keyEvent = (KeyEvent)inputEvent5;
        if (keyEvent != null) {
            void it;
            int n = keyEvent.getKeyCode();
            bl2 = false;
            bl = false;
            int $this$apply = n;
            switcherKeyReleaseListener = switcherKeyReleaseListener3;
            boolean bl4 = false;
            string2 = this.getMnemonic((int)it);
            switcherKeyReleaseListener3 = switcherKeyReleaseListener;
            string = string2;
        } else {
            string = null;
        }
        switcherKeyReleaseListener3.forbiddenMnemonic = string;
    }
}

