/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShowContentAction
extends AnAction
implements DumbAware {
    @NonNls
    public static final String ACTION_ID = "ShowContent";
    private ToolWindow myWindow;

    public ShowContentAction() {
    }

    public ShowContentAction(@NotNull ToolWindow window, JComponent c, @NotNull Disposable parentDisposable) {
        if (window == null) {
            ShowContentAction.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ShowContentAction.$$$reportNull$$$0(1);
        }
        this.myWindow = window;
        AnAction original = ActionManager.getInstance().getAction(ACTION_ID);
        new ShadowAction((AnAction)this, original, c, parentDisposable);
        ActionUtil.copyFrom((AnAction)this, (String)ACTION_ID);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowContentAction.$$$reportNull$$$0(2);
        }
        ToolWindow window = this.getWindow(e);
        e.getPresentation().setEnabledAndVisible(window != null && window.getContentManager().getContentCount() > 1);
        e.getPresentation().setText(window == null || window.getContentUiType() == ToolWindowContentUiType.TABBED ? ActionsBundle.message((String)"action.ShowContent.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.ShowContent.views.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ToolWindow toolWindow;
        if (e == null) {
            ShowContentAction.$$$reportNull$$$0(3);
        }
        if ((toolWindow = this.getWindow(e)) != null) {
            toolWindow.showContentPopup(e.getInputEvent());
        }
    }

    @Nullable
    private ToolWindow getWindow(@NotNull AnActionEvent event) {
        ToolWindow window;
        if (event == null) {
            ShowContentAction.$$$reportNull$$$0(4);
        }
        if (this.myWindow != null) {
            return this.myWindow;
        }
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Component context2 = (Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (context2 == null) {
            return null;
        }
        ToolWindowManager manager2 = ToolWindowManager.getInstance((Project)project);
        String toolWindowId = manager2.getActiveToolWindowId();
        ToolWindow toolWindow = window = toolWindowId == null ? null : manager2.getToolWindow(toolWindowId);
        if (window == null) {
            return null;
        }
        return SwingUtilities.isDescendingFrom(window.getComponent(), context2) ? window : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/ShowContentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getWindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

