/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.InvalidateCachesDialog;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class InvalidateCachesAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(InvalidateCachesAction.class);

    InvalidateCachesAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InvalidateCachesAction.$$$reportNull$$$0(0);
        }
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        boolean canRestart = app.isRestartCapable();
        InvalidateCachesDialog dialog2 = new InvalidateCachesDialog((Project)e.getData(CommonDataKeys.PROJECT), canRestart, CachesInvalidator.EP_NAME.getExtensionList());
        dialog2.show();
        List<CachesInvalidator> invalidators = dialog2.getSelectedInvalidators();
        if (dialog2.isOK()) {
            for (CachesInvalidator invalidator : invalidators) {
                try {
                    invalidator.invalidateCaches();
                }
                catch (Throwable t) {
                    LOG.warn("Failed to invalidate caches with " + invalidator.getClass().getName() + ". " + t.getMessage(), t);
                }
            }
        }
        if (dialog2.isOK() || dialog2.isRestartOnly()) {
            app.restart(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/InvalidateCachesAction", "actionPerformed"));
    }
}

