/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionMacro;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actionMacro.ActionMacro;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionMacroManager", storages={@Storage(value="macros.xml")})
public final class ActionMacroManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ActionMacroManager.class);
    private static final String TYPING_SAMPLE = "WWWWWWWWWWWWWWWWWWWW";
    public static final String NO_NAME_NAME = "<noname>";
    private boolean myIsRecording;
    private ActionMacro myLastMacro;
    private ActionMacro myRecordingMacro;
    private ArrayList<ActionMacro> myMacros = new ArrayList();
    private String myLastMacroName = null;
    private boolean myIsPlaying = false;
    @NonNls
    private static final String ELEMENT_MACRO = "macro";
    private final IdeEventQueue.EventDispatcher myKeyProcessor;
    private final Set<InputEvent> myLastActionInputEvent = new HashSet<InputEvent>();
    private Widget myWidget;
    private String myLastTyping = "";

    ActionMacroManager() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                String id2;
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((id2 = ActionManager.getInstance().getId(action2)) == null) {
                    return;
                }
                if ("StartStopMacroRecording".equals(id2)) {
                    ActionMacroManager.this.myLastActionInputEvent.add(event.getInputEvent());
                } else if (ActionMacroManager.this.myIsRecording) {
                    ActionMacroManager.this.myRecordingMacro.appendAction(id2);
                    String shortcut = null;
                    if (event.getInputEvent() instanceof KeyEvent) {
                        shortcut = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStrokeForEvent((KeyEvent)event.getInputEvent()));
                    }
                    ActionMacroManager.this.notifyUser(id2 + (String)(shortcut != null ? " (" + shortcut + ")" : ""), false);
                    ActionMacroManager.this.myLastActionInputEvent.add(event.getInputEvent());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actionMacro/ActionMacroManager$1";
                objectArray[2] = "beforeActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myKeyProcessor = new MyKeyPostpocessor();
        IdeEventQueue.getInstance().addPostprocessor(this.myKeyProcessor, null);
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ActionMacroManager.$$$reportNull$$$0(0);
        }
        this.myMacros = new ArrayList();
        for (Element macroElement : state.getChildren(ELEMENT_MACRO)) {
            ActionMacro macro = new ActionMacro();
            macro.readExternal(macroElement);
            this.myMacros.add(macro);
        }
        this.registerActions(ActionManager.getInstance());
    }

    @NotNull
    public Element getState() {
        Element element2 = new Element("state");
        for (ActionMacro macro : this.myMacros) {
            Element macroElement = new Element(ELEMENT_MACRO);
            macro.writeExternal(macroElement);
            element2.addContent(macroElement);
        }
        Element element3 = element2;
        if (element3 == null) {
            ActionMacroManager.$$$reportNull$$$0(1);
        }
        return element3;
    }

    public static ActionMacroManager getInstance() {
        return (ActionMacroManager)ApplicationManager.getApplication().getService(ActionMacroManager.class);
    }

    public void startRecording(String macroName) {
        LOG.assertTrue(!this.myIsRecording);
        this.myIsRecording = true;
        this.myRecordingMacro = new ActionMacro(macroName);
        StatusBar statusBar2 = WindowManager.getInstance().getIdeFrame(null).getStatusBar();
        this.myWidget = new Widget(statusBar2);
        statusBar2.addWidget((StatusBarWidget)this.myWidget);
    }

    public void stopRecording(@Nullable Project project) {
        String macroName;
        LOG.assertTrue(this.myIsRecording);
        if (this.myWidget != null) {
            this.myWidget.delete();
            this.myWidget = null;
        }
        this.myIsRecording = false;
        this.myLastActionInputEvent.clear();
        do {
            if ((macroName = Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.macro.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.enter.macro.name", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == null) {
                this.myRecordingMacro = null;
                return;
            }
            if (!macroName.isEmpty()) continue;
            macroName = null;
        } while (macroName != null && !this.checkCanCreateMacro(macroName));
        this.myLastMacro = this.myRecordingMacro;
        this.addRecordedMacroWithName(macroName);
        this.registerActions(ActionManager.getInstance());
    }

    private void addRecordedMacroWithName(@Nullable String macroName) {
        if (macroName != null) {
            this.myRecordingMacro.setName(macroName);
            this.myMacros.add(this.myRecordingMacro);
            this.myRecordingMacro = null;
        } else {
            for (int i2 = 0; i2 < this.myMacros.size(); ++i2) {
                ActionMacro macro = this.myMacros.get(i2);
                if (!NO_NAME_NAME.equals(macro.getName())) continue;
                this.myMacros.set(i2, this.myRecordingMacro);
                this.myRecordingMacro = null;
                break;
            }
            if (this.myRecordingMacro != null) {
                this.myMacros.add(this.myRecordingMacro);
                this.myRecordingMacro = null;
            }
        }
    }

    public void playbackLastMacro() {
        if (this.myLastMacro != null) {
            this.playbackMacro(this.myLastMacro);
        }
    }

    private void playbackMacro(ActionMacro macro) {
        ActionMacro.ActionDescriptor[] actions2;
        final IdeFrame frame = WindowManager.getInstance().getIdeFrame(null);
        assert (frame != null);
        StringBuffer script = new StringBuffer();
        for (ActionMacro.ActionDescriptor each : actions2 = macro.getActions()) {
            each.generateTo(script);
        }
        PlaybackRunner runner = new PlaybackRunner(script.toString(), new PlaybackRunner.StatusCallback.Edt(){

            @Override
            public void messageEdt(PlaybackContext context2, @NlsContexts.StatusBarText String text2, PlaybackRunner.StatusCallback.Type type) {
                StatusBar statusBar2;
                if ((type == PlaybackRunner.StatusCallback.Type.message || type == PlaybackRunner.StatusCallback.Type.error) && (statusBar2 = frame.getStatusBar()) != null) {
                    if (context2 != null) {
                        text2 = IdeBundle.message((String)"status.bar.message.at.line", (Object[])new Object[]{context2.getCurrentLine(), text2});
                    }
                    statusBar2.setInfo(text2);
                }
            }
        }, Registry.is((String)"actionSystem.playback.useDirectActionCall"), true, Registry.is((String)"actionSystem.playback.useTypingTargets"));
        this.myIsPlaying = true;
        runner.run().doWhenDone(() -> {
            StatusBar statusBar2 = frame.getStatusBar();
            statusBar2.setInfo(IdeBundle.message((String)"status.bar.text.script.execution.finished", (Object[])new Object[0]));
        }).doWhenProcessed(() -> {
            this.myIsPlaying = false;
        });
    }

    public boolean isRecording() {
        return this.myIsRecording;
    }

    public void dispose() {
        IdeEventQueue.getInstance().removePostprocessor(this.myKeyProcessor);
    }

    public ActionMacro[] getAllMacros() {
        return this.myMacros.toArray(new ActionMacro[0]);
    }

    public void removeAllMacros() {
        if (this.myLastMacro != null) {
            this.myLastMacroName = this.myLastMacro.getName();
            this.myLastMacro = null;
        }
        this.myMacros = new ArrayList();
    }

    public void addMacro(ActionMacro macro) {
        this.myMacros.add(macro);
        if (this.myLastMacroName != null && this.myLastMacroName.equals(macro.getName())) {
            this.myLastMacro = macro;
            this.myLastMacroName = null;
        }
    }

    public void playMacro(ActionMacro macro) {
        this.playbackMacro(macro);
        this.myLastMacro = macro;
    }

    public boolean hasRecentMacro() {
        return this.myLastMacro != null;
    }

    public void registerActions(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            ActionMacroManager.$$$reportNull$$$0(2);
        }
        for (String oldId : actionManager.getActionIdList("Macro.")) {
            actionManager.unregisterAction(oldId);
        }
        HashSet<String> registeredIds = new HashSet<String>();
        for (ActionMacro macro : this.getAllMacros()) {
            String actionId = macro.getActionId();
            if (registeredIds.contains(actionId)) continue;
            registeredIds.add(actionId);
            actionManager.registerAction(actionId, (AnAction)new InvokeMacroAction(macro));
        }
    }

    public boolean checkCanCreateMacro(String name) {
        String actionId;
        ActionManagerEx actionManager = (ActionManagerEx)ActionManager.getInstance();
        if (actionManager.getAction(actionId = "Macro." + name) != null) {
            if (!((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"title.macro.name.already.used", (Object[])new Object[0]), (String)IdeBundle.message((String)"message.macro.exists", (Object[])new Object[]{name})).icon(Messages.getWarningIcon())).ask((Component)this.myWidget.getComponent())) {
                return false;
            }
            actionManager.unregisterAction(actionId);
            this.removeMacro(name);
        }
        return true;
    }

    private void removeMacro(String name) {
        for (int i2 = 0; i2 < this.myMacros.size(); ++i2) {
            ActionMacro macro = this.myMacros.get(i2);
            if (!name.equals(macro.getName())) continue;
            this.myMacros.remove(i2);
            break;
        }
    }

    public boolean isPlaying() {
        return this.myIsPlaying;
    }

    private void notifyUser(String text2, boolean typing) {
        String actualText = text2;
        if (typing) {
            int maxLength = TYPING_SAMPLE.length();
            this.myLastTyping = this.myLastTyping + text2;
            if (this.myLastTyping.length() > maxLength) {
                this.myLastTyping = "..." + this.myLastTyping.substring(this.myLastTyping.length() - maxLength);
            }
            actualText = this.myLastTyping;
        } else {
            this.myLastTyping = "";
        }
        if (this.myWidget != null) {
            this.myWidget.notifyUser(IdeBundle.message((String)"status.bar.text.macro.recorded", (Object[])new Object[]{actualText}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actionMacro/ActionMacroManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actionMacro/ActionMacroManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyKeyPostpocessor
    implements IdeEventQueue.EventDispatcher {
        private MyKeyPostpocessor() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                MyKeyPostpocessor.$$$reportNull$$$0(0);
            }
            if (ActionMacroManager.this.isRecording() && e instanceof KeyEvent) {
                this.postProcessKeyEvent((KeyEvent)e);
            }
            return false;
        }

        public void postProcessKeyEvent(KeyEvent e) {
            boolean isEnter;
            boolean modifierKeyIsPressed;
            if (e.getID() != 401) {
                return;
            }
            if (ActionMacroManager.this.myLastActionInputEvent.contains(e)) {
                ActionMacroManager.this.myLastActionInputEvent.remove(e);
                return;
            }
            boolean bl = modifierKeyIsPressed = e.getKeyCode() == 17 || e.getKeyCode() == 18 || e.getKeyCode() == 157 || e.getKeyCode() == 16;
            if (modifierKeyIsPressed) {
                return;
            }
            boolean ready = IdeEventQueue.getInstance().getKeyEventDispatcher().isReady();
            boolean isChar = UIUtil.isReallyTypedEvent((KeyEvent)e);
            boolean hasActionModifiers = e.isAltDown() || e.isControlDown() || e.isMetaDown();
            boolean plainType = isChar && !hasActionModifiers;
            boolean bl2 = isEnter = e.getKeyCode() == 10;
            if (plainType && ready && !isEnter) {
                ActionMacroManager.this.myRecordingMacro.appendKeytyped(e.getKeyChar(), e.getKeyCode(), e.getModifiers());
                ActionMacroManager.this.notifyUser(Character.valueOf(e.getKeyChar()).toString(), true);
            } else if (!plainType && ready || isEnter) {
                String stroke = KeyStroke.getKeyStrokeForEvent(e).toString();
                int pressed = stroke.indexOf("pressed");
                String key = stroke.substring(pressed + "pressed".length());
                String modifiers = stroke.substring(0, pressed);
                String shortcut = (modifiers.replaceAll("ctrl", "control").trim() + " " + key.trim()).trim();
                ActionMacroManager.this.myRecordingMacro.appendShortcut(shortcut);
                ActionMacroManager.this.notifyUser(KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStrokeForEvent(e)), false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actionMacro/ActionMacroManager$MyKeyPostpocessor", "dispatch"));
        }
    }

    private static class InvokeMacroAction
    extends AnAction {
        private final ActionMacro myMacro;

        InvokeMacroAction(ActionMacro macro) {
            this.myMacro = macro;
            this.getTemplatePresentation().setText(macro.getName(), false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                InvokeMacroAction.$$$reportNull$$$0(0);
            }
            IdeEventQueue.getInstance().doWhenReady(() -> ActionMacroManager.getInstance().playMacro(this.myMacro));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                InvokeMacroAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(!ActionMacroManager.getInstance().isPlaying());
        }

        @NlsActions.ActionText
        @Nullable
        public String getTemplateText() {
            return IdeBundle.message((String)"action.invoke.macro.text", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actionMacro/ActionMacroManager$InvokeMacroAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class Widget
    implements CustomStatusBarWidget,
    Consumer<MouseEvent> {
        private final AnimatedIcon myIcon = new AnimatedIcon("Macro recording", AnimatedIcon.Recording.ICONS.toArray(new Icon[0]), AllIcons.Ide.Macro.Recording_1, 250 * AnimatedIcon.Recording.ICONS.size());
        private final StatusBar myStatusBar;
        private final StatusBarWidget.WidgetPresentation myPresentation;
        private final JPanel myBalloonComponent;
        private Balloon myBalloon;
        private final JLabel myText;

        private Widget(StatusBar statusBar2) {
            this.myStatusBar = statusBar2;
            this.myIcon.setBorder(StatusBarWidget.WidgetBorder.ICON);
            this.myPresentation = new StatusBarWidget.WidgetPresentation(){

                public String getTooltipText() {
                    return IdeBundle.message((String)"tooltip.macro.is.being.recorded.now", (Object[])new Object[0]);
                }

                public Consumer<MouseEvent> getClickConsumer() {
                    return Widget.this;
                }
            };
            new BaseButtonBehavior((JComponent)this.myIcon){

                protected void execute(MouseEvent e) {
                    Widget.this.showBalloon();
                }
            };
            this.myBalloonComponent = new NonOpaquePanel((LayoutManager)new BorderLayout());
            AnAction stopAction = ActionManager.getInstance().getAction("StartStopMacroRecording");
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add(stopAction);
            ActionToolbar tb = ActionManager.getInstance().createActionToolbar("StatusBarPlace", (ActionGroup)group2, true);
            tb.setMiniMode(true);
            NonOpaquePanel top = new NonOpaquePanel((LayoutManager)new BorderLayout());
            top.add((Component)tb.getComponent(), (Object)"West");
            this.myText = new JLabel(IdeBundle.message((String)"status.bar.text.macro.recorded", (Object[])new Object[]{"...WWWWWWWWWWWWWWWWWWWW"}), 2);
            Dimension preferredSize = this.myText.getPreferredSize();
            this.myText.setPreferredSize(preferredSize);
            this.myText.setText(IdeBundle.message((String)"label.macro.recording.started", (Object[])new Object[0]));
            ActionMacroManager.this.myLastTyping = "";
            top.add((Component)this.myText, (Object)"Center");
            this.myBalloonComponent.add((Component)top, "Center");
        }

        private void showBalloon() {
            if (this.myBalloon != null) {
                Disposer.dispose((Disposable)this.myBalloon);
                return;
            }
            this.myBalloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)this.myBalloonComponent).setAnimationCycle(200).setCloseButtonEnabled(true).setHideOnAction(false).setHideOnClickOutside(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setSmallVariant(true).setShadow(true).createBalloon();
            Disposer.register((Disposable)this.myBalloon, (Disposable)new Disposable(){

                public void dispose() {
                    Widget.this.myBalloon = null;
                }
            });
            this.myBalloon.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (Widget.this.myBalloon != null) {
                        Disposer.dispose((Disposable)Widget.this.myBalloon);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actionMacro/ActionMacroManager$Widget$4", "onClosed"));
                }
            });
            this.myBalloon.show((PositionTracker)new PositionTracker<Balloon>((Component)this.myIcon){

                public RelativePoint recalculateLocation(@NotNull Balloon object) {
                    if (object == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return new RelativePoint((Component)Widget.this.myIcon, new Point(Widget.this.myIcon.getSize().width / 2, 4));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/ide/actionMacro/ActionMacroManager$Widget$5", "recalculateLocation"));
                }
            }, Balloon.Position.above);
        }

        public JComponent getComponent() {
            return this.myIcon;
        }

        @NotNull
        public String ID() {
            return "MacroRecording";
        }

        public void consume(MouseEvent mouseEvent) {
        }

        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this.myPresentation;
        }

        public void install(@NotNull StatusBar statusBar2) {
            if (statusBar2 == null) {
                Widget.$$$reportNull$$$0(0);
            }
            this.showBalloon();
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myIcon);
            if (this.myBalloon != null) {
                Disposer.dispose((Disposable)this.myBalloon);
            }
        }

        public void delete() {
            if (this.myBalloon != null) {
                Disposer.dispose((Disposable)this.myBalloon);
            }
            this.myStatusBar.removeWidget(this.ID());
        }

        public void notifyUser(@Nls String text2) {
            this.myText.setText(text2);
            this.myText.revalidate();
            this.myText.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/ide/actionMacro/ActionMacroManager$Widget", "install"));
        }
    }

    static final class MyActionTuner
    implements ActionConfigurationCustomizer {
        MyActionTuner() {
        }

        @Override
        public void customize(@NotNull ActionManager actionManager) {
            if (actionManager == null) {
                MyActionTuner.$$$reportNull$$$0(0);
            }
            NonUrgentExecutor.getInstance().execute(() -> ActionMacroManager.getInstance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/ide/actionMacro/ActionMacroManager$MyActionTuner", "customize"));
        }
    }
}

