/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyPasteDelegator
implements CopyPasteSupport {
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.filePasteProvider");
    public static final Key<Boolean> SHOW_CHOOSER_KEY = Key.create((String)"show.dirs.chooser");
    private final Project myProject;
    private final JComponent myKeyReceiver;
    private final MyEditable myEditable;

    public CopyPasteDelegator(@NotNull Project project, @NotNull JComponent keyReceiver) {
        if (project == null) {
            CopyPasteDelegator.$$$reportNull$$$0(0);
        }
        if (keyReceiver == null) {
            CopyPasteDelegator.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myKeyReceiver = keyReceiver;
        this.myEditable = new MyEditable();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected PsiElement @NotNull [] getSelectedElements() {
        if (PsiElement.EMPTY_ARRAY == null) {
            CopyPasteDelegator.$$$reportNull$$$0(2);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    protected PsiElement @NotNull [] getSelectedElements(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CopyPasteDelegator.$$$reportNull$$$0(3);
        }
        PsiElement[] psiElementArray = (PsiElement[])ObjectUtils.notNull((Object)((PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)), (Object)this.getSelectedElements());
        if (psiElementArray == null) {
            CopyPasteDelegator.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    private static PsiElement @NotNull [] validate(PsiElement @Nullable [] selectedElements) {
        if (selectedElements == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CopyPasteDelegator.$$$reportNull$$$0(5);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        for (PsiElement element2 : selectedElements) {
            if (element2 != null && element2.isValid()) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                CopyPasteDelegator.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (selectedElements == null) {
            CopyPasteDelegator.$$$reportNull$$$0(7);
        }
        return selectedElements;
    }

    private void updateView() {
        this.myKeyReceiver.repaint();
    }

    public CopyProvider getCopyProvider() {
        return this.myEditable;
    }

    public CutProvider getCutProvider() {
        return this.myEditable;
    }

    public PasteProvider getPasteProvider() {
        return this.myEditable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyReceiver";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CopyPasteDelegator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CopyPasteDelegator";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider {
        MyEditable() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(0);
            }
            PsiElement[] elements = CopyPasteDelegator.validate(CopyPasteDelegator.this.getSelectedElements(dataContext));
            PsiCopyPasteManager.getInstance().setElements(elements, true);
            CopyPasteDelegator.this.updateView();
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            Object[] elements;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(1);
            }
            return CopyHandler.canCopy((PsiElement[])(elements = CopyPasteDelegator.validate(CopyPasteDelegator.this.getSelectedElements(dataContext)))) || JBIterable.of((Object[])elements).filter(Conditions.instanceOf(PsiNamedElement.class)).isNotEmpty();
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void performCut(@NotNull DataContext dataContext) {
            PsiElement[] elements;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(3);
            }
            if (MoveHandler.adjustForMove(CopyPasteDelegator.this.myProject, elements = CopyPasteDelegator.validate(CopyPasteDelegator.this.getSelectedElements(dataContext)), null) == null) {
                return;
            }
            PsiCopyPasteManager.getInstance().setElements(elements, false);
            CopyPasteDelegator.this.updateView();
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            PsiElement[] elements;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(4);
            }
            return (elements = CopyPasteDelegator.validate(CopyPasteDelegator.this.getSelectedElements(dataContext))).length != 0 && MoveHandler.canMove(elements, null);
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(5);
            }
            return true;
        }

        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(6);
            }
            if (!this.performDefaultPaste(dataContext)) {
                for (PasteProvider provider2 : EP_NAME.getExtensionList()) {
                    if (!provider2.isPasteEnabled(dataContext)) continue;
                    provider2.performPaste(dataContext);
                    break;
                }
            }
        }

        boolean performDefaultPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(7);
            }
            boolean[] isCopied = new boolean[1];
            PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(isCopied);
            if (elements == null) {
                return false;
            }
            return (Boolean)DumbService.getInstance((Project)CopyPasteDelegator.this.myProject).computeWithAlternativeResolveEnabled(() -> {
                block5: {
                    try {
                        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
                        PsiElement target2 = this.getPasteTarget(dataContext, module);
                        if (isCopied[0]) {
                            this.pasteAfterCopy(elements, module, target2, true);
                            break block5;
                        }
                        if (MoveHandler.canMove(elements, target2)) {
                            this.pasteAfterCut(dataContext, elements, target2);
                            break block5;
                        }
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        CopyPasteDelegator.this.updateView();
                    }
                }
                return true;
            });
        }

        private PsiElement getPasteTarget(@NotNull DataContext dataContext, @Nullable Module module) {
            PsiDirectory[] directories;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(8);
            }
            PsiElement target2 = (PsiElement)LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
            if (module != null && target2 instanceof PsiDirectoryContainer && (directories = ((PsiDirectoryContainer)target2).getDirectories(GlobalSearchScope.moduleScope((Module)module))).length == 1) {
                return directories[0];
            }
            return target2;
        }

        @Nullable
        private PsiDirectory getTargetDirectory(@Nullable Module module, @Nullable PsiElement target2) {
            PsiFile containingFile;
            PsiDirectory targetDirectory;
            PsiDirectory psiDirectory = targetDirectory = target2 instanceof PsiDirectory ? (PsiDirectory)target2 : null;
            if (targetDirectory == null && target2 instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                PsiDirectory[] psiDirectoryArray = directories = module == null ? ((PsiDirectoryContainer)target2).getDirectories() : ((PsiDirectoryContainer)target2).getDirectories(GlobalSearchScope.moduleScope((Module)module));
                if (directories.length > 0) {
                    targetDirectory = directories[0];
                    targetDirectory.putCopyableUserData(SHOW_CHOOSER_KEY, (Object)(directories.length > 1 ? 1 : 0));
                }
            }
            if (targetDirectory == null && target2 != null && (containingFile = target2.getContainingFile()) != null) {
                targetDirectory = containingFile.getContainingDirectory();
            }
            return targetDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pasteAfterCopy(PsiElement[] elements, Module module, PsiElement target2, boolean tryFromFiles) {
            PsiDirectory targetDirectory = elements.length == 1 && elements[0] == target2 ? null : this.getTargetDirectory(module, target2);
            try {
                List<File> files2;
                if (CopyHandler.canCopy(elements)) {
                    CopyHandler.doCopy(elements, targetDirectory);
                } else if (tryFromFiles && (files2 = PsiCopyPasteManager.asFileList(elements)) != null) {
                    PsiManager manager2 = elements[0].getManager();
                    PsiFileSystemItem[] items = (PsiFileSystemItem[])files2.stream().map(file2 -> LocalFileSystem.getInstance().findFileByIoFile(file2)).map(file2 -> {
                        if (file2 != null) {
                            return file2.isDirectory() ? manager2.findDirectory(file2) : manager2.findFile(file2);
                        }
                        return null;
                    }).filter(file2 -> file2 != null).toArray(PsiFileSystemItem[]::new);
                    this.pasteAfterCopy((PsiElement[])items, module, target2, false);
                }
            }
            finally {
                if (targetDirectory != null) {
                    targetDirectory.putCopyableUserData(SHOW_CHOOSER_KEY, null);
                }
            }
        }

        private void pasteAfterCut(DataContext dataContext, PsiElement[] elements, PsiElement target2) {
            MoveHandler.doMove(CopyPasteDelegator.this.myProject, elements, target2, dataContext, new MoveCallback(){

                @Override
                public void refactoringCompleted() {
                    PsiCopyPasteManager.getInstance().clear();
                }
            });
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(9);
            }
            return true;
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(10);
            }
            if (this.isDefaultPasteEnabled(dataContext)) {
                return true;
            }
            for (PasteProvider provider2 : EP_NAME.getExtensionList()) {
                if (!provider2.isPasteEnabled(dataContext)) continue;
                return true;
            }
            return false;
        }

        private boolean isDefaultPasteEnabled(DataContext dataContext) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            if (DumbService.isDumb((Project)project)) {
                return false;
            }
            Object target2 = LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
            if (target2 == null) {
                return false;
            }
            PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(new boolean[]{false});
            if (elements == null) {
                return false;
            }
            for (PsiElement element2 : elements) {
                PsiManager manager2 = element2.getManager();
                if (manager2 != null && manager2.getProject() == project) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/ide/CopyPasteDelegator$MyEditable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutEnabled";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutVisible";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performPaste";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performDefaultPaste";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPasteTarget";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPastePossible";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPasteEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

