/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AssertiveRepaintManager
extends RepaintManager {
    private static final Logger LOG = Logger.getInstance(AssertiveRepaintManager.class);
    private WeakReference<Component> myLastComponent;

    public AssertiveRepaintManager() {
        try {
            Field defaultSettingField = RepaintManager.class.getDeclaredField("BUFFER_STRATEGY_TYPE");
            defaultSettingField.setAccessible(true);
            short defaultSetting = (Short)defaultSettingField.get(null);
            Field bufferStrategyTypeField = RepaintManager.class.getDeclaredField("bufferStrategyType");
            bufferStrategyTypeField.setAccessible(true);
            bufferStrategyTypeField.set(this, defaultSetting);
        }
        catch (Throwable e) {
            LOG.warn("Could not set bufferingStrategy for AssertiveRepaintManager", e);
        }
    }

    @Override
    public synchronized void addInvalidComponent(JComponent invalidComponent) {
        this.checkThreadViolations(invalidComponent);
        super.addInvalidComponent(invalidComponent);
    }

    @Override
    public synchronized void removeInvalidComponent(JComponent component2) {
        this.checkThreadViolations(component2);
        super.removeInvalidComponent(component2);
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        this.checkThreadViolations(c);
        super.addDirtyRegion(c, x, y, w, h);
    }

    @Override
    public void addDirtyRegion(Window window, int x, int y, int w, int h) {
        this.checkThreadViolations(window);
        super.addDirtyRegion(window, x, y, w, h);
    }

    @Override
    public void addDirtyRegion(Applet applet, int x, int y, int w, int h) {
        this.checkThreadViolations(applet);
        super.addDirtyRegion(applet, x, y, w, h);
    }

    @Override
    public Rectangle getDirtyRegion(JComponent aComponent) {
        this.checkThreadViolations(aComponent);
        return super.getDirtyRegion(aComponent);
    }

    @Override
    public void markCompletelyDirty(JComponent aComponent) {
        this.checkThreadViolations(aComponent);
        super.markCompletelyDirty(aComponent);
    }

    @Override
    public void markCompletelyClean(JComponent aComponent) {
        this.checkThreadViolations(aComponent);
        super.markCompletelyClean(aComponent);
    }

    @Override
    public boolean isCompletelyDirty(JComponent aComponent) {
        this.checkThreadViolations(aComponent);
        return super.isCompletelyDirty(aComponent);
    }

    @Override
    public void validateInvalidComponents() {
        this.checkThreadViolations(null);
        super.validateInvalidComponents();
    }

    @Override
    public void paintDirtyRegions() {
        this.checkThreadViolations(null);
        super.paintDirtyRegions();
    }

    @Override
    public Image getOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        this.checkThreadViolations(c);
        return super.getOffscreenBuffer(c, proposedWidth, proposedHeight);
    }

    @Override
    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        this.checkThreadViolations(c);
        return super.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
    }

    private void checkThreadViolations(@Nullable Component c) {
        if (!SwingUtilities.isEventDispatchThread() && (c == null || c.isShowing())) {
            Exception exception = new Exception();
            StackTraceElement[] stackTrace = exception.getStackTrace();
            if (this.isAllowedViolation(c, stackTrace)) {
                return;
            }
            String categoriesString = Registry.stringValue((String)"non.edt.swing.report.categories");
            List categories = StringUtil.split((String)categoriesString, (String)",");
            if (AssertiveRepaintManager.shouldIgnoreStacktrace(categories, stackTrace)) {
                return;
            }
            LOG.warn("Access to realized (ever shown) UI components should be done only from the AWT event dispatch thread, revalidate(), invalidate() & repaint() is ok from any thread", (Throwable)exception);
        }
    }

    private static boolean shouldIgnoreStacktrace(@NotNull List<String> categories, StackTraceElement[] stackTrace) {
        if (categories == null) {
            AssertiveRepaintManager.$$$reportNull$$$0(0);
        }
        if (categories.contains("none")) {
            return true;
        }
        boolean all2 = categories.contains("all");
        boolean categoryMatched = false;
        for (StackTraceElement element2 : stackTrace) {
            if (element2.getClassName().equals("com.intellij.openapi.application.Preloader")) {
                if (all2 || categories.contains("preloader")) {
                    categoryMatched = true;
                    break;
                }
                return true;
            }
            if (element2.getClassName().equals("com.intellij.serviceContainer.MyComponentAdapter") && element2.getMethodName().equals("doCreateInstance")) {
                if (all2 || categories.contains("component")) {
                    categoryMatched = true;
                    break;
                }
                return true;
            }
            if (!element2.getClassName().equals("com.intellij.ui.CardLayoutPanel") || !element2.getMethodName().contains("selectLater")) continue;
            if (all2 || categories.contains("configurable")) {
                categoryMatched = true;
                break;
            }
            return true;
        }
        return !all2 && !categoryMatched && !categories.contains("unknown");
    }

    private boolean isAllowedViolation(@Nullable Component c, StackTraceElement[] stackTrace) {
        boolean repaint = false;
        boolean fromSwing = false;
        boolean swingKnownNonAwtOperations = false;
        for (StackTraceElement st : stackTrace) {
            String className = st.getClassName();
            String methodName = st.getMethodName();
            if (repaint && className.startsWith("javax.swing.")) {
                fromSwing = true;
            }
            if (repaint && "imageUpdate".equals(methodName)) {
                swingKnownNonAwtOperations = true;
            }
            if ("read".equals(methodName) && className.startsWith("javax.swing.JEditorPane") || "setCharacterAttributes".equals(methodName) && className.startsWith("javax.swing.text.DefaultStyledDocument")) {
                swingKnownNonAwtOperations = true;
                break;
            }
            if (!"repaint".equals(methodName)) continue;
            repaint = true;
            fromSwing = false;
        }
        if (swingKnownNonAwtOperations) {
            return true;
        }
        if (repaint && !fromSwing) {
            return true;
        }
        if (SoftReference.dereference(this.myLastComponent) == c) {
            return true;
        }
        this.myLastComponent = new WeakReference<Component>(c);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categories", "com/intellij/ide/AssertiveRepaintManager", "shouldIgnoreStacktrace"));
    }
}

