/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.index;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lexer.HtmlHighlightingLexer;
import com.intellij.lexer.XHtmlHighlightingLexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Html5CustomAttributesIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> INDEX_ID = ID.create((String)"html5.custom.attributes.index");
    private final DataIndexer<String, Void, FileContent> myIndexer = new DataIndexer<String, Void, FileContent>(){

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                1.$$$reportNull$$$0(0);
            }
            CharSequence input = inputData.getContentAsText();
            Language language = ((LanguageFileType)inputData.getFileType()).getLanguage();
            if (language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE) {
                HtmlHighlightingLexer lexer = language == HTMLLanguage.INSTANCE ? new HtmlHighlightingLexer(FileTypeManager.getInstance().getStdFileType("CSS")) : new XHtmlHighlightingLexer();
                lexer.start(input);
                HashMap<String, Void> result2 = new HashMap<String, Void>();
                IElementType tokenType = lexer.getTokenType();
                while (tokenType != null) {
                    if (tokenType == XmlTokenType.XML_NAME) {
                        String xmlName = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
                        if (HtmlUtil.isCustomHtml5Attribute(xmlName)) {
                            result2.put(xmlName, null);
                        }
                    } else if (tokenType == XmlTokenType.XML_DOCTYPE_PUBLIC || tokenType == XmlTokenType.XML_DOCTYPE_SYSTEM) break;
                    lexer.advance();
                    tokenType = lexer.getTokenType();
                }
                HashMap<String, Void> hashMap = result2;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }
            Map<String, Void> map2 = Collections.emptyMap();
            if (map2 == null) {
                1.$$$reportNull$$$0(2);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/html/index/Html5CustomAttributesIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/html/index/Html5CustomAttributesIndex$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = INDEX_ID;
        if (iD == null) {
            Html5CustomAttributesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            Html5CustomAttributesIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            Html5CustomAttributesIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{HtmlFileType.INSTANCE, XHtmlFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return file2.isInLocalFileSystem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/html/index/Html5CustomAttributesIndex$2", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/html/index/Html5CustomAttributesIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

