/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.views.RecentChangeDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public final class RecentChangesPopup {
    public static void show(Project project, IdeaGateway gw, LocalHistoryFacade vcs) {
        List<RecentChange> cc = vcs.getRecentChanges(gw.createTransientRootEntry());
        String title2 = LocalHistoryBundle.message("recent.changes.popup.title", new Object[0]);
        if (cc.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)LocalHistoryBundle.message("recent.changes.to.changes", new Object[0]), (String)title2);
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(cc).setSelectionMode(0).setRenderer((ListCellRenderer)new RecentChangesListCellRenderer()).setTitle(title2).setItemChosenCallback(change -> new RecentChangeDialog(project, gw, (RecentChange)change).show()).createPopup().showCenteredInCurrentWindow(project);
    }

    private static class RecentChangesListCellRenderer
    implements ListCellRenderer<RecentChange> {
        private final JPanel myPanel = new JPanel(new FlowLayout(3, 10, 2));
        private final JLabel myActionLabel = new JLabel("", 2);
        private final JLabel myDateLabel = new JLabel("", 2);
        private final JPanel mySpacePanel = new JPanel();

        RecentChangesListCellRenderer() {
            this.myPanel.add(this.myDateLabel);
            this.myPanel.add(this.mySpacePanel);
            this.myPanel.add(this.myActionLabel);
            Dimension d = new Dimension(10, this.mySpacePanel.getPreferredSize().height);
            this.mySpacePanel.setMinimumSize(d);
            this.mySpacePanel.setMaximumSize(d);
            this.mySpacePanel.setPreferredSize(d);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends RecentChange> list2, RecentChange value2, int index2, boolean isSelected, boolean cellHasFocus) {
            this.myActionLabel.setText(value2.getChangeName());
            this.myDateLabel.setText(DateFormatUtil.formatDateTime((long)value2.getTimestamp()));
            this.updateColors(isSelected);
            return this.myPanel;
        }

        private void updateColors(boolean isSelected) {
            Color bg = isSelected ? UIUtil.getTableSelectionBackground((boolean)true) : UIUtil.getTableBackground();
            Color fg = isSelected ? UIUtil.getTableSelectionForeground((boolean)true) : UIUtil.getTableForeground();
            this.setColors(bg, fg, this.myPanel, this.myActionLabel, this.myDateLabel, this.mySpacePanel);
        }

        private void setColors(Color bg, Color fg, JComponent ... cc) {
            for (JComponent c : cc) {
                c.setBackground(bg);
                c.setForeground(fg);
            }
        }
    }
}

