/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.DynamicBundle;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.framework.detection.impl.ui.DetectedFrameworksTree;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class DetectedFrameworksComponent {
    private JPanel myMainPanel;
    private final DetectedFrameworksTree myTree;
    private JPanel myTreePanel;
    private JComboBox<GroupByOption> myGroupByComboBox;
    private JLabel myDescriptionLabel;
    private JPanel myOptionsPanel;

    public DetectedFrameworksComponent(FrameworkDetectionContext context2) {
        this.$$$setupUI$$$();
        this.myTree = new DetectedFrameworksTree(context2, GroupByOption.TYPE){

            @Override
            protected void onNodeStateChanged(CheckedTreeNode node2) {
                super.onNodeStateChanged(node2);
                DetectedFrameworksComponent.this.updateOptionsPanel();
            }
        };
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree)), "Center");
        this.myGroupByComboBox.setModel((ComboBoxModel<GroupByOption>)new EnumComboBoxModel(GroupByOption.class));
        this.myGroupByComboBox.setRenderer((ListCellRenderer<GroupByOption>)SimpleListCellRenderer.create((String)"", GroupByOption::getPresentableName));
        this.myGroupByComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetectedFrameworksComponent.this.myTree.changeGroupBy((GroupByOption)((Object)DetectedFrameworksComponent.this.myGroupByComboBox.getSelectedItem()));
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DetectedFrameworksComponent.this.updateOptionsPanel();
            }
        });
        this.updateOptionsPanel();
    }

    public DetectedFrameworksTree getTree() {
        return this.myTree;
    }

    private void updateOptionsPanel() {
        DetectedFrameworkTreeNodeBase[] nodes = (DetectedFrameworkTreeNodeBase[])this.myTree.getSelectedNodes(DetectedFrameworkTreeNodeBase.class, null);
        if (nodes.length == 1) {
            String description2;
            DetectedFrameworkTreeNodeBase node2 = nodes[0];
            String string = description2 = node2.isChecked() ? node2.getCheckedDescription() : node2.getUncheckedDescription();
            if (description2 != null) {
                ((CardLayout)this.myOptionsPanel.getLayout()).show(this.myOptionsPanel, "description");
                this.myDescriptionLabel.setText(UIUtil.toHtml((String)description2));
                return;
            }
        }
        ((CardLayout)this.myOptionsPanel.getLayout()).show(this.myOptionsPanel, "empty");
    }

    public List<DetectedFrameworkDescription> getSelectedFrameworks() {
        return Arrays.asList((DetectedFrameworkDescription[])this.myTree.getCheckedNodes(DetectedFrameworkDescription.class, null));
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    public void processUncheckedNodes(DetectionExcludesConfiguration excludesConfiguration) {
        this.getTree().processUncheckedNodes((Consumer<? super DetectedFrameworkTreeNodeBase>)((Consumer)node2 -> node2.disableDetection(excludesConfiguration)));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 5));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, "North");
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myGroupByComboBox = jComboBox;
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/LangBundle", DetectedFrameworksComponent.class).getString("label.frameworks.group.by"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTreePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, "Center");
        this.myOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, "South");
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, "description");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, "empty");
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static enum GroupByOption {
        TYPE(ProjectBundle.messagePointer((String)"list.item.group.by.type", (Object[])new Object[0])),
        DIRECTORY(ProjectBundle.messagePointer((String)"list.item.group.by.directory", (Object[])new Object[0]));

        private final Supplier<@NlsContexts.ListItem String> myPresentableName;

        private GroupByOption(Supplier<String> presentableName) {
            this.myPresentableName = presentableName;
        }

        @NlsContexts.ListItem
        String getPresentableName() {
            return this.myPresentableName.get();
        }
    }
}

