/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.commandLine.FileSetProcessor;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.PlatformUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileSetFormatter
extends FileSetProcessor {
    private static final Logger LOG = Logger.getInstance(FileSetFormatter.class);
    private static final String PROJECT_DIR_PREFIX = PlatformUtils.getPlatformPrefix() + ".format.";
    private static final String PROJECT_DIR_SUFFIX = ".tmp";
    private static final String RESULT_MESSAGE_OK = "OK";
    private static final String RESULT_MESSAGE_FAILED = "Failed";
    private static final String RESULT_MESSAGE_NOT_SUPPORTED = "Skipped, not supported.";
    private static final String RESULT_MESSAGE_REJECTED_BY_FORMATTER = "Skipped, rejected by formatter.";
    private static final String RESULT_MESSAGE_BINARY_FILE = "Skipped, binary file.";
    @NotNull
    private final String myProjectUID;
    @Nullable
    private Project myProject;
    private final MessageOutput myMessageOutput;
    @NotNull
    private CodeStyleSettings mySettings;

    public FileSetFormatter(@NotNull MessageOutput messageOutput) {
        if (messageOutput == null) {
            FileSetFormatter.$$$reportNull$$$0(0);
        }
        this.myMessageOutput = messageOutput;
        this.mySettings = CodeStyleSettingsManager.getInstance().createSettings();
        this.myProjectUID = UUID.randomUUID().toString();
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings settings2) {
        if (settings2 == null) {
            FileSetFormatter.$$$reportNull$$$0(1);
        }
        this.mySettings = settings2;
    }

    private void createProject() throws IOException {
        this.myProject = ProjectManagerEx.getInstanceEx().openProject(this.createProjectDir(), OpenProjectTask.newProject());
        if (this.myProject != null) {
            CodeStyle.setMainProjectSettings((Project)this.myProject, (CodeStyleSettings)this.mySettings);
        }
    }

    @NotNull
    private Path createProjectDir() throws IOException {
        Path projectDir = FileUtil.createTempDirectory((String)PROJECT_DIR_PREFIX, (String)(this.myProjectUID + PROJECT_DIR_SUFFIX)).toPath().resolve(".idea");
        Files.createDirectories(projectDir, new FileAttribute[0]);
        Path path2 = projectDir;
        if (path2 == null) {
            FileSetFormatter.$$$reportNull$$$0(2);
        }
        return path2;
    }

    private void closeProject() {
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().closeAndDispose(this.myProject);
        }
    }

    @Override
    public void processFiles() throws IOException {
        this.createProject();
        if (this.myProject != null) {
            super.processFiles();
            this.closeProject();
        }
    }

    @Override
    protected boolean processFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            FileSetFormatter.$$$reportNull$$$0(3);
        }
        String resultMessage = RESULT_MESSAGE_OK;
        assert (this.myProject != null);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile2});
        this.myMessageOutput.info("Formatting " + virtualFile2.getCanonicalPath() + "...");
        if (!virtualFile2.getFileType().isBinary()) {
            VirtualFile[] openFiles;
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
            if (document != null) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(virtualFile2));
                if (psiFile != null) {
                    if (FileSetFormatter.isFormattingSupported(psiFile)) {
                        try {
                            FileSetFormatter.reformatFile(this.myProject, psiFile, document);
                        }
                        catch (ProcessCanceledException pce) {
                            String cause = StringUtil.notNullize((String)(pce.getCause() != null ? pce.getCause().getMessage() : pce.getMessage()));
                            LOG.warn(virtualFile2.getCanonicalPath() + ": Skipped, rejected by formatter. " + cause);
                            resultMessage = RESULT_MESSAGE_REJECTED_BY_FORMATTER;
                        }
                        FileDocumentManager.getInstance().saveDocument(document);
                    } else {
                        resultMessage = RESULT_MESSAGE_NOT_SUPPORTED;
                    }
                } else {
                    LOG.warn("Unable to get a PSI file for " + virtualFile2.getPath());
                    resultMessage = RESULT_MESSAGE_FAILED;
                }
            } else {
                LOG.warn("No document available for " + virtualFile2.getPath());
                resultMessage = RESULT_MESSAGE_FAILED;
            }
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myProject);
            for (VirtualFile openFile2 : openFiles = editorManager.getOpenFiles()) {
                editorManager.closeFile(openFile2);
            }
        } else {
            resultMessage = RESULT_MESSAGE_BINARY_FILE;
        }
        this.myMessageOutput.info(resultMessage + "\n");
        return RESULT_MESSAGE_OK.equals(resultMessage);
    }

    private static void reformatFile(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document) {
        if (project == null) {
            FileSetFormatter.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            FileSetFormatter.$$$reportNull$$$0(5);
        }
        if (document == null) {
            FileSetFormatter.$$$reportNull$$$0(6);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformatText(file2, 0, file2.getTextLength());
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        });
    }

    private static boolean isFormattingSupported(@NotNull PsiFile file2) {
        FormattingService formattingService;
        if (file2 == null) {
            FileSetFormatter.$$$reportNull$$$0(7);
        }
        if ((formattingService = FormattingServiceUtil.findService(file2, true, true)) instanceof CoreFormattingService) {
            return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageOutput";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/commandLine/FileSetFormatter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/commandLine/FileSetFormatter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCodeStyleSettings";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reformatFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFormattingSupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

