/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatTextRanges
implements FormattingRangesInfo {
    private final List<TextRange> myInsertedRanges;
    private final List<FormatTextRange> myRanges;
    private final List<TextRange> myExtendedRanges;
    private final List<TextRange> myDisabledRanges;
    private boolean myExtendToContext;

    public FormatTextRanges() {
        this.myRanges = new ArrayList<FormatTextRange>();
        this.myExtendedRanges = new ArrayList<TextRange>();
        this.myDisabledRanges = new ArrayList<TextRange>();
        this.myInsertedRanges = null;
    }

    public FormatTextRanges(TextRange range2, boolean processHeadingWhitespace) {
        this.myRanges = new ArrayList<FormatTextRange>();
        this.myExtendedRanges = new ArrayList<TextRange>();
        this.myDisabledRanges = new ArrayList<TextRange>();
        this.myInsertedRanges = null;
        this.add(range2, processHeadingWhitespace);
    }

    public FormatTextRanges(@NotNull ChangedRangesInfo changedRangesInfo, @NotNull List<? extends TextRange> contextRanges) {
        if (changedRangesInfo == null) {
            FormatTextRanges.$$$reportNull$$$0(0);
        }
        if (contextRanges == null) {
            FormatTextRanges.$$$reportNull$$$0(1);
        }
        this.myRanges = new ArrayList<FormatTextRange>();
        this.myExtendedRanges = new ArrayList<TextRange>();
        this.myDisabledRanges = new ArrayList<TextRange>();
        this.myInsertedRanges = changedRangesInfo.insertedRanges;
        boolean processHeadingWhitespace = false;
        for (TextRange textRange : contextRanges) {
            this.add(textRange, processHeadingWhitespace);
            processHeadingWhitespace = true;
        }
    }

    public void add(TextRange range2, boolean processHeadingWhitespace) {
        this.myRanges.add(new FormatTextRange(range2, processHeadingWhitespace));
    }

    public boolean isWhitespaceReadOnly(@NotNull TextRange range2) {
        if (range2 == null) {
            FormatTextRanges.$$$reportNull$$$0(2);
        }
        return ContainerUtil.and(this.myRanges, formatTextRange -> formatTextRange.isWhitespaceReadOnly(range2));
    }

    public boolean isReadOnly(@NotNull TextRange range2) {
        if (range2 == null) {
            FormatTextRanges.$$$reportNull$$$0(3);
        }
        return ContainerUtil.and(this.myRanges, formatTextRange -> formatTextRange.isReadOnly(range2));
    }

    public boolean isOnInsertedLine(int offset) {
        if (this.myInsertedRanges == null) {
            return false;
        }
        Optional<TextRange> enclosingRange = this.myInsertedRanges.stream().filter(range2 -> range2.contains(offset)).findAny();
        return enclosingRange.isPresent();
    }

    public List<FormatTextRange> getRanges() {
        return this.myRanges;
    }

    public FormatTextRanges ensureNonEmpty() {
        FormatTextRanges result2 = new FormatTextRanges();
        for (FormatTextRange range2 : this.myRanges) {
            if (range2.isProcessHeadingWhitespace()) {
                result2.add(range2.getNonEmptyTextRange(), true);
                continue;
            }
            result2.add(range2.getTextRange(), false);
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.myRanges.isEmpty();
    }

    public boolean isFullReformat(PsiFile file2) {
        return this.myRanges.size() == 1 && file2.getTextRange().equals((Object)this.myRanges.get(0).getTextRange());
    }

    @NotNull
    public List<TextRange> getTextRanges() {
        List ranges = ContainerUtil.map(this.myRanges, FormatTextRange::getTextRange);
        ranges.sort(Segment.BY_START_OFFSET_THEN_END_OFFSET);
        List list2 = ranges;
        if (list2 == null) {
            FormatTextRanges.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void setExtendedRanges(@NotNull List<? extends TextRange> extendedRanges) {
        if (extendedRanges == null) {
            FormatTextRanges.$$$reportNull$$$0(5);
        }
        this.myExtendedRanges.addAll(extendedRanges);
    }

    public List<TextRange> getExtendedRanges() {
        return this.myExtendedRanges.isEmpty() ? this.getTextRanges() : this.myExtendedRanges;
    }

    @Nullable
    public TextRange getBoundRange() {
        List<TextRange> ranges = this.getTextRanges();
        return ranges.size() > 0 ? new TextRange(ranges.get(0).getStartOffset(), ranges.get(ranges.size() - 1).getEndOffset()) : null;
    }

    public boolean isExtendToContext() {
        return this.myExtendToContext;
    }

    public void setExtendToContext(boolean extendToContext) {
        this.myExtendToContext = extendToContext;
    }

    public void setDisabledRanges(@NotNull Collection<? extends TextRange> disabledRanges) {
        if (disabledRanges == null) {
            FormatTextRanges.$$$reportNull$$$0(6);
        }
        this.myDisabledRanges.clear();
        this.myDisabledRanges.addAll(ContainerUtil.sorted(disabledRanges, (Comparator)Segment.BY_START_OFFSET_THEN_END_OFFSET));
    }

    public boolean isInDisabledRange(@NotNull TextRange textRange) {
        if (textRange == null) {
            FormatTextRanges.$$$reportNull$$$0(7);
        }
        return TextRangeUtil.intersectsOneOf((TextRange)textRange, this.myDisabledRanges);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRangesInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextRanges";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/FormatTextRanges";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedRanges";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRanges";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/FormatTextRanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespaceReadOnly";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isReadOnly";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setExtendedRanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledRanges";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInDisabledRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

