/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DependantSpacingImpl
extends SpacingImpl {
    private static final int DEPENDENCE_CONTAINS_LF_MASK = 16;
    private static final int DEPENDENT_REGION_LF_CHANGED_MASK = 32;
    @NotNull
    private final List<TextRange> myDependentRegionRanges;
    @NotNull
    private final DependentSpacingRule myRule;

    public DependantSpacingImpl(int minSpaces, int maxSpaces, @NotNull TextRange dependency, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependency == null) {
            DependantSpacingImpl.$$$reportNull$$$0(0);
        }
        if (rule == null) {
            DependantSpacingImpl.$$$reportNull$$$0(1);
        }
        super(minSpaces, maxSpaces, 0, false, false, keepLineBreaks, keepBlankLines, false, 0);
        this.myDependentRegionRanges = new SmartList((Object)dependency);
        this.myRule = rule;
    }

    public DependantSpacingImpl(int minSpaces, int maxSpaces, @NotNull List<TextRange> dependencyRanges, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependencyRanges == null) {
            DependantSpacingImpl.$$$reportNull$$$0(2);
        }
        if (rule == null) {
            DependantSpacingImpl.$$$reportNull$$$0(3);
        }
        super(minSpaces, maxSpaces, 0, false, false, keepLineBreaks, keepBlankLines, false, 0);
        this.myDependentRegionRanges = dependencyRanges;
        this.myRule = rule;
    }

    @Override
    public int getMinLineFeeds() {
        if (!this.isTriggered()) {
            return super.getMinLineFeeds();
        }
        if (this.myRule.hasData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS)) {
            return this.myRule.getData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS);
        }
        if (this.myRule.hasData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS)) {
            return this.myRule.getData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS);
        }
        return super.getMinLineFeeds();
    }

    @Override
    public int getKeepBlankLines() {
        if (!this.isTriggered() || !this.myRule.hasData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS)) {
            return super.getKeepBlankLines();
        }
        return 0;
    }

    @Override
    public void refresh(BlockRangesMap helper) {
        if (this.isDependentRegionLinefeedStatusChanged()) {
            return;
        }
        boolean atLeastOneDependencyRangeContainsLf = false;
        for (TextRange dependency : this.myDependentRegionRanges) {
            atLeastOneDependencyRangeContainsLf |= helper.containsLineFeedsOrTooLong(dependency);
        }
        this.myFlags = atLeastOneDependencyRangeContainsLf ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
    }

    @NotNull
    public List<TextRange> getDependentRegionRanges() {
        List<TextRange> list2 = this.myDependentRegionRanges;
        if (list2 == null) {
            DependantSpacingImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public final boolean isDependentRegionLinefeedStatusChanged() {
        return (this.myFlags & 0x20) != 0;
    }

    public final void setDependentRegionLinefeedStatusChanged() {
        this.myFlags |= 0x20;
        this.myFlags = this.getMinLineFeeds() <= 0 ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
    }

    @Override
    public String toString() {
        String dependencies = StringUtil.join(this.myDependentRegionRanges, (String)", ");
        return "<DependantSpacing: minSpaces=" + this.getMinSpaces() + " maxSpaces=" + this.getMaxSpaces() + " minLineFeeds=" + this.getMinLineFeeds() + " dep=" + dependencies + ">";
    }

    private boolean isTriggered() {
        return this.myRule.getTrigger() == DependentSpacingRule.Trigger.HAS_LINE_FEEDS ^ (this.myFlags & 0x10) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyRanges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/DependantSpacingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/DependantSpacingImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentRegionRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

