/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUtil;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectExtension;
import com.intellij.find.impl.FindInProjectTask;
import com.intellij.find.impl.FindResultUsageInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.LangBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class FindInProjectUtil {
    private static final int USAGES_PER_READ_ACTION = 100;

    private FindInProjectUtil() {
    }

    public static void setDirectoryName(@NotNull FindModel model2, @NotNull DataContext dataContext) {
        Module module;
        VirtualFile virtualFile2;
        EditorSearchSession session22;
        if (model2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            FindInProjectUtil.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = null;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null && (session22 = EditorSearchSession.SESSION_KEY.getData(dataContext)) != null) {
            editor = session22.getEditor();
        }
        if (project != null && editor == null && !DumbServiceImpl.getInstance(project).isDumb()) {
            try {
                psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            catch (IndexNotReadyException session22) {
                // empty catch block
            }
        }
        String directoryName = null;
        if (psiElement instanceof PsiDirectory) {
            directoryName = ((PsiDirectory)psiElement).getVirtualFile().getPresentableUrl();
        }
        if (directoryName == null && psiElement instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)psiElement).getDirectories();
            String string = directoryName = directories.length == 1 ? directories[0].getVirtualFile().getPresentableUrl() : null;
        }
        if (directoryName == null && (virtualFile2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null) {
            if (virtualFile2.isDirectory()) {
                directoryName = virtualFile2.getPresentableUrl();
            } else {
                VirtualFile parent = virtualFile2.getParent();
                if (parent != null && parent.isDirectory()) {
                    if (editor == null) {
                        directoryName = parent.getPresentableUrl();
                    } else {
                        FindInProjectSettings.getInstance((Project)project).addDirectory(parent.getPresentableUrl());
                    }
                }
            }
        }
        if ((module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext)) != null) {
            model2.setModuleName(module.getName());
            model2.setDirectoryName(null);
            model2.setCustomScope(false);
        }
        if ((model2.getModuleName() == null || editor == null) && directoryName != null) {
            model2.setDirectoryName(directoryName);
            model2.setCustomScope(false);
        }
        if (directoryName == null) {
            FindInProjectExtension extension2;
            boolean success2;
            Iterator iterator2 = FindInProjectExtension.EP_NAME.getExtensionList().iterator();
            while (iterator2.hasNext() && !(success2 = (extension2 = (FindInProjectExtension)iterator2.next()).initModelFromContext(model2, dataContext))) {
            }
        }
        model2.setProjectScope(model2.getDirectoryName() == null && model2.getModuleName() == null && !model2.isCustomScope());
    }

    @Nullable
    public static VirtualFile getDirectory(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(2);
        }
        String directoryName = findModel.getDirectoryName();
        if (findModel.isProjectScope() || StringUtil.isEmptyOrSpaces((String)directoryName)) {
            return null;
        }
        String path2 = FileUtil.toSystemIndependentName((String)directoryName);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(path2);
        if (virtualFile2 == null || !virtualFile2.isDirectory()) {
            virtualFile2 = null;
            List<VirtualFileSystem> fileSystems = ((VirtualFileManagerImpl)VirtualFileManager.getInstance()).getPhysicalFileSystems();
            for (VirtualFileSystem fs : fileSystems) {
                VirtualFile file2;
                if (!(fs instanceof LocalFileProvider) || (file2 = fs.findFileByPath(path2)) == null || !file2.isDirectory()) continue;
                if (file2.getChildren().length > 0) {
                    virtualFile2 = file2;
                    break;
                }
                if (virtualFile2 != null) continue;
                virtualFile2 = file2;
            }
            if (virtualFile2 == null && !path2.contains("!/")) {
                virtualFile2 = JarFileSystem.getInstance().findFileByPath(path2 + "!/");
            }
        }
        return virtualFile2;
    }

    @NotNull
    public static Condition<CharSequence> createFileMaskCondition(@Nullable String filter) throws PatternSyntaxException {
        if (StringUtil.isEmpty((String)filter)) {
            Condition condition2 = Conditions.alwaysTrue();
            if (condition2 == null) {
                FindInProjectUtil.$$$reportNull$$$0(3);
            }
            return condition2;
        }
        Object pattern = "";
        Object negativePattern = "";
        List masks = StringUtil.split((String)filter, (String)",");
        for (String mask : masks) {
            if (StringUtil.startsWith((CharSequence)(mask = mask.trim()), (CharSequence)"!")) {
                negativePattern = (String)negativePattern + (((String)negativePattern).isEmpty() ? "" : "|") + "(" + PatternUtil.convertToRegex((String)mask.substring(1)) + ")";
                continue;
            }
            pattern = (String)pattern + (((String)pattern).isEmpty() ? "" : "|") + "(" + PatternUtil.convertToRegex((String)mask) + ")";
        }
        if (((String)pattern).isEmpty()) {
            pattern = PatternUtil.convertToRegex((String)"*");
        }
        final String finalPattern = pattern;
        final String finalNegativePattern = negativePattern;
        return new Condition<CharSequence>(){
            final Pattern regExp;
            final Pattern negativeRegExp;
            {
                this.regExp = Pattern.compile(finalPattern, 2);
                this.negativeRegExp = StringUtil.isEmpty((String)finalNegativePattern) ? null : Pattern.compile(finalNegativePattern, 2);
            }

            public boolean value(CharSequence input) {
                return this.regExp.matcher(input).matches() && (this.negativeRegExp == null || !this.negativeRegExp.matcher(input).matches());
            }
        };
    }

    public static void findUsages(@NotNull FindModel findModel, @NotNull Project project, @NotNull Processor<? super UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(6);
        }
        if (processPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(7);
        }
        FindInProjectUtil.findUsages(findModel, project, processPresentation, Collections.emptySet(), consumer);
    }

    public static void findUsages(@NotNull FindModel findModel, @NotNull Project project, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull Set<? extends VirtualFile> filesToStart, @NotNull Processor<? super UsageInfo> consumer) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(8);
        }
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(9);
        }
        if (processPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(10);
        }
        if (filesToStart == null) {
            FindInProjectUtil.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(12);
        }
        Runnable runnable2 = () -> new FindInProjectTask(findModel, project, filesToStart).findUsages(processPresentation, consumer);
        if (ProgressManager.getGlobalProgressIndicator() == null) {
            ProgressManager.getInstance().runProcess(runnable2, (ProgressIndicator)new EmptyProgressIndicator());
        } else {
            runnable2.run();
        }
    }

    static boolean processUsagesInFile(@NotNull PsiFile psiFile, @NotNull VirtualFile virtualFile2, @NotNull FindModel findModel, @NotNull Processor<? super UsageInfo> consumer) {
        int before;
        if (psiFile == null) {
            FindInProjectUtil.$$$reportNull$$$0(13);
        }
        if (virtualFile2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(14);
        }
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(15);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(16);
        }
        if (findModel.getStringToFind().isEmpty()) {
            return (Boolean)ReadAction.compute(() -> consumer.process((Object)new UsageInfo(psiFile)));
        }
        if (virtualFile2.getFileType().isBinary()) {
            return true;
        }
        Document document = (Document)ReadAction.compute(() -> virtualFile2.isValid() ? FileDocumentManager.getInstance().getDocument(virtualFile2) : null);
        if (document == null) {
            return true;
        }
        int[] offsetRef = new int[]{0};
        ProgressIndicator current2 = ProgressManager.getInstance().getProgressIndicator();
        if (current2 == null) {
            throw new IllegalStateException("must find usages under progress");
        }
        ProgressIndicator indicator2 = ProgressWrapper.unwrapAll(current2);
        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom(indicator2);
        do {
            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
            before = offsetRef[0];
            boolean success2 = (Boolean)ReadAction.compute(() -> !psiFile.isValid() || FindInProjectUtil.processSomeOccurrencesInFile(document, findModel, psiFile, offsetRef, consumer));
            if (success2) continue;
            return false;
        } while (offsetRef[0] != before);
        return true;
    }

    private static boolean processSomeOccurrencesInFile(@NotNull Document document, @NotNull FindModel findModel, @NotNull PsiFile psiFile, int @NotNull [] offsetRef, @NotNull Processor<? super UsageInfo> consumer) {
        FindResult result2;
        if (document == null) {
            FindInProjectUtil.$$$reportNull$$$0(17);
        }
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(18);
        }
        if (psiFile == null) {
            FindInProjectUtil.$$$reportNull$$$0(19);
        }
        if (consumer == null) {
            FindInProjectUtil.$$$reportNull$$$0(20);
        }
        if (offsetRef == null) {
            FindInProjectUtil.$$$reportNull$$$0(21);
        }
        CharSequence text2 = document.getCharsSequence();
        int textLength = document.getTextLength();
        int offset = offsetRef[0];
        Project project = psiFile.getProject();
        FindManager findManager = FindManager.getInstance((Project)project);
        int count = 0;
        while (offset < textLength && (result2 = findManager.findString(text2, offset, findModel, psiFile.getVirtualFile())).isStringFound()) {
            TextRange range2;
            SearchScope customScope;
            int prevOffset = offset;
            if (prevOffset == (offset = result2.getEndOffset()) || offset == result2.getStartOffset()) {
                ++offset;
            }
            if ((customScope = findModel.getCustomScope()) instanceof LocalSearchScope && !((LocalSearchScope)customScope).containsRange(psiFile, range2 = new TextRange(result2.getStartOffset(), result2.getEndOffset()))) continue;
            FindResultUsageInfo info2 = new FindResultUsageInfo(findManager, psiFile, prevOffset, findModel, result2);
            if (!consumer.process((Object)info2)) {
                return false;
            }
            if (++count < 100) continue;
            break;
        }
        offsetRef[0] = offset;
        return true;
    }

    @NotNull
    @Nls
    private static String getTitleForScope(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(22);
        }
        String scopeName = findModel.isProjectScope() ? FindBundle.message("find.scope.project.title", new Object[0]) : (findModel.getModuleName() != null ? FindBundle.message("find.scope.module.title", findModel.getModuleName()) : (findModel.getCustomScopeName() != null ? findModel.getCustomScopeName() : FindBundle.message("find.scope.directory.title", findModel.getDirectoryName())));
        Object result2 = scopeName;
        if (findModel.getFileFilter() != null) {
            result2 = (String)result2 + " " + FindBundle.message("find.scope.files.with.mask", findModel.getFileFilter());
        }
        String string = result2;
        if (string == null) {
            FindInProjectUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static UsageViewPresentation setupViewPresentation(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(24);
        }
        return FindInProjectUtil.setupViewPresentation(FindSettings.getInstance().isShowResultsInSeparateView(), findModel);
    }

    @NotNull
    public static UsageViewPresentation setupViewPresentation(boolean toOpenInNewTab, @NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(25);
        }
        UsageViewPresentation presentation2 = new UsageViewPresentation();
        FindInProjectUtil.setupViewPresentation(presentation2, toOpenInNewTab, findModel);
        UsageViewPresentation usageViewPresentation = presentation2;
        if (usageViewPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(26);
        }
        return usageViewPresentation;
    }

    public static void setupViewPresentation(UsageViewPresentation presentation2, @NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(27);
        }
        FindInProjectUtil.setupViewPresentation(presentation2, FindSettings.getInstance().isShowResultsInSeparateView(), findModel);
    }

    public static void setupViewPresentation(UsageViewPresentation presentation2, boolean toOpenInNewTab, @NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(28);
        }
        Object scope2 = FindInProjectUtil.getTitleForScope(findModel);
        String stringToFind = findModel.getStringToFind();
        String stringToReplace = findModel.getStringToReplace();
        presentation2.setScopeText((String)scope2);
        if (stringToFind.isEmpty()) {
            if (!((String)scope2).isEmpty()) {
                scope2 = Character.toLowerCase(((String)scope2).charAt(0)) + ((String)scope2).substring(1);
            }
            presentation2.setTabText(FindBundle.message("tab.title.files", new Object[0]));
            presentation2.setToolwindowTitle(FindBundle.message("tab.title.files.in.scope", scope2));
            presentation2.setUsagesString(LangBundle.message((String)"files", (Object[])new Object[0]));
        } else {
            FindModel.SearchContext searchContext = findModel.getSearchContext();
            String contextText = "";
            if (searchContext != FindModel.SearchContext.ANY) {
                contextText = FindBundle.message("find.context.presentation.scope.label", FindInProjectUtil.getPresentableName(searchContext));
            }
            if (!findModel.isReplaceState()) {
                presentation2.setTabText(FindBundle.message("find.usage.view.tab.text", stringToFind, contextText));
                presentation2.setToolwindowTitle(FindBundle.message("find.usage.view.toolwindow.title", stringToFind, scope2, contextText));
            } else {
                presentation2.setTabText(FindBundle.message("replace.usage.view.tab.text", stringToFind, stringToReplace, contextText));
                presentation2.setToolwindowTitle(FindBundle.message("replace.usage.view.toolwindow.title", stringToFind, stringToReplace, scope2, contextText));
            }
            presentation2.setSearchString(FindBundle.message("find.occurrences.search.string", stringToFind, searchContext.ordinal()));
            presentation2.setCodeUsagesString(FindBundle.message("found.occurrences", new Object[0]));
        }
        presentation2.setOpenInNewTab(toOpenInNewTab);
        presentation2.setCodeUsages(false);
        presentation2.setUsageTypeFilteringAvailable(true);
        if (findModel.isReplaceState() && findModel.isRegularExpressions()) {
            presentation2.setSearchPattern(findModel.compileRegExp());
            try {
                presentation2.setReplacePattern(Pattern.compile(findModel.getStringToReplace()));
            }
            catch (Exception e) {
                presentation2.setReplacePattern(null);
            }
        } else {
            presentation2.setSearchPattern(null);
            presentation2.setReplacePattern(null);
        }
        presentation2.setReplaceMode(findModel.isReplaceState());
    }

    @NotNull
    public static FindUsagesProcessPresentation setupProcessPresentation(@NotNull Project project, @NotNull UsageViewPresentation presentation2) {
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(29);
        }
        if (presentation2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(30);
        }
        return FindInProjectUtil.setupProcessPresentation(project, !FindSettings.getInstance().isSkipResultsWithOneUsage(), presentation2);
    }

    @NotNull
    public static FindUsagesProcessPresentation setupProcessPresentation(@NotNull Project project, boolean showPanelIfOnlyOneUsage, @NotNull UsageViewPresentation presentation2) {
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(31);
        }
        if (presentation2 == null) {
            FindInProjectUtil.$$$reportNull$$$0(32);
        }
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation2);
        processPresentation.setShowNotFoundMessage(true);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        FindUsagesProcessPresentation findUsagesProcessPresentation = processPresentation;
        if (findUsagesProcessPresentation == null) {
            FindInProjectUtil.$$$reportNull$$$0(33);
        }
        return findUsagesProcessPresentation;
    }

    private static List<PsiElement> getTopLevelRegExpChars(String regExpText, Project project) {
        PsiElement[] children2;
        String regexFileName = "A.regexp";
        FileType regexFileType = FileTypeRegistry.getInstance().getFileTypeByFileName(regexFileName);
        if (regexFileType == UnknownFileType.INSTANCE) {
            return Collections.emptyList();
        }
        PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText(regexFileName, regexFileType, (CharSequence)regExpText);
        List<PsiElement> result2 = null;
        for (PsiElement child2 : children2 = file2.getChildren()) {
            PsiElement[] grandChildren = child2.getChildren();
            if (grandChildren.length != 1) {
                return Collections.emptyList();
            }
            for (PsiElement grandGrandChild : grandChildren[0].getChildren()) {
                if (result2 == null) {
                    result2 = new ArrayList<PsiElement>();
                }
                result2.add(grandGrandChild);
            }
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static String extractStringToFind(@NotNull String regexp, @NotNull Project project) {
        if (regexp == null) {
            FindInProjectUtil.$$$reportNull$$$0(34);
        }
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(35);
        }
        String string = (String)ReadAction.compute(() -> {
            List<PsiElement> topLevelRegExpChars = FindInProjectUtil.getTopLevelRegExpChars("a", project);
            if (topLevelRegExpChars.size() != 1) {
                return " ";
            }
            Class<?> regExpCharPsiClass = topLevelRegExpChars.get(0).getClass();
            return FindInProjectUtil.getTopLevelRegExpChars(regexp, project).stream().map(psi -> {
                String text2;
                if (regExpCharPsiClass.isInstance(psi) && !(text2 = psi.getText()).startsWith("\\")) {
                    return text2;
                }
                return " ";
            }).collect(Collectors.joining());
        });
        if (string == null) {
            FindInProjectUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public static String buildStringToFindForIndicesFromRegExp(@NotNull String stringToFind, @NotNull Project project) {
        if (stringToFind == null) {
            FindInProjectUtil.$$$reportNull$$$0(37);
        }
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(38);
        }
        String string = StringUtil.trim((String)StringUtil.join((String[])new String[]{FindInProjectUtil.extractStringToFind(stringToFind, project), " "}));
        if (string == null) {
            FindInProjectUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    public static void initStringToFindFromDataContext(FindModel findModel, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            FindInProjectUtil.$$$reportNull$$$0(40);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        FindUtil.initStringToFindWithSelection(findModel, editor);
        if (editor == null || !editor.getSelectionModel().hasSelection()) {
            FindUtil.useFindStringFromFindInFileModel(findModel, (Editor)CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getData(dataContext));
        }
    }

    private static void addSourceDirectoriesFromLibraries(@NotNull Project project, @NotNull VirtualFile directory, @NotNull Collection<? super VirtualFile> outSourceRoots) {
        ProjectFileIndex index2;
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(41);
        }
        if (directory == null) {
            FindInProjectUtil.$$$reportNull$$$0(42);
        }
        if (outSourceRoots == null) {
            FindInProjectUtil.$$$reportNull$$$0(43);
        }
        if (!(index2 = ProjectFileIndex.SERVICE.getInstance((Project)project)).isInLibraryClasses(directory)) {
            return;
        }
        VirtualFile classRoot = index2.getClassRootForFile(directory);
        if (classRoot == null) {
            return;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)directory, (VirtualFile)classRoot);
        if (relativePath == null) {
            return;
        }
        HashSet<VirtualFile> otherSourceRoots = new HashSet<VirtualFile>();
        block0: for (OrderEntry entry2 : index2.getOrderEntriesForFile(directory)) {
            if (entry2 instanceof LibraryOrderEntry) {
                String[] sourceUrls;
                Library library2 = ((LibraryOrderEntry)entry2).getLibrary();
                if (library2 == null) continue;
                for (String sourceUrl : sourceUrls = library2.getUrls(OrderRootType.SOURCES)) {
                    if (!VfsUtilCore.isEqualOrAncestor((String)sourceUrl, (String)directory.getUrl())) continue;
                    otherSourceRoots.clear();
                    break block0;
                }
            }
            for (VirtualFile sourceRoot : entry2.getFiles(OrderRootType.SOURCES)) {
                VirtualFile sourceFile = sourceRoot.findFileByRelativePath(relativePath);
                if (sourceFile == null) continue;
                otherSourceRoots.add(sourceFile);
            }
        }
        outSourceRoots.addAll(otherSourceRoots);
    }

    @NotNull
    static SearchScope getScopeFromModel(@NotNull Project project, @NotNull FindModel findModel) {
        Module module;
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(44);
        }
        if (findModel == null) {
            FindInProjectUtil.$$$reportNull$$$0(45);
        }
        SearchScope customScope = findModel.isCustomScope() ? findModel.getCustomScope() : null;
        VirtualFile directory = FindInProjectUtil.getDirectory(findModel);
        Module module2 = module = findModel.getModuleName() == null ? null : ModuleManager.getInstance((Project)project).findModuleByName(findModel.getModuleName());
        Object object = customScope != null ? customScope : (directory != null ? FindInProjectUtil.forDirectory(project, findModel.isWithSubdirectories(), directory) : (module != null ? module.getModuleContentScope() : (findModel.isProjectScope() ? ProjectScope.getContentScope((Project)project) : GlobalSearchScope.allScope((Project)project))));
        if (object == null) {
            FindInProjectUtil.$$$reportNull$$$0(46);
        }
        return object;
    }

    @NotNull
    private static GlobalSearchScope forDirectory(@NotNull Project project, boolean withSubdirectories, @NotNull VirtualFile directory) {
        if (project == null) {
            FindInProjectUtil.$$$reportNull$$$0(47);
        }
        if (directory == null) {
            FindInProjectUtil.$$$reportNull$$$0(48);
        }
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        result2.add(directory);
        FindInProjectUtil.addSourceDirectoriesFromLibraries(project, directory, result2);
        VirtualFile[] array2 = result2.toArray(VirtualFile.EMPTY_ARRAY);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)withSubdirectories, (VirtualFile[])array2);
        if (globalSearchScope == null) {
            FindInProjectUtil.$$$reportNull$$$0(49);
        }
        return globalSearchScope;
    }

    public static void initFileFilter(@NotNull JComboBox<? super String> fileFilter, @NotNull JCheckBox useFileFilter) {
        if (fileFilter == null) {
            FindInProjectUtil.$$$reportNull$$$0(50);
        }
        if (useFileFilter == null) {
            FindInProjectUtil.$$$reportNull$$$0(51);
        }
        fileFilter.setEditable(true);
        String[] fileMasks = FindSettings.getInstance().getRecentFileMasks();
        for (int i2 = fileMasks.length - 1; i2 >= 0; --i2) {
            fileFilter.addItem(fileMasks[i2]);
        }
        fileFilter.setEnabled(false);
        useFileFilter.addActionListener(__ -> {
            if (useFileFilter.isSelected()) {
                fileFilter.setEnabled(true);
                fileFilter.getEditor().selectAll();
                fileFilter.getEditor().getEditorComponent().requestFocusInWindow();
            } else {
                fileFilter.setEnabled(false);
            }
        });
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public static String getPresentableName(@NotNull FindModel.SearchContext searchContext) {
        if (searchContext == null) {
            FindInProjectUtil.$$$reportNull$$$0(52);
        }
        @PropertyKey(resourceBundle="messages.FindBundle") String messageKey = null;
        switch (searchContext) {
            case ANY: {
                messageKey = "find.context.anywhere.scope.label";
                break;
            }
            case EXCEPT_COMMENTS: {
                messageKey = "find.context.except.comments.scope.label";
                break;
            }
            case EXCEPT_STRING_LITERALS: {
                messageKey = "find.context.except.literals.scope.label";
                break;
            }
            case EXCEPT_COMMENTS_AND_STRING_LITERALS: {
                messageKey = "find.context.except.comments.and.literals.scope.label";
                break;
            }
            case IN_COMMENTS: {
                messageKey = "find.context.in.comments.scope.label";
                break;
            }
            case IN_STRING_LITERALS: {
                messageKey = "find.context.in.literals.scope.label";
            }
        }
        String string = FindBundle.message(messageKey, new Object[0]);
        if (string == null) {
            FindInProjectUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 23: 
            case 26: 
            case 33: 
            case 36: 
            case 39: 
            case 46: 
            case 49: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 23: 
            case 26: 
            case 33: 
            case 36: 
            case 39: 
            case 46: 
            case 49: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 15: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 3: 
            case 23: 
            case 26: 
            case 33: 
            case 36: 
            case 39: 
            case 46: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindInProjectUtil";
                break;
            }
            case 5: 
            case 9: 
            case 29: 
            case 31: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToStart";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetRef";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToFind";
                break;
            }
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSourceRoots";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFilter";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useFileFilter";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindInProjectUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileMaskCondition";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleForScope";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setupViewPresentation";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "setupProcessPresentation";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "extractStringToFind";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStringToFindForIndicesFromRegExp";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeFromModel";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "forDirectory";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 3: 
            case 23: 
            case 26: 
            case 33: 
            case 36: 
            case 39: 
            case 46: 
            case 49: 
            case 53: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processSomeOccurrencesInFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTitleForScope";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setupViewPresentation";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupProcessPresentation";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "extractStringToFind";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildStringToFindForIndicesFromRegExp";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "initStringToFindFromDataContext";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addSourceDirectoriesFromLibraries";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getScopeFromModel";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "forDirectory";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "initFileFilter";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 23: 
            case 26: 
            case 33: 
            case 36: 
            case 39: 
            case 46: 
            case 49: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StringUsageTarget
    implements ConfigurableUsageTarget,
    ItemPresentation,
    DataProvider {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final FindModel myFindModel;

        public StringUsageTarget(@NotNull Project project, @NotNull FindModel findModel) {
            if (project == null) {
                StringUsageTarget.$$$reportNull$$$0(0);
            }
            if (findModel == null) {
                StringUsageTarget.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFindModel = findModel.clone();
        }

        @NotNull
        public String getPresentableText() {
            UsageViewPresentation presentation2 = FindInProjectUtil.setupViewPresentation(false, this.myFindModel);
            String string = presentation2.getToolwindowTitle();
            if (string == null) {
                StringUsageTarget.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getLongDescriptiveName() {
            String string = this.getPresentableText();
            if (string == null) {
                StringUsageTarget.$$$reportNull$$$0(3);
            }
            return string;
        }

        public Icon getIcon(boolean open2) {
            return AllIcons.Actions.Find;
        }

        public void findUsages() {
            FindInProjectManager.getInstance(this.myProject).startFindInProject(this.myFindModel);
        }

        public boolean isValid() {
            return true;
        }

        public String getName() {
            return this.myFindModel.getStringToFind().isEmpty() ? this.myFindModel.getFileFilter() : this.myFindModel.getStringToFind();
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public void navigate(boolean requestFocus) {
            throw new UnsupportedOperationException();
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public void showSettings() {
            Content selectedContent = UsageViewContentManager.getInstance((Project)this.myProject).getSelectedContent(true);
            JComponent component2 = selectedContent == null ? null : selectedContent.getComponent();
            FindInProjectManager findInProjectManager = FindInProjectManager.getInstance(this.myProject);
            findInProjectManager.findInProject(DataManager.getInstance().getDataContext((Component)component2), this.myFindModel);
        }

        public KeyboardShortcut getShortcut() {
            return ActionManager.getInstance().getKeyboardShortcut("FindInPath");
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                StringUsageTarget.$$$reportNull$$$0(4);
            }
            if (UsageView.USAGE_SCOPE.is(dataId)) {
                return FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "findModel";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLongDescriptiveName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

