/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target.wizard;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u000b\u001a\u00020\f2\u0011\u0010\r\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\u000f0\u000eH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00112\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/wsl/target/wizard/WslTargetIntrospectable;", "Lcom/intellij/execution/target/LanguageRuntimeType$Introspectable;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "(Lcom/intellij/execution/wsl/WSLDistribution;Lcom/intellij/execution/ui/ConsoleView;)V", "getConsole", "()Lcom/intellij/execution/ui/ConsoleView;", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "executeCommand", "", "cmd", "", "Lcom/intellij/openapi/util/NlsSafe;", "promiseEnvironmentVariable", "Ljava/util/concurrent/CompletableFuture;", "varName", "promiseExecuteScript", "script", "Companion", "intellij.platform.execution.impl"})
public final class WslTargetIntrospectable
extends LanguageRuntimeType.Introspectable {
    @NotNull
    private final WSLDistribution distribution;
    @NotNull
    private final ConsoleView console;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public CompletableFuture<String> promiseEnvironmentVariable(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        try {
            String value2 = this.distribution.getEnvironmentVariable(varName);
            this.console.print(varName + '=' + value2 + "\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(value2);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(value)");
            return completableFuture;
        }
        catch (Throwable t) {
            CompletableFuture<String> completableFuture = CompletableFuture.failedFuture(t);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failedFuture(t)");
            return completableFuture;
        }
    }

    @NotNull
    public CompletableFuture<String> promiseExecuteScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        try {
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(this.executeCommand(StringsKt.split$default((CharSequence)script, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.comple\u2026mmand(script.split(\" \")))");
            return completableFuture;
        }
        catch (Throwable t) {
            CompletableFuture<String> completableFuture = CompletableFuture.failedFuture(t);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failedFuture(t)");
            return completableFuture;
        }
    }

    private final String executeCommand(List<String> cmd) {
        boolean executeCommandInShell = Intrinsics.areEqual(cmd, (Object)CollectionsKt.listOf((Object)"pwd")) ^ true;
        WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setExecuteCommandInShell(executeCommandInShell);
        Intrinsics.checkNotNullExpressionValue((Object)wSLCommandLineOptions, (String)"WSLCommandLineOptions().\u2026ll(executeCommandInShell)");
        WSLCommandLineOptions options2 = wSLCommandLineOptions;
        if (executeCommandInShell) {
            options2.setShellPath(this.distribution.getShellPath());
            options2.setExecuteCommandInInteractiveShell(true);
            options2.setExecuteCommandInLoginShell(true);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(cmd).withRedirectErrorStream(true);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(cmd).\u2026RedirectErrorStream(true)");
        GeneralCommandLine commandLine = generalCommandLine;
        this.distribution.patchCommandLine(commandLine, null, options2);
        KillableProcessHandler processHandler2 = new KillableProcessHandler(commandLine);
        this.console.attachToProcess((ProcessHandler)processHandler2);
        ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler2).runProcess(10000);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessRunner(p\u2026ndler).runProcess(10_000)");
        ProcessOutput output2 = processOutput;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Command " + cmd + " finished: " + "stdout=" + output2.getStdout() + ", stderr=" + output2.getStderr() + ", " + "timeout=" + output2.isTimeout() + ", exitCode=" + output2.getExitCode());
        }
        boolean success2 = !output2.isTimeout() && output2.getExitCode() == 0;
        this.console.print(IdeBundle.message((String)"wsl.target.introspection.step.command.finished.with.exit.code", (Object[])new Object[]{output2.getExitCode()}) + "\n\n", success2 ? ConsoleViewContentType.SYSTEM_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT);
        if (success2) {
            String string = output2.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.stdout");
            return string;
        }
        throw (Throwable)new Exception(IdeBundle.message((String)"wsl.target.introspection.step.command.finished.with.exit.code", (Object[])new Object[]{output2.getExitCode()}));
    }

    @NotNull
    public final WSLDistribution getDistribution() {
        return this.distribution;
    }

    @NotNull
    public final ConsoleView getConsole() {
        return this.console;
    }

    public WslTargetIntrospectable(@NotNull WSLDistribution distribution2, @NotNull ConsoleView console2) {
        Intrinsics.checkNotNullParameter((Object)distribution2, (String)"distribution");
        Intrinsics.checkNotNullParameter((Object)console2, (String)"console");
        this.distribution = distribution2;
        this.console = console2;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WslTargetIntrospectable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/wsl/target/wizard/WslTargetIntrospectable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

