/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNodeKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/dvcs/repo/Repository;", "repository", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "(Lcom/intellij/dvcs/repo/Repository;Lcom/intellij/vcs/log/ui/VcsLogColorManager;)V", "appendCurrentBranch", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "compareUserObjects", "", "o2", "getSortWeight", "getTextPresentation", "", "render", "selected", "", "expanded", "hasFocus", "Companion", "intellij.platform.vcs.dvcs.impl"})
public final class RepositoryChangesBrowserNode
extends ChangesBrowserNode<Repository> {
    private final VcsLogColorManager colorManager;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer2), (String)"renderer");
        Object t = this.getUserObject();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getUserObject()");
        renderer2.setIcon((Icon)Companion.getRepositoryIcon((Repository)t, this.colorManager));
        renderer2.append(' ' + this.getTextPresentation(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount(renderer2);
        if (renderer2.isShowingLocalChanges()) {
            this.appendCurrentBranch(renderer2);
        }
    }

    private final void appendCurrentBranch(ChangesBrowserNodeRenderer renderer2) {
        Repository repository;
        Repository repository2 = repository = (Repository)this.getUserObject();
        Intrinsics.checkNotNullExpressionValue((Object)repository2, (String)"repository");
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
        VirtualFile virtualFile2 = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"repository.root");
        BranchData branch = CurrentBranchComponent.Companion.getCurrentBranch(project, virtualFile2);
        if (branch != null) {
            renderer2.append(FontUtil.spaceAndThinSpace());
            String string = ' ' + BranchPresentation.INSTANCE.getPresentableText(branch) + ' ';
            Color color = renderer2.getBackground();
            if (color == null) {
                Color color2 = UIUtil.getTreeBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getTreeBackground()");
            }
            renderer2.append(string, RepositoryChangesBrowserNodeKt.access$getBranchLabelAttributes(color));
            renderer2.setBackgroundInsets(RepositoryChangesBrowserNodeKt.access$getBRANCH_BACKGROUND_INSETS$p());
            renderer2.setToolTipText(BranchPresentation.INSTANCE.getSingleTooltip(branch));
        }
    }

    @Override
    public int getSortWeight() {
        return 3;
    }

    @Override
    public int compareUserObjects(@NotNull Repository o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return RepositoryChangesBrowserNode.access$compareFileNames$s-273927513(DvcsUtil.getShortRepositoryName((Repository)this.getUserObject()), DvcsUtil.getShortRepositoryName(o2));
    }

    @Override
    @NotNull
    public String getTextPresentation() {
        String string = DvcsUtil.getShortRepositoryName((Repository)this.getUserObject());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortRepositoryName(getUserObject())");
        return string;
    }

    public RepositoryChangesBrowserNode(@NotNull Repository repository, @NotNull VcsLogColorManager colorManager) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
        super(repository);
        this.colorManager = colorManager;
    }

    public /* synthetic */ RepositoryChangesBrowserNode(Repository repository, VcsLogColorManager vcsLogColorManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
            vcsLogColorManager = Companion.getColorManager(project);
        }
        this(repository, vcsLogColorManager);
    }

    public static final /* synthetic */ int access$compareFileNames$s-273927513(String p0, String p1) {
        return ChangesBrowserNode.compareFileNames(p0, p1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode$Companion;", "", "()V", "getColorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "getRepositoryIcon", "Lcom/intellij/util/ui/ColorIcon;", "repository", "Lcom/intellij/dvcs/repo/Repository;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "intellij.platform.vcs.dvcs.impl"})
    public static final class Companion {
        @NotNull
        public final VcsLogColorManagerImpl getColorManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
            Object object = vcsProjectLog.getLogManager();
            if (object == null || (object = ((VcsLogManager)object).getColorManager()) == null) {
                ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
                Object[] objectArray = projectLevelVcsManager.getAllVcsRoots();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ProjectLevelVcsManager.g\u2026ance(project).allVcsRoots");
                object = new VcsLogColorManagerImpl(VcsLogManager.findLogProviders(ArraysKt.asList((Object[])objectArray), project).keySet());
            }
            return object;
        }

        @NotNull
        public final ColorIcon getRepositoryIcon(@NotNull Repository repository, @NotNull VcsLogColorManager colorManager) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
            return new ColorIcon(RepositoryChangesBrowserNodeKt.access$getICON_SIZE$p(), (Color)VcsLogColorManagerImpl.getBackgroundColor(colorManager.getRootColor(repository.getRoot())));
        }

        public static /* synthetic */ ColorIcon getRepositoryIcon$default(Companion companion, Repository repository, VcsLogColorManager vcsLogColorManager, int n, Object object) {
            if ((n & 2) != 0) {
                Project project = repository.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
                vcsLogColorManager = companion.getColorManager(project);
            }
            return companion.getRepositoryIcon(repository, vcsLogColorManager);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

