/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.documentation.mdn;

import com.intellij.documentation.mdn.MdnApiStatus;
import com.intellij.documentation.mdn.MdnDocumentation;
import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnJavaScriptRuntime;
import com.intellij.documentation.mdn.MdnRawSymbolDocumentation;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.documentation.mdn.MdnSymbolDocumentationAdapter;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J \u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000f2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0016J\f\u0010\u001d\u001a\u00020\u0003*\u00020\u0003H\u0002R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/documentation/mdn/MdnSymbolDocumentationAdapter;", "Lcom/intellij/documentation/mdn/MdnSymbolDocumentation;", "name", "", "source", "Lcom/intellij/documentation/mdn/MdnDocumentation;", "doc", "Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;", "(Ljava/lang/String;Lcom/intellij/documentation/mdn/MdnDocumentation;Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;)V", "description", "getDescription", "()Ljava/lang/String;", "footnote", "getFootnote", "isDeprecated", "", "()Z", "getName", "sections", "", "getSections", "()Ljava/util/Map;", "url", "getUrl", "getDocumentation", "withDefinition", "additionalSectionsContent", "Ljava/util/function/Consumer;", "Ljava/lang/StringBuilder;", "fixUrls", "intellij.xml.psi.impl"})
public final class MdnSymbolDocumentationAdapter
implements MdnSymbolDocumentation {
    @NotNull
    private final String name;
    private final MdnDocumentation source;
    private final MdnRawSymbolDocumentation doc;

    @Override
    @NotNull
    public String getUrl() {
        return MdnDocumentationKt.access$fixMdnUrls(this.doc.getUrl(), this.source.getLang());
    }

    @Override
    public boolean isDeprecated() {
        Set<MdnApiStatus> set2 = this.doc.getStatus();
        return set2 != null && set2.contains((Object)MdnApiStatus.Deprecated);
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.doc.getDoc();
        if (string == null) {
            string = "";
        }
        String string2 = StringUtil.capitalize((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(doc.doc ?: \"\")");
        return this.fixUrls(string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> getSections() {
        void $this$mapValuesTo$iv$iv;
        Sequence sequence;
        String string;
        Map map2;
        String string2;
        Map result2 = MapsKt.toMutableMap(this.doc.getSections());
        if (this.doc.getCompatibility() != null) {
            CharSequence charSequence;
            Map map3 = result2;
            String string3 = "Supported by:";
            Map<MdnJavaScriptRuntime, String> map4 = this.doc.getCompatibility();
            Intrinsics.checkNotNull(map4);
            CharSequence charSequence2 = CollectionsKt.joinToString$default((Iterable)map4.entrySet(), (CharSequence)", ", null, null, (int)0, null, (Function1)sections.1.INSTANCE, (int)30, null);
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                string2 = string3;
                map2 = map3;
                boolean bl2 = false;
                string = "none";
                map3 = map2;
                string3 = string2;
                charSequence = string;
            } else {
                charSequence = charSequence2;
            }
            map3.put(string3, charSequence);
        }
        if ((sequence = this.doc.getStatus()) != null && (sequence = CollectionsKt.asSequence((Iterable)((Iterable)sequence))) != null && (sequence = SequencesKt.filter((Sequence)sequence, (Function1)sections.3.INSTANCE)) != null && (sequence = SequencesKt.map((Sequence)sequence, (Function1)sections.4.INSTANCE)) != null) {
            MapsKt.toMap((Sequence)sequence, (Map)result2);
        }
        Map $this$mapValues$iv = result2;
        boolean $i$f$mapValues = false;
        Map bl2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$value;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map5 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            string2 = k;
            map2 = map5;
            boolean bl3 = false;
            void var17_21 = $dstr$_u24__u24$value;
            boolean bl4 = false;
            String value2 = (String)var17_21.getValue();
            string = this.fixUrls(value2);
            map2.put(string2, string);
        }
        return destination$iv$iv;
    }

    @Override
    @NotNull
    public String getFootnote() {
        return this.fixUrls("By <a href='" + this.doc.getUrl() + "/contributors.txt'>Mozilla Contributors</a>, <a href='https://creativecommons.org/licenses/by-sa/2.5/'>CC BY-SA 2.5</a>");
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition) {
        return this.getDocumentation(withDefinition, null);
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition, @Nullable Consumer<StringBuilder> additionalSectionsContent) {
        return MdnDocumentationKt.access$buildDoc(this, withDefinition, additionalSectionsContent);
    }

    private final String fixUrls(String $this$fixUrls) {
        CharSequence charSequence = $this$fixUrls;
        Regex regex = new Regex("<a[ \n\t]+href=[ \t]*['\"]#([^'\"]*)['\"]");
        String string = "<a href=\"" + Regex.Companion.escapeReplacement(this.doc.getUrl()) + "#$1\"";
        boolean bl = false;
        return MdnDocumentationKt.access$fixMdnUrls(regex.replace(charSequence, string), this.source.getLang());
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public MdnSymbolDocumentationAdapter(@NotNull String name, @NotNull MdnDocumentation source, @NotNull MdnRawSymbolDocumentation doc) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.name = name;
        this.source = source;
        this.doc = doc;
    }
}

