/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.execution.Executor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.util.execution.ParametersListUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalIgnoreDependencyViolation
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0016J0\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diff/actions/DiffCustomCommandHandler;", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "", "localSession", "command", "executor", "Lcom/intellij/execution/Executor;", "matches", "parse", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "Companion", "intellij.platform.diff.impl"})
final class DiffCustomCommandHandler
implements TerminalShellCommandHandler {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Pair<Path, Path> parameters2 = this.parse(workingDirectory, localSession, command);
        if (parameters2 == null) {
            LOG.warn("Command " + command + " should be matched and properly parsed");
            return false;
        }
        VirtualFile file1 = LocalFileSystem.getInstance().findFileByIoFile(((Path)parameters2.getFirst()).toFile());
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(((Path)parameters2.getSecond()).toFile());
        if (file1 == null || file2 == null) {
            LOG.warn("Cannot find virtual file for one of the paths: " + file1 + ", " + file2);
            return false;
        }
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)BaseShowDiffAction.createMutableChainFromFiles(project, file1, file2), DiffDialogHints.DEFAULT);
        return true;
    }

    @Override
    public boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return this.parse(workingDirectory, localSession, command) != null;
    }

    private final Pair<Path, Path> parse(String workingDirectory, boolean localSession, String command) {
        if (!StringsKt.startsWith$default((String)command, (String)"diff ", (boolean)false, (int)2, null) || !localSession) {
            return null;
        }
        if (workingDirectory == null) {
            return null;
        }
        List list2 = ParametersListUtil.parse((String)command);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ParametersListUtil.parse(command)");
        List commands = list2;
        if (commands.size() < 3) {
            return null;
        }
        Path path1 = Paths.get(workingDirectory, (String)commands.get(1));
        Path path2 = Paths.get(workingDirectory, (String)commands.get(2));
        boolean file1Exists = Files.exists(path1, new LinkOption[0]);
        boolean file2Exists = Files.exists(path2, new LinkOption[0]);
        if (!file1Exists || !file2Exists) {
            return null;
        }
        return new Pair((Object)path1, (Object)path2);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DiffCustomCommandHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(DiffC\u2026mmandHandler::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diff/actions/DiffCustomCommandHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

