/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

class SettingsXmlFile
implements ComponentManagerSettings,
WorkspaceSettings {
    private static final Document EMPTY_DOCUMENT = new Document(new Element("root"));
    private final Path file;
    @Nullable
    private Document document;

    SettingsXmlFile(@NotNull Path file2) throws CannotConvertException {
        if (file2 == null) {
            SettingsXmlFile.$$$reportNull$$$0(0);
        }
        this.file = file2;
    }

    @NotNull
    public Path getFile() {
        Path path2 = this.file;
        if (path2 == null) {
            SettingsXmlFile.$$$reportNull$$$0(1);
        }
        return path2;
    }

    @Override
    public Element getComponentElement(@NotNull @NonNls String componentName) {
        if (componentName == null) {
            SettingsXmlFile.$$$reportNull$$$0(2);
        }
        return this.findComponent(componentName);
    }

    @Override
    @NotNull
    public Path getPath() {
        Path path2 = this.file;
        if (path2 == null) {
            SettingsXmlFile.$$$reportNull$$$0(3);
        }
        return path2;
    }

    @NotNull
    private Document getDocument() {
        Document result2 = this.document;
        if (result2 == null) {
            try {
                result2 = JDOMUtil.loadDocument((InputStream)CharsetToolkit.inputStreamSkippingBOM((InputStream)new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]))));
            }
            catch (NoSuchFileException e) {
                result2 = EMPTY_DOCUMENT;
            }
            catch (IOException | JDOMException e) {
                this.document = EMPTY_DOCUMENT;
                throw new CannotConvertException("Cannot load " + this.file, e);
            }
            this.document = result2;
        }
        Document document = result2;
        if (document == null) {
            SettingsXmlFile.$$$reportNull$$$0(4);
        }
        return document;
    }

    @Override
    @NotNull
    public Element getRootElement() {
        Element element2 = this.getDocument().getRootElement();
        if (element2 == null) {
            SettingsXmlFile.$$$reportNull$$$0(5);
        }
        return element2;
    }

    public void save() throws IOException {
        if (this.document == null || this.document == EMPTY_DOCUMENT) {
            return;
        }
        Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            JDOMUtil.writeDocument((Document)this.getDocument(), (Writer)writer, (String)System.lineSeparator());
        }
    }

    @Nullable
    public Element findComponent(@NotNull String componentName) {
        if (componentName == null) {
            SettingsXmlFile.$$$reportNull$$$0(6);
        }
        return this.document == EMPTY_DOCUMENT ? null : JDomSerializationUtil.findComponent((Element)this.getDocument().getRootElement(), (String)componentName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/SettingsXmlFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/SettingsXmlFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

