/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.ui;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ui.AccountsListModel;
import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.ui.CollectionListModel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010$\u001a\u00020\u00192\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00190\u0018J\b\u0010&\u001a\u00020\u0019H\u0016J\u0015\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u001eR0\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00190\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0004\u0018\u00018\u0000X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR \u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006)"}, d2={"Lcom/intellij/collaboration/auth/ui/AccountsListModelBase;", "A", "Lcom/intellij/collaboration/auth/Account;", "Cred", "Lcom/intellij/collaboration/auth/ui/AccountsListModel;", "()V", "value", "", "accounts", "getAccounts", "()Ljava/util/Set;", "setAccounts", "(Ljava/util/Set;)V", "accountsListModel", "Lcom/intellij/ui/CollectionListModel;", "getAccountsListModel", "()Lcom/intellij/ui/CollectionListModel;", "busyStateModel", "Lcom/intellij/collaboration/ui/SingleValueModel;", "", "getBusyStateModel", "()Lcom/intellij/collaboration/ui/SingleValueModel;", "credentialsChangesListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lkotlin/Function1;", "", "defaultAccount", "getDefaultAccount", "()Lcom/intellij/collaboration/auth/Account;", "setDefaultAccount", "(Lcom/intellij/collaboration/auth/Account;)V", "Lcom/intellij/collaboration/auth/Account;", "newCredentials", "", "getNewCredentials", "()Ljava/util/Map;", "addCredentialsChangeListener", "listener", "clearNewCredentials", "notifyCredentialsChanged", "account", "intellij.platform.collaborationTools"})
public abstract class AccountsListModelBase<A extends Account, Cred>
implements AccountsListModel<A, Cred> {
    @Nullable
    private A defaultAccount;
    @NotNull
    private final Map<A, Cred> newCredentials;
    @NotNull
    private final CollectionListModel<A> accountsListModel;
    @NotNull
    private final SingleValueModel<Boolean> busyStateModel;
    private final CopyOnWriteArrayList<Function1<A, Unit>> credentialsChangesListeners;

    @Override
    @NotNull
    public Set<A> getAccounts() {
        List list2 = this.getAccountsListModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"accountsListModel.items");
        return CollectionsKt.toSet((Iterable)list2);
    }

    @Override
    public void setAccounts(@NotNull Set<? extends A> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.getAccountsListModel().removeAll();
        this.getAccountsListModel().add(CollectionsKt.toList((Iterable)value2));
    }

    @Override
    @Nullable
    public A getDefaultAccount() {
        return this.defaultAccount;
    }

    @Override
    public void setDefaultAccount(@Nullable A a) {
        this.defaultAccount = a;
    }

    @Override
    @NotNull
    public Map<A, Cred> getNewCredentials() {
        return this.newCredentials;
    }

    @Override
    @NotNull
    public CollectionListModel<A> getAccountsListModel() {
        return this.accountsListModel;
    }

    @Override
    @NotNull
    public SingleValueModel<Boolean> getBusyStateModel() {
        return this.busyStateModel;
    }

    @Override
    public void clearNewCredentials() {
        this.getNewCredentials().clear();
    }

    protected final void notifyCredentialsChanged(@NotNull A account) {
        Intrinsics.checkNotNullParameter(account, (String)"account");
        Iterable $this$forEach$iv = this.credentialsChangesListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke(account);
        }
        this.getAccountsListModel().contentsChanged(account);
    }

    @Override
    public final void addCredentialsChangeListener(@NotNull Function1<? super A, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.credentialsChangesListeners.add(listener2);
    }

    public AccountsListModelBase() {
        boolean bl = false;
        this.newCredentials = new LinkedHashMap();
        this.accountsListModel = new CollectionListModel((Object[])new Account[0]);
        this.busyStateModel = new SingleValueModel<Boolean>(false);
        this.credentialsChangesListeners = new CopyOnWriteArrayList();
    }
}

