/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateStorage;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplateWithMultipleExpressions;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PostfixTemplatesUtils {
    public static final String CONDITION_TAG = "condition";
    public static final String CONDITIONS_TAG = "conditions";
    public static final String TOPMOST_ATTR = "topmost";

    private PostfixTemplatesUtils() {
    }

    @NotNull
    public static Set<PostfixTemplate> getAvailableTemplates(@NotNull PostfixTemplateProvider provider2) {
        if (provider2 == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(0);
        }
        HashSet<PostfixTemplate> result2 = new HashSet<PostfixTemplate>(provider2.getTemplates());
        for (PostfixTemplate template : PostfixTemplateStorage.getInstance().getTemplates(provider2)) {
            if (template instanceof PostfixChangedBuiltinTemplate) {
                result2.remove(((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate());
            }
            result2.add(template);
        }
        HashSet<PostfixTemplate> hashSet = result2;
        if (hashSet == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Nullable
    public static TextRange surround(@NotNull Surrounder surrounder, @NotNull Editor editor, @NotNull PsiElement expr) {
        if (surrounder == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(3);
        }
        if (expr == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(4);
        }
        Project project = expr.getProject();
        PsiElement[] elements = new PsiElement[]{expr};
        if (surrounder.isApplicable(elements)) {
            return surrounder.surroundElements(project, editor, elements);
        }
        PostfixTemplatesUtils.showErrorHint(project, editor);
        return null;
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(6);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CodeInsightBundle.message((String)"error.hint.can.t.expand.postfix.template", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"error.hint.can.t.expand.postfix.template", (Object[])new Object[0]), (String)"");
    }

    @NotNull
    public static String generateTemplateId(@NotNull String templateKey, @NotNull PostfixTemplateProvider provider2) {
        if (templateKey == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(7);
        }
        if (provider2 == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(8);
        }
        HashSet<String> usedIds = new HashSet<String>();
        for (PostfixTemplate builtinTemplate : provider2.getTemplates()) {
            usedIds.add(builtinTemplate.getId());
        }
        for (PostfixTemplate template : PostfixTemplateStorage.getInstance().getTemplates(provider2)) {
            usedIds.add(template.getId());
        }
        String string = UniqueNameGenerator.generateUniqueName((String)(templateKey + "@userDefined"), usedIds);
        if (string == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static void writeExternalTemplate(@NotNull PostfixTemplate template, @NotNull Element parentElement) {
        if (template == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(10);
        }
        if (parentElement == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(11);
        }
        if (template instanceof EditablePostfixTemplateWithMultipleExpressions) {
            parentElement.setAttribute(TOPMOST_ATTR, String.valueOf(((EditablePostfixTemplateWithMultipleExpressions)template).isUseTopmostExpression()));
            Element conditionsTag = new Element(CONDITIONS_TAG);
            Set conditions = ((EditablePostfixTemplateWithMultipleExpressions)template).getExpressionConditions();
            for (PostfixTemplateExpressionCondition condition2 : conditions) {
                Element element2 = new Element(CONDITION_TAG);
                condition2.serializeTo(element2);
                conditionsTag.addContent(element2);
            }
            parentElement.addContent(conditionsTag);
        }
        Element templateTag = TemplateSettings.serializeTemplate(((EditablePostfixTemplate)template).getLiveTemplate(), null, (Lazy<Map<String, TemplateContextType>>)LazyKt.lazyOf(Collections.emptyMap()));
        parentElement.addContent(templateTag);
    }

    @NotNull
    public static <T extends PostfixTemplateExpressionCondition> Set<T> readExternalConditions(@NotNull Element template, @NotNull Function<? super Element, ? extends T> conditionFactory) {
        Element conditionsElement;
        if (template == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(12);
        }
        if (conditionFactory == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(13);
        }
        if ((conditionsElement = template.getChild(CONDITIONS_TAG)) != null) {
            LinkedHashSet conditions = new LinkedHashSet();
            for (Element conditionElement : conditionsElement.getChildren(CONDITION_TAG)) {
                PostfixTemplateExpressionCondition fun = (PostfixTemplateExpressionCondition)conditionFactory.fun((Object)conditionElement);
                if (fun == null) continue;
                ContainerUtil.addIfNotNull(conditions, (Object)fun);
            }
            LinkedHashSet linkedHashSet = conditions;
            if (linkedHashSet == null) {
                PostfixTemplatesUtils.$$$reportNull$$$0(14);
            }
            return linkedHashSet;
        }
        Set set2 = Collections.emptySet();
        if (set2 == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(15);
        }
        return set2;
    }

    @Nullable
    public static TemplateImpl readExternalLiveTemplate(@NotNull Element template, @NotNull PostfixTemplateProvider provider2) {
        Element templateChild;
        if (template == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(16);
        }
        if (provider2 == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(17);
        }
        if ((templateChild = template.getChild("template")) == null) {
            return null;
        }
        return TemplateSettings.readTemplateFromElement("", templateChild, provider2.getClass().getClassLoader());
    }

    public static boolean readExternalTopmostAttribute(@NotNull Element template) {
        if (template == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(18);
        }
        return Boolean.parseBoolean(template.getAttributeValue(TOPMOST_ATTR));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surrounder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateKey";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTemplates";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTemplateId";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternalConditions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTemplates";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateTemplateId";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeExternalTemplate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readExternalConditions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readExternalLiveTemplate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readExternalTopmostAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

