/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetAbbreviationBalloon;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetLexer;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.FilterNode;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.TextNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZenCodingTemplate
extends CustomLiveTemplateBase {
    public static final char MARKER = '\u0000';
    private static final String EMMET_RECENT_WRAP_ABBREVIATIONS_KEY = "emmet.recent.wrap.abbreviations";
    private static final String EMMET_LAST_WRAP_ABBREVIATIONS_KEY = "emmet.last.wrap.abbreviations";
    private static final Logger LOG = Logger.getInstance(ZenCodingTemplate.class);
    private static final EmmetAbbreviationBalloon.EmmetContextHelp CONTEXT_HELP = new EmmetAbbreviationBalloon.EmmetContextHelp(XmlBundle.messagePointer((String)"zen.coding.context.help.tooltip", (Object[])new Object[0]), XmlBundle.messagePointer((String)"zen.coding.context.help.link", (Object[])new Object[0]), "https://docs.emmet.io/actions/wrap-with-abbreviation/");

    @Nullable
    public static ZenCodingGenerator findApplicableDefaultGenerator(@NotNull CustomTemplateCallback callback2, boolean wrapping) {
        PsiElement context2;
        if (callback2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(0);
        }
        if (!(context2 = callback2.getContext()).isValid()) {
            return null;
        }
        for (ZenCodingGenerator generator2 : ZenCodingGenerator.getInstances()) {
            if (!generator2.isMyContext(callback2, wrapping) || !generator2.isAppliedByDefault(context2)) continue;
            return generator2;
        }
        return null;
    }

    @Nullable
    public static ZenCodingNode parse(@NotNull String text2, @NotNull CustomTemplateCallback callback2, @NotNull ZenCodingGenerator generator2, @Nullable String surroundedText) {
        List<ZenCodingToken> tokens;
        if (text2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(1);
        }
        if (callback2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(2);
        }
        if (generator2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(3);
        }
        if ((tokens = new EmmetLexer().lex(text2)) == null) {
            return null;
        }
        if (!ZenCodingTemplate.validate(tokens, generator2)) {
            return null;
        }
        EmmetParser parser = generator2.createParser(tokens, callback2, generator2, surroundedText != null);
        ZenCodingNode node2 = parser.parse();
        if (parser.getIndex() != tokens.size() || node2 instanceof TextNode) {
            return null;
        }
        return node2;
    }

    private static boolean validate(@NotNull List<ZenCodingToken> tokens, @NotNull ZenCodingGenerator generator2) {
        if (tokens == null) {
            ZenCodingTemplate.$$$reportNull$$$0(4);
        }
        if (generator2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(5);
        }
        for (ZenCodingToken token2 : tokens) {
            if (!(token2 instanceof TextToken) || generator2 instanceof XmlZenCodingGenerator) continue;
            return false;
        }
        return true;
    }

    public static boolean checkTemplateKey(@NotNull String key, CustomTemplateCallback callback2, @NotNull ZenCodingGenerator generator2) {
        if (key == null) {
            ZenCodingTemplate.$$$reportNull$$$0(6);
        }
        if (generator2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(7);
        }
        return ZenCodingTemplate.parse(key, callback2, generator2, null) != null;
    }

    @Override
    public void expand(@NotNull String key, @NotNull CustomTemplateCallback callback2) {
        ZenCodingGenerator defaultGenerator;
        if (key == null) {
            ZenCodingTemplate.$$$reportNull$$$0(8);
        }
        if (callback2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(9);
        }
        if ((defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback2, false)) == null) {
            LOG.error("Cannot find defaultGenerator for key `" + key + "` at " + callback2.getEditor().getCaretModel().getOffset() + " offset", new Attachment[]{AttachmentFactory.createAttachment(callback2.getEditor().getDocument())});
            return;
        }
        try {
            ZenCodingTemplate.expand(key, callback2, defaultGenerator, Collections.emptyList(), true, Registry.intValue((String)"emmet.segments.limit"));
        }
        catch (EmmetException e) {
            CommonRefactoringUtil.showErrorHint((Project)callback2.getProject(), (Editor)callback2.getEditor(), (String)e.getMessage(), (String)XmlBundle.message((String)"emmet.error", (Object[])new Object[0]), (String)"");
        }
    }

    @Nullable
    private static ZenCodingGenerator findApplicableGenerator(ZenCodingNode node2, CustomTemplateCallback callback2, boolean wrapping) {
        ZenCodingGenerator defaultGenerator = null;
        List<ZenCodingGenerator> generators = ZenCodingGenerator.getInstances();
        PsiElement context2 = callback2.getContext();
        for (ZenCodingGenerator generator2 : generators) {
            if (!generator2.isMyContext(callback2, wrapping) || !generator2.isAppliedByDefault(context2)) continue;
            defaultGenerator = generator2;
            break;
        }
        while (node2 instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node2;
            String suffix = filterNode.getFilter();
            for (ZenCodingGenerator generator3 : generators) {
                if (!generator3.isMyContext(callback2, wrapping) || suffix == null || !suffix.equals(generator3.getSuffix())) continue;
                return generator3;
            }
            node2 = filterNode.getNode();
        }
        return defaultGenerator;
    }

    @NotNull
    private static List<ZenCodingFilter> getFilters(ZenCodingNode node2, PsiElement context2) {
        ArrayList<ZenCodingFilter> result2 = new ArrayList<ZenCodingFilter>();
        while (node2 instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node2;
            String filterSuffix = filterNode.getFilter();
            for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
                if (!filter.isMyContext(context2) || !filter.getSuffix().equals(filterSuffix)) continue;
                result2.add(filter);
            }
            node2 = filterNode.getNode();
        }
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            if (!filter.isMyContext(context2) || !filter.isAppliedByDefault(context2)) continue;
            result2.add(filter);
        }
        Collections.reverse(result2);
        ArrayList<ZenCodingFilter> arrayList = result2;
        if (arrayList == null) {
            ZenCodingTemplate.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public static void expand(@NotNull String key, @NotNull CustomTemplateCallback callback2, @NotNull ZenCodingGenerator defaultGenerator, @NotNull Collection<? extends ZenCodingFilter> extraFilters, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        ZenCodingNode node2;
        if (key == null) {
            ZenCodingTemplate.$$$reportNull$$$0(11);
        }
        if (callback2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(12);
        }
        if (defaultGenerator == null) {
            ZenCodingTemplate.$$$reportNull$$$0(13);
        }
        if (extraFilters == null) {
            ZenCodingTemplate.$$$reportNull$$$0(14);
        }
        if ((node2 = ZenCodingTemplate.parse(key, callback2, defaultGenerator, null)) == null) {
            return;
        }
        if (node2 instanceof TemplateNode && key.equals(((TemplateNode)node2).getTemplateToken().getKey()) && callback2.findApplicableTemplates(key).size() > 1) {
            Map<TemplateImpl, String> template2Argument;
            TemplateManagerImpl templateManager = (TemplateManagerImpl)callback2.getTemplateManager();
            Runnable runnable2 = templateManager.startNonCustomTemplates(template2Argument = templateManager.findMatchingTemplates(callback2.getFile(), callback2.getEditor(), null, TemplateSettings.getInstance()), callback2.getEditor(), null);
            if (runnable2 != null) {
                runnable2.run();
            }
            return;
        }
        PsiElement context2 = callback2.getContext();
        ZenCodingGenerator generator2 = (ZenCodingGenerator)ObjectUtils.notNull((Object)ZenCodingTemplate.findApplicableGenerator(node2, callback2, false), (Object)defaultGenerator);
        List<ZenCodingFilter> filters = ZenCodingTemplate.getFilters(node2, context2);
        filters.addAll(extraFilters);
        ZenCodingTemplate.checkTemplateOutputLength(node2, callback2);
        callback2.deleteTemplateKey(key);
        ZenCodingTemplate.expand(node2, generator2, filters, null, callback2, expandPrimitiveAbbreviations, segmentsLimit);
    }

    private static void expand(ZenCodingNode node2, ZenCodingGenerator generator2, List<ZenCodingFilter> filters, String surroundedText, CustomTemplateCallback callback2, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        ZenCodingTemplate.checkTemplateOutputLength(node2, callback2);
        GenerationNode fakeParentNode = new GenerationNode(TemplateToken.EMPTY_TEMPLATE_TOKEN, -1, 1, surroundedText, true, null);
        node2.expand(-1, 1, surroundedText, callback2, true, fakeParentNode);
        if (!expandPrimitiveAbbreviations && ZenCodingTemplate.isPrimitiveNode(node2)) {
            return;
        }
        List<GenerationNode> genNodes = fakeParentNode.getChildren();
        LiveTemplateBuilder builder2 = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        int end = -1;
        int genNodesSize = genNodes.size();
        for (int i2 = 0; i2 < genNodesSize; ++i2) {
            GenerationNode genNode = genNodes.get(i2);
            TemplateImpl template = genNode.generate(callback2, generator2, filters, true, segmentsLimit);
            int e = builder2.insertTemplate(builder2.length(), template, null);
            if (i2 < genNodesSize - 1 && genNode.isInsertNewLineBetweenNodes()) {
                builder2.insertText(e, "\n", false);
                ++e;
            }
            if (end != -1 || end >= builder2.length()) continue;
            end = e;
        }
        for (ZenCodingFilter filter : filters) {
            if (!(filter instanceof SingleLineEmmetFilter)) continue;
            builder2.setIsToReformat(false);
            break;
        }
        callback2.startTemplate(builder2.buildTemplate(), null, null);
    }

    private static void checkTemplateOutputLength(ZenCodingNode node2, CustomTemplateCallback callback2) throws EmmetException {
        int predictedOutputLength = node2.getApproximateOutputLength(callback2);
        if (predictedOutputLength > 15360) {
            throw new EmmetException();
        }
    }

    private static boolean isPrimitiveNode(@NotNull ZenCodingNode node2) {
        TemplateToken token2;
        if (node2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(15);
        }
        if (node2 instanceof TemplateNode && (token2 = ((TemplateNode)node2).getTemplateToken()) != null) {
            Map<String, String> attributes2 = token2.getAttributes();
            return attributes2.isEmpty() || attributes2.containsKey("class") && StringUtil.isEmpty((String)attributes2.get("class"));
        }
        return false;
    }

    @Override
    public void wrap(@NotNull String selection, final @NotNull CustomTemplateCallback callback2) {
        if (selection == null) {
            ZenCodingTemplate.$$$reportNull$$$0(16);
        }
        if (callback2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(17);
        }
        new EmmetAbbreviationBalloon(EMMET_RECENT_WRAP_ABBREVIATIONS_KEY, EMMET_LAST_WRAP_ABBREVIATIONS_KEY, new EmmetAbbreviationBalloon.Callback(){

            @Override
            public void onEnter(@NotNull String abbreviation) {
                if (abbreviation == null) {
                    1.$$$reportNull$$$0(0);
                }
                ZenCodingTemplate.doWrap(abbreviation, callback2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate$1", "onEnter"));
            }
        }, CONTEXT_HELP).show(callback2);
    }

    public static boolean checkTemplateKey(String inputString, CustomTemplateCallback callback2) {
        ZenCodingGenerator generator2 = ZenCodingTemplate.findApplicableDefaultGenerator(callback2, true);
        if (generator2 == null) {
            int offset = callback2.getEditor().getCaretModel().getOffset();
            LOG.error("Emmet is disabled for context for file " + callback2.getFileType().getName() + " in offset: " + offset, new Attachment[]{AttachmentFactory.createAttachment(callback2.getEditor().getDocument())});
            return false;
        }
        return ZenCodingTemplate.checkTemplateKey(inputString, callback2, generator2);
    }

    @Override
    public boolean isApplicable(@NotNull CustomTemplateCallback callback2, int offset, boolean wrapping) {
        ZenCodingGenerator applicableGenerator;
        if (callback2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(18);
        }
        return (applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback2, wrapping)) != null && applicableGenerator.isEnabled();
    }

    @Override
    public boolean hasCompletionItem(@NotNull CustomTemplateCallback callback2, int offset) {
        ZenCodingGenerator applicableGenerator;
        if (callback2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(19);
        }
        return (applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback2, false)) != null && applicableGenerator.isEnabled() && applicableGenerator.hasCompletionItem();
    }

    public static void doWrap(@NotNull String abbreviation, @NotNull CustomTemplateCallback callback2) {
        if (abbreviation == null) {
            ZenCodingTemplate.$$$reportNull$$$0(20);
        }
        if (callback2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(21);
        }
        ZenCodingGenerator defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback2, true);
        assert (defaultGenerator != null);
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(callback2.getProject(), () -> callback2.getEditor().getCaretModel().runForEachCaret(__ -> {
            String selectedText = callback2.getEditor().getSelectionModel().getSelectedText();
            if (selectedText != null) {
                ZenCodingNode node2 = ZenCodingTemplate.parse(abbreviation, callback2, defaultGenerator, selectedText);
                assert (node2 != null);
                PsiElement context2 = callback2.getContext();
                ZenCodingGenerator generator2 = ZenCodingTemplate.findApplicableGenerator(node2, callback2, true);
                List<ZenCodingFilter> filters = ZenCodingTemplate.getFilters(node2, context2);
                EditorModificationUtil.deleteSelectedText((Editor)callback2.getEditor());
                PsiDocumentManager.getInstance((Project)callback2.getProject()).commitAllDocuments();
                try {
                    ZenCodingTemplate.expand(node2, generator2, filters, selectedText, callback2, true, Registry.intValue((String)"emmet.segments.limit"));
                }
                catch (EmmetException e) {
                    CommonRefactoringUtil.showErrorHint((Project)callback2.getProject(), (Editor)callback2.getEditor(), (String)e.getMessage(), (String)XmlBundle.message((String)"emmet.error", (Object[])new Object[0]), (String)"");
                }
            }
        }), AnalysisBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null));
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = XmlBundle.message((String)"emmet.title", (Object[])new Object[0]);
        if (string == null) {
            ZenCodingTemplate.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    public char getShortcut() {
        return (char)EmmetOptions.getInstance().getEmmetExpandShortcut();
    }

    @Override
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback2) {
        ZenCodingGenerator generator2;
        if (callback2 == null) {
            ZenCodingTemplate.$$$reportNull$$$0(23);
        }
        if ((generator2 = ZenCodingTemplate.findApplicableDefaultGenerator(callback2, false)) == null) {
            return null;
        }
        return generator2.computeTemplateKey(callback2);
    }

    @Override
    public boolean supportsWrapping() {
        return true;
    }

    @Override
    public void addCompletions(CompletionParameters parameters2, CompletionResultSet result2) {
        if (!parameters2.isAutoPopup()) {
            return;
        }
        PsiFile file2 = parameters2.getPosition().getContainingFile();
        int offset = parameters2.getOffset();
        Editor editor = parameters2.getEditor();
        CollectCustomTemplateCallback callback2 = new CollectCustomTemplateCallback(editor, file2);
        ZenCodingGenerator generator2 = ZenCodingTemplate.findApplicableDefaultGenerator(callback2, false);
        if (generator2 != null && generator2.addToCompletion()) {
            String templatePrefix = this.computeTemplateKeyWithoutContextChecking(callback2);
            if (templatePrefix != null) {
                List<TemplateImpl> regularTemplates = TemplateManagerImpl.listApplicableTemplates(TemplateActionContext.expanding((PsiFile)file2, (int)offset));
                boolean regularTemplateWithSamePrefixExists = !ContainerUtil.filter(regularTemplates, template -> templatePrefix.equals(template.getKey())).isEmpty();
                result2 = result2.withPrefixMatcher(result2.getPrefixMatcher().cloneWithPrefix(templatePrefix));
                result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().startsWith(templatePrefix));
                if (!regularTemplateWithSamePrefixExists) {
                    LinkedList extraFilters = ContainerUtil.newLinkedList((Object[])new SingleLineEmmetFilter[]{new SingleLineEmmetFilter()});
                    try {
                        ZenCodingTemplate.expand(templatePrefix, callback2, generator2, extraFilters, false, 0);
                    }
                    catch (EmmetException emmetException) {
                        // empty catch block
                    }
                    TemplateImpl template2 = callback2.getGeneratedTemplate();
                    if (template2 != null) {
                        template2.setKey(templatePrefix);
                        template2.setDescription(template2.getTemplateText());
                        CustomLiveTemplateLookupElement lookupElement = new CustomLiveTemplateLookupElement(this, template2.getKey(), template2.getKey(), template2.getDescription(), !LiveTemplateCompletionContributor.shouldShowAllTemplates(), true){

                            @Override
                            public void renderElement(LookupElementPresentation presentation2) {
                                super.renderElement(presentation2);
                                presentation2.setTailText("\t Emmet abbreviation", true);
                            }
                        };
                        result2.addElement((LookupElement)lookupElement);
                    }
                }
            } else if (result2.getPrefixMatcher().getPrefix().isEmpty()) {
                result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/ZenCodingTemplate";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultGenerator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraFilters";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abbreviation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/ZenCodingTemplate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableDefaultGenerator";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkTemplateKey";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 10: 
            case 22: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveNode";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasCompletionItem";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doWrap";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

