/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@ApiStatus.Internal
public class AsyncRendering {
    private static final Key<LookupElementPresentation> LAST_COMPUTED_PRESENTATION = Key.create((String)"LAST_COMPUTED_PRESENTATION");
    private static final Key<CancellablePromise<?>> LAST_COMPUTATION = Key.create((String)"LAST_COMPUTATION");
    private static final Executor ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"ExpensiveRendering");
    private final LookupImpl myLookup;

    AsyncRendering(LookupImpl lookup2) {
        this.myLookup = lookup2;
    }

    @NotNull
    LookupElementPresentation getLastComputed(@NotNull LookupElement element2) {
        if (element2 == null) {
            AsyncRendering.$$$reportNull$$$0(0);
        }
        LookupElementPresentation lookupElementPresentation = Objects.requireNonNull((LookupElementPresentation)element2.getUserData(LAST_COMPUTED_PRESENTATION));
        if (lookupElementPresentation == null) {
            AsyncRendering.$$$reportNull$$$0(1);
        }
        return lookupElementPresentation;
    }

    static void rememberPresentation(LookupElement element2, LookupElementPresentation presentation2) {
        element2.putUserData(LAST_COMPUTED_PRESENTATION, (Object)presentation2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleRendering(@NotNull LookupElement element2, @NotNull LookupElementRenderer<?> renderer2) {
        if (element2 == null) {
            AsyncRendering.$$$reportNull$$$0(2);
        }
        if (renderer2 == null) {
            AsyncRendering.$$$reportNull$$$0(3);
        }
        Key<CancellablePromise<?>> key = LAST_COMPUTATION;
        synchronized (key) {
            AsyncRendering.cancelRendering(element2);
            Ref promiseRef = Ref.create();
            CancellablePromise promise = ReadAction.nonBlocking(() -> {
                if (element2.isValid()) {
                    this.renderInBackground(element2, renderer2);
                }
                Key<CancellablePromise<?>> key = LAST_COMPUTATION;
                synchronized (key) {
                    element2.replace(LAST_COMPUTATION, (Object)((CancellablePromise)promiseRef.get()), null);
                }
            }).expireWith((Disposable)this.myLookup).submit(ourExecutor);
            element2.putUserData(LAST_COMPUTATION, (Object)promise);
            promiseRef.set((Object)promise);
        }
    }

    private void renderInBackground(LookupElement element2, LookupElementRenderer renderer2) {
        LookupElementPresentation presentation2 = new LookupElementPresentation();
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> renderer2.renderElement(element2, presentation2));
        presentation2.freeze();
        AsyncRendering.rememberPresentation(element2, presentation2);
        this.myLookup.myCellRenderer.scheduleUpdateLookupWidthFromVisibleItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelRendering(@NotNull LookupElement item) {
        if (item == null) {
            AsyncRendering.$$$reportNull$$$0(4);
        }
        Key<CancellablePromise<?>> key = LAST_COMPUTATION;
        synchronized (key) {
            CancellablePromise promise = (CancellablePromise)item.getUserData(LAST_COMPUTATION);
            if (promise != null) {
                promise.cancel();
                item.putUserData(LAST_COMPUTATION, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/impl/AsyncRendering";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/AsyncRendering";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastComputed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLastComputed";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRendering";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cancelRendering";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

