/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeAttributesIntention
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            RearrangeAttributesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"rearrange.tag.attributes", (Object[])new Object[0]);
        if (string == null) {
            RearrangeAttributesIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        XmlTag tag2;
        if (project == null) {
            RearrangeAttributesIntention.$$$reportNull$$$0(2);
        }
        if ((tag2 = RearrangeAttributesIntention.getTag(editor, file2)) == null) {
            return false;
        }
        if (tag2.getAttributes().length <= 1) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag2.getNode());
        return startEnd == null || offset <= startEnd.getTextRange().getEndOffset();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        XmlTag tag2;
        if (project == null) {
            RearrangeAttributesIntention.$$$reportNull$$$0(3);
        }
        if ((tag2 = RearrangeAttributesIntention.getTag(editor, file2)) == null) {
            return;
        }
        TextRange range2 = tag2.getTextRange();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag2.getNode());
        ASTNode name = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag2.getNode());
        TextRange reformatRange2 = new TextRange(name != null ? name.getTextRange().getEndOffset() + 1 : range2.getStartOffset() + 1, startEnd != null ? startEnd.getTextRange().getEndOffset() - 1 : range2.getEndOffset());
        final RangeMarker marker = editor.getDocument().createRangeMarker(reformatRange2);
        new RearrangeCodeProcessor(new ReformatCodeProcessor(project, file2, reformatRange2, false)){

            @Override
            public Collection<TextRange> getRangesToFormat(@NotNull PsiFile file2, boolean processChangedTextOnly) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return Collections.singleton(new TextRange(marker.getStartOffset(), marker.getEndOffset()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RearrangeAttributesIntention$1", "getRangesToFormat"));
            }
        }.run();
        editor.getCaretModel().moveToOffset(reformatRange2.getStartOffset());
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static XmlTag getTag(@Nullable Editor editor, PsiFile file2) {
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element2 = file2.findElementAt(offset);
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
        if (parent != null) {
            return parent;
        }
        element2 = file2.findElementAt(offset - 1);
        parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
        if (parent != null) {
            return parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RearrangeAttributesIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RearrangeAttributesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

