/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class PassExecutorService
implements Disposable {
    static final Logger LOG = Logger.getInstance(PassExecutorService.class);
    private static final boolean CHECK_CONSISTENCY = ApplicationManager.getApplication().isUnitTestMode();
    private final Map<ScheduledPass, Job<Void>> mySubmittedPasses;
    private final Project myProject;
    private final FileEditorManagerEx myFileEditorManager;
    private volatile boolean isDisposed;
    private final AtomicInteger nextAvailablePassId;
    private static final Key<Throwable> THROWABLE_KEY = Key.create((String)"THROWABLE_KEY");

    PassExecutorService(@NotNull Project project) {
        if (project == null) {
            PassExecutorService.$$$reportNull$$$0(0);
        }
        this.mySubmittedPasses = new ConcurrentHashMap<ScheduledPass, Job<Void>>();
        this.myProject = project;
        this.nextAvailablePassId = ((TextEditorHighlightingPassRegistrarImpl)TextEditorHighlightingPassRegistrar.getInstance(this.myProject)).getNextAvailableId();
        this.myFileEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)project);
    }

    public void dispose() {
        this.cancelAll(true);
        ForkJoinPool.commonPool().awaitQuiescence(1L, TimeUnit.SECONDS);
        this.isDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll(boolean waitForTermination) {
        for (Map.Entry<ScheduledPass, Job<Void>> entry2 : this.mySubmittedPasses.entrySet()) {
            Job<Void> job2 = entry2.getValue();
            ScheduledPass pass = entry2.getKey();
            pass.myUpdateProgress.cancel();
            job2.cancel();
        }
        try {
            if (waitForTermination) {
                while (!this.waitFor(50)) {
                    boolean bl = false;
                }
            }
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        finally {
            this.mySubmittedPasses.clear();
        }
    }

    void submitPasses(@NotNull Map<FileEditor, HighlightingPass[]> passesMap, @NotNull DaemonProgressIndicator updateProgress) {
        if (passesMap == null) {
            PassExecutorService.$$$reportNull$$$0(1);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(2);
        }
        if (this.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MultiMap documentToEditors = MultiMap.createSet();
        MultiMap documentBoundPasses = new MultiMap();
        MultiMap editorBoundPasses = new MultiMap();
        Map id2Pass = CollectionFactory.createSmallMemoryFootprintMap();
        ArrayList<ScheduledPass> freePasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 5);
        AtomicInteger threadsToStartCountdown = new AtomicInteger(0);
        for (Map.Entry<FileEditor, HighlightingPass[]> entry2 : passesMap.entrySet()) {
            HighlightingPass[] passes;
            FileEditor fileEditor = entry2.getKey();
            for (HighlightingPass pass : passes = entry2.getValue()) {
                Int2ObjectMap thisEditorId2Pass = id2Pass.computeIfAbsent(fileEditor, __ -> new Int2ObjectOpenHashMap(20));
                if (pass instanceof EditorBoundHighlightingPass) {
                    EditorBoundHighlightingPass editorPass = (EditorBoundHighlightingPass)pass;
                    int id2 = this.nextAvailablePassId.incrementAndGet();
                    editorPass.setId(id2);
                    PassExecutorService.checkUniquePassId(id2, editorPass, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
                    editorBoundPasses.putValue((Object)fileEditor, (Object)editorPass);
                    continue;
                }
                if (pass instanceof TextEditorHighlightingPass) {
                    TextEditorHighlightingPass tePass = (TextEditorHighlightingPass)pass;
                    PassExecutorService.checkUniquePassId(tePass.getId(), tePass, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
                    documentBoundPasses.putValue((Object)fileEditor, (Object)tePass);
                    documentToEditors.putValue((Object)tePass.getDocument(), (Object)fileEditor);
                    continue;
                }
                freePasses.add(new ScheduledPass(fileEditor, pass, updateProgress, threadsToStartCountdown));
            }
        }
        ArrayList<ScheduledPass> dependentPasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 10);
        Map toBeSubmitted = CollectionFactory.createSmallMemoryFootprintMap((int)passesMap.size());
        for (Map.Entry entry3 : documentToEditors.entrySet()) {
            Collection fileEditors = (Collection)entry3.getValue();
            Document document = (Document)entry3.getKey();
            FileEditor preferredFileEditor = this.getPreferredFileEditor(document, fileEditors);
            List passes = (List)documentBoundPasses.get((Object)preferredFileEditor);
            if (passes.isEmpty()) continue;
            PassExecutorService.sortById(passes);
            for (TextEditorHighlightingPass currentPass : passes) {
                this.createScheduledPass(preferredFileEditor, currentPass, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        for (Map.Entry entry3 : editorBoundPasses.entrySet()) {
            FileEditor fileEditor = (FileEditor)entry3.getKey();
            Collection createdEditorBoundPasses = (Collection)entry3.getValue();
            for (HighlightingPass pass : createdEditorBoundPasses) {
                this.createScheduledPass(fileEditor, (TextEditorHighlightingPass)pass, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        if (CHECK_CONSISTENCY && !ApplicationManagerEx.isInStressTest()) {
            this.assertConsistency(freePasses, toBeSubmitted, threadsToStartCountdown);
        }
        if (LOG.isDebugEnabled()) {
            Set vFiles = ContainerUtil.map2Set(passesMap.keySet(), FileEditor::getFile);
            PassExecutorService.log(updateProgress, null, vFiles + " ----- starting " + threadsToStartCountdown.get(), freePasses);
        }
        for (ScheduledPass dependentPass : dependentPasses) {
            this.mySubmittedPasses.put(dependentPass, Job.nullJob());
        }
        for (ScheduledPass freePass : freePasses) {
            this.submit(freePass);
        }
    }

    private static void checkUniquePassId(int id2, @NotNull TextEditorHighlightingPass pass, @NotNull Int2ObjectMap<TextEditorHighlightingPass> id2Pass) {
        TextEditorHighlightingPass prevPass;
        if (pass == null) {
            PassExecutorService.$$$reportNull$$$0(3);
        }
        if (id2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(4);
        }
        if ((prevPass = (TextEditorHighlightingPass)id2Pass.put(id2, (Object)pass)) != null) {
            LOG.error("Duplicate pass id found: " + id2 + ". Both passes returned the same getId(): " + prevPass + " (" + prevPass.getClass() + ") and " + pass + " (" + pass.getClass() + ")");
        }
    }

    private void assertConsistency(@NotNull List<ScheduledPass> freePasses, @NotNull Map<FileEditor, Int2ObjectMap<ScheduledPass>> toBeSubmitted, @NotNull AtomicInteger threadsToStartCountdown) {
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(5);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(6);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(7);
        }
        assert (threadsToStartCountdown.get() == toBeSubmitted.values().stream().mapToInt(m -> m.size()).sum());
        Int2ObjectOpenHashMap id2Visits = new Int2ObjectOpenHashMap();
        for (ScheduledPass freePass : freePasses) {
            HighlightingPass pass = freePass.myPass;
            if (!(pass instanceof TextEditorHighlightingPass)) continue;
            id2Visits.put(((TextEditorHighlightingPass)pass).getId(), (Object)Pair.create((Object)freePass, (Object)0));
            this.checkConsistency(freePass, (Int2ObjectMap<Pair<ScheduledPass, Integer>>)id2Visits);
        }
        for (Int2ObjectMap.Entry entry2 : id2Visits.int2ObjectEntrySet()) {
            int count = (Integer)((Pair)entry2.getValue()).second;
            assert (count == 0) : entry2.getIntKey();
        }
        assert (id2Visits.size() == threadsToStartCountdown.get());
    }

    private void checkConsistency(@NotNull ScheduledPass pass, @NotNull Int2ObjectMap<Pair<ScheduledPass, Integer>> id2Visits) {
        if (id2Visits == null) {
            PassExecutorService.$$$reportNull$$$0(8);
        }
        if (pass == null) {
            PassExecutorService.$$$reportNull$$$0(9);
        }
        for (ScheduledPass succ : ContainerUtil.concat(pass.mySuccessorsOnCompletion, pass.mySuccessorsOnSubmit)) {
            int succId = ((TextEditorHighlightingPass)succ.myPass).getId();
            Pair succPair = (Pair)id2Visits.get(succId);
            if (succPair == null) {
                succPair = Pair.create((Object)succ, (Object)succ.myRunningPredecessorsCount.get());
                id2Visits.put(succId, (Object)succPair);
            }
            int newPred = (Integer)succPair.second - 1;
            id2Visits.put(succId, (Object)Pair.create((Object)succ, (Object)newPred));
            assert (newPred >= 0);
            if (newPred != 0) continue;
            this.checkConsistency(succ, id2Visits);
        }
    }

    @NotNull
    private FileEditor getPreferredFileEditor(@NotNull Document document, @NotNull Collection<? extends FileEditor> fileEditors) {
        FileEditor selected2;
        if (document == null) {
            PassExecutorService.$$$reportNull$$$0(10);
        }
        if (fileEditors == null) {
            PassExecutorService.$$$reportNull$$$0(11);
        }
        assert (!fileEditors.isEmpty());
        FileEditor focusedEditor = (FileEditor)ContainerUtil.find(fileEditors, it -> it instanceof TextEditor && ((TextEditor)it).getEditor().getContentComponent().isFocusOwner());
        if (focusedEditor != null) {
            FileEditor fileEditor = focusedEditor;
            if (fileEditor == null) {
                PassExecutorService.$$$reportNull$$$0(12);
            }
            return fileEditor;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && (selected2 = this.myFileEditorManager.getSelectedEditor(file2)) != null && fileEditors.contains(selected2)) {
            FileEditor fileEditor = selected2;
            if (fileEditor == null) {
                PassExecutorService.$$$reportNull$$$0(13);
            }
            return fileEditor;
        }
        FileEditor fileEditor = fileEditors.iterator().next();
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(14);
        }
        return fileEditor;
    }

    @NotNull
    private ScheduledPass createScheduledPass(@NotNull FileEditor fileEditor, @NotNull TextEditorHighlightingPass pass, @NotNull Map<FileEditor, Int2ObjectMap<ScheduledPass>> toBeSubmitted, @NotNull Map<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>> id2Pass, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown) {
        ScheduledPass predecessor;
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(15);
        }
        if (pass == null) {
            PassExecutorService.$$$reportNull$$$0(16);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(17);
        }
        if (id2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(18);
        }
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(19);
        }
        if (dependentPasses == null) {
            PassExecutorService.$$$reportNull$$$0(20);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(21);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(22);
        }
        Int2ObjectMap thisEditorId2ScheduledPass = toBeSubmitted.computeIfAbsent(fileEditor, __ -> new Int2ObjectOpenHashMap(20));
        Int2ObjectMap thisEditorId2Pass = id2Pass.computeIfAbsent(fileEditor, __ -> new Int2ObjectOpenHashMap(20));
        int passId = pass.getId();
        ScheduledPass scheduledPass = (ScheduledPass)thisEditorId2ScheduledPass.get(passId);
        if (scheduledPass != null) {
            ScheduledPass scheduledPass2 = scheduledPass;
            if (scheduledPass2 == null) {
                PassExecutorService.$$$reportNull$$$0(23);
            }
            return scheduledPass2;
        }
        scheduledPass = new ScheduledPass(fileEditor, pass, updateProgress, threadsToStartCountdown);
        threadsToStartCountdown.incrementAndGet();
        thisEditorId2ScheduledPass.put(passId, (Object)scheduledPass);
        for (int predecessorId : pass.getCompletionPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId, (Int2ObjectMap<ScheduledPass>)thisEditorId2ScheduledPass, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnCompletion(scheduledPass);
        }
        for (int predecessorId : pass.getStartingPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId, (Int2ObjectMap<ScheduledPass>)thisEditorId2ScheduledPass, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnSubmit(scheduledPass);
        }
        if (scheduledPass.myRunningPredecessorsCount.get() == 0 && !freePasses.contains(scheduledPass)) {
            freePasses.add(scheduledPass);
        } else if (!dependentPasses.contains(scheduledPass)) {
            dependentPasses.add(scheduledPass);
        }
        if (pass.isRunIntentionPassAfter() && fileEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)fileEditor).getEditor();
            ShowIntentionsPass ip = new ShowIntentionsPass(this.myProject, editor, false);
            int id2 = this.nextAvailablePassId.incrementAndGet();
            ip.setId(id2);
            PassExecutorService.checkUniquePassId(id2, ip, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
            ip.setCompletionPredecessorIds(new int[]{passId});
            this.createScheduledPass(fileEditor, ip, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
        }
        ScheduledPass scheduledPass3 = scheduledPass;
        if (scheduledPass3 == null) {
            PassExecutorService.$$$reportNull$$$0(24);
        }
        return scheduledPass3;
    }

    private ScheduledPass findOrCreatePredecessorPass(@NotNull FileEditor fileEditor, @NotNull Map<FileEditor, Int2ObjectMap<ScheduledPass>> toBeSubmitted, @NotNull Map<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>> id2Pass, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger myThreadsToStartCountdown, int predecessorId, @NotNull Int2ObjectMap<ScheduledPass> thisEditorId2ScheduledPass, @NotNull Int2ObjectMap<TextEditorHighlightingPass> thisEditorId2Pass) {
        ScheduledPass predecessor;
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(25);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(26);
        }
        if (id2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(27);
        }
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(28);
        }
        if (dependentPasses == null) {
            PassExecutorService.$$$reportNull$$$0(29);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(30);
        }
        if (myThreadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(31);
        }
        if (thisEditorId2ScheduledPass == null) {
            PassExecutorService.$$$reportNull$$$0(32);
        }
        if (thisEditorId2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(33);
        }
        if ((predecessor = (ScheduledPass)thisEditorId2ScheduledPass.get(predecessorId)) == null) {
            TextEditorHighlightingPass textEditorPass = (TextEditorHighlightingPass)thisEditorId2Pass.get(predecessorId);
            predecessor = textEditorPass == null ? null : this.createScheduledPass(fileEditor, textEditorPass, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, myThreadsToStartCountdown);
        }
        return predecessor;
    }

    private void submit(@NotNull ScheduledPass pass) {
        if (pass == null) {
            PassExecutorService.$$$reportNull$$$0(34);
        }
        if (!pass.myUpdateProgress.isCanceled()) {
            Job<Void> job2 = JobLauncher.getInstance().submitToJobThread(pass, future2 -> {
                try {
                    if (!future2.isCancelled()) {
                        future2.get();
                    }
                }
                catch (InterruptedException | CancellationException exception) {
                }
                catch (ExecutionException e) {
                    LOG.error(e.getCause());
                }
            });
            this.mySubmittedPasses.put(pass, job2);
        }
    }

    private void applyInformationToEditorsLater(@NotNull FileEditor fileEditor, @NotNull HighlightingPass pass, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown, @NotNull Runnable callbackOnApplied) {
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(35);
        }
        if (pass == null) {
            PassExecutorService.$$$reportNull$$$0(36);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(37);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(38);
        }
        if (callbackOnApplied == null) {
            PassExecutorService.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed() || !fileEditor.isValid()) {
                updateProgress.cancel();
            }
            if (updateProgress.isCanceled()) {
                PassExecutorService.log(updateProgress, pass, " is canceled during apply, sorry");
                return;
            }
            try {
                if (UIUtil.isShowing((Component)fileEditor.getComponent())) {
                    pass.applyInformationToEditor();
                    this.repaintErrorStripeAndIcon(fileEditor);
                    if (pass instanceof TextEditorHighlightingPass) {
                        FileStatusMap fileStatusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
                        Document document = ((TextEditorHighlightingPass)pass).getDocument();
                        int passId = ((TextEditorHighlightingPass)pass).getId();
                        fileStatusMap.markFileUpToDate(document, passId);
                    }
                    PassExecutorService.log(updateProgress, pass, " Applied");
                }
            }
            catch (ProcessCanceledException e) {
                PassExecutorService.log(updateProgress, pass, "Error " + e);
                throw e;
            }
            catch (RuntimeException e) {
                VirtualFile file2 = fileEditor.getFile();
                FileType fileType = file2 == null ? null : file2.getFileType();
                String message2 = "Exception while applying information to " + fileEditor + "(" + fileType + ")";
                PassExecutorService.log(updateProgress, pass, message2 + e);
                throw new RuntimeException(message2, e);
            }
            if (threadsToStartCountdown.decrementAndGet() == 0) {
                HighlightingSessionImpl.waitForAllSessionsHighlightInfosApplied(updateProgress);
                PassExecutorService.log(updateProgress, pass, "Stopping ");
                updateProgress.stopIfRunning();
                this.clearStaleEntries();
            } else {
                PassExecutorService.log(updateProgress, pass, "Finished but there are passes in the queue: " + threadsToStartCountdown.get());
            }
            callbackOnApplied.run();
        }, updateProgress.getModalityState(), pass.getExpiredCondition());
    }

    private void clearStaleEntries() {
        this.mySubmittedPasses.keySet().removeIf(pass -> pass.myUpdateProgress.isCanceled());
    }

    private void repaintErrorStripeAndIcon(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(40);
        }
        if (fileEditor instanceof TextEditor) {
            DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(((TextEditor)fileEditor).getEditor(), this.myProject);
        }
    }

    private boolean isDisposed() {
        return this.isDisposed || this.myProject.isDisposed();
    }

    @NotNull
    List<HighlightingPass> getAllSubmittedPasses() {
        ArrayList<HighlightingPass> result2 = new ArrayList<HighlightingPass>(this.mySubmittedPasses.size());
        for (ScheduledPass scheduledPass : this.mySubmittedPasses.keySet()) {
            if (scheduledPass.myUpdateProgress.isCanceled()) continue;
            result2.add(scheduledPass.myPass);
        }
        ArrayList<HighlightingPass> arrayList = result2;
        if (arrayList == null) {
            PassExecutorService.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    private static void sortById(@NotNull List<? extends TextEditorHighlightingPass> result2) {
        if (result2 == null) {
            PassExecutorService.$$$reportNull$$$0(42);
        }
        ContainerUtil.quickSort(result2, Comparator.comparingInt(TextEditorHighlightingPass::getId));
    }

    private static int getThreadNum() {
        Matcher matcher = Pattern.compile("JobScheduler FJ pool (\\d*)/(\\d*)").matcher(Thread.currentThread().getName());
        String num = matcher.matches() ? matcher.group(1) : null;
        return StringUtil.parseInt((String)num, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void log(ProgressIndicator progressIndicator, HighlightingPass pass, Object ... info2) {
        if (info2 == null) {
            PassExecutorService.$$$reportNull$$$0(43);
        }
        if (!LOG.isDebugEnabled()) return;
        Document document = pass instanceof TextEditorHighlightingPass ? ((TextEditorHighlightingPass)pass).getDocument() : null;
        String docText = document == null ? "" : ": '" + StringUtil.first((CharSequence)document.getCharsSequence(), (int)10, (boolean)true) + "'";
        Class<PassExecutorService> clazz = PassExecutorService.class;
        synchronized (PassExecutorService.class) {
            String infos = StringUtil.join((Object[])info2, (Function)Functions.TO_STRING(), (String)" ");
            String message2 = StringUtil.repeatSymbol((char)' ', (int)(PassExecutorService.getThreadNum() * 4)) + " " + pass + " " + infos + "; progress=" + (progressIndicator == null ? null : Integer.valueOf(progressIndicator.hashCode())) + " " + (progressIndicator == null ? "?" : (progressIndicator.isCanceled() ? "X" : "V")) + docText;
            LOG.debug(message2);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private static void saveException(@NotNull Throwable e, @NotNull DaemonProgressIndicator indicator2) {
        if (e == null) {
            PassExecutorService.$$$reportNull$$$0(44);
        }
        if (indicator2 == null) {
            PassExecutorService.$$$reportNull$$$0(45);
        }
        indicator2.putUserDataIfAbsent(THROWABLE_KEY, e);
    }

    @TestOnly
    static Throwable getSavedException(@NotNull DaemonProgressIndicator indicator2) {
        if (indicator2 == null) {
            PassExecutorService.$$$reportNull$$$0(46);
        }
        return (Throwable)indicator2.getUserData(THROWABLE_KEY);
    }

    boolean waitFor(int millis) throws Throwable {
        try {
            for (Job<Void> job2 : this.mySubmittedPasses.values()) {
                job2.waitForCompletion(millis);
            }
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesMap";
                break;
            }
            case 2: 
            case 21: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProgress";
                break;
            }
            case 3: 
            case 9: 
            case 16: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 4: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id2Pass";
                break;
            }
            case 5: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freePasses";
                break;
            }
            case 6: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBeSubmitted";
                break;
            }
            case 7: 
            case 22: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadsToStartCountdown";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id2Visits";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditors";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/PassExecutorService";
                break;
            }
            case 15: 
            case 25: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPasses";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myThreadsToStartCountdown";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisEditorId2ScheduledPass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisEditorId2Pass";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackOnApplied";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PassExecutorService";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFileEditor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createScheduledPass";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubmittedPasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "submitPasses";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkUniquePassId";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertConsistency";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkConsistency";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredFileEditor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 41: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createScheduledPass";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreatePredecessorPass";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "applyInformationToEditorsLater";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "repaintErrorStripeAndIcon";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "sortById";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "saveException";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getSavedException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ScheduledPass
    implements Runnable {
        private final FileEditor myFileEditor;
        private final HighlightingPass myPass;
        private final AtomicInteger myThreadsToStartCountdown;
        private final AtomicInteger myRunningPredecessorsCount;
        private final List<ScheduledPass> mySuccessorsOnCompletion;
        private final List<ScheduledPass> mySuccessorsOnSubmit;
        @NotNull
        private final DaemonProgressIndicator myUpdateProgress;

        private ScheduledPass(@NotNull FileEditor fileEditor, @NotNull HighlightingPass pass, @NotNull DaemonProgressIndicator progressIndicator, AtomicInteger threadsToStartCountdown) {
            if (fileEditor == null) {
                ScheduledPass.$$$reportNull$$$0(0);
            }
            if (pass == null) {
                ScheduledPass.$$$reportNull$$$0(1);
            }
            if (progressIndicator == null) {
                ScheduledPass.$$$reportNull$$$0(2);
            }
            if (threadsToStartCountdown == null) {
                ScheduledPass.$$$reportNull$$$0(3);
            }
            this.myRunningPredecessorsCount = new AtomicInteger(0);
            this.mySuccessorsOnCompletion = new ArrayList<ScheduledPass>();
            this.mySuccessorsOnSubmit = new ArrayList<ScheduledPass>();
            this.myFileEditor = fileEditor;
            this.myPass = pass;
            this.myThreadsToStartCountdown = threadsToStartCountdown;
            this.myUpdateProgress = progressIndicator;
        }

        @Override
        public void run() {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeByImpatientReader(() -> {
                try {
                    this.doRun();
                }
                catch (ApplicationUtil.CannotRunReadActionException e) {
                    this.myUpdateProgress.cancel();
                }
                catch (Error | RuntimeException e) {
                    PassExecutorService.saveException(e, this.myUpdateProgress);
                    throw e;
                }
            });
        }

        private void doRun() {
            if (this.myUpdateProgress.isCanceled()) {
                return;
            }
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Started. ");
            for (ScheduledPass successor : this.mySuccessorsOnSubmit) {
                int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                if (predecessorsToRun != 0) continue;
                PassExecutorService.this.submit(successor);
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                boolean success2 = ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                    try {
                        if (DumbService.getInstance((Project)PassExecutorService.this.myProject).isDumb() && !DumbService.isDumbAware((Object)this.myPass)) {
                            return;
                        }
                        if (!this.myUpdateProgress.isCanceled() && !PassExecutorService.this.myProject.isDisposed()) {
                            this.myPass.collectInformation((ProgressIndicator)this.myUpdateProgress);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        PassExecutorService.log(this.myUpdateProgress, this.myPass, "Canceled ");
                        if (!this.myUpdateProgress.isCanceled()) {
                            this.myUpdateProgress.cancel(e);
                        }
                    }
                    catch (Error | RuntimeException e) {
                        this.myUpdateProgress.cancel(e);
                        LOG.error(e);
                        throw e;
                    }
                });
                if (!success2) {
                    this.myUpdateProgress.cancel();
                }
            }, (ProgressIndicator)this.myUpdateProgress);
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Finished. ");
            if (!this.myUpdateProgress.isCanceled()) {
                PassExecutorService.this.applyInformationToEditorsLater(this.myFileEditor, this.myPass, this.myUpdateProgress, this.myThreadsToStartCountdown, () -> {
                    for (ScheduledPass successor : this.mySuccessorsOnCompletion) {
                        int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                        if (predecessorsToRun != 0) continue;
                        PassExecutorService.this.submit(successor);
                    }
                });
            }
        }

        @NonNls
        public String toString() {
            return "SP: " + this.myPass;
        }

        private void addSuccessorOnCompletion(@NotNull ScheduledPass successor) {
            if (successor == null) {
                ScheduledPass.$$$reportNull$$$0(4);
            }
            this.mySuccessorsOnCompletion.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private void addSuccessorOnSubmit(@NotNull ScheduledPass successor) {
            if (successor == null) {
                ScheduledPass.$$$reportNull$$$0(5);
            }
            this.mySuccessorsOnSubmit.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadsToStartCountdown";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "successor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessorOnCompletion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessorOnSubmit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

